/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.swimlanes.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.graphic.composite.IlvCompositeGraphic;
import ilog.views.graphic.composite.layout.IlvLayoutManager;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.UIManager;
import oracle.diagram.framework.graphic.DiagramRenderingHints;
import oracle.diagram.framework.graphic.layout.Anchor;
import oracle.diagram.framework.selection.SubSelectionManager;
import oracle.diagram.framework.swimlanes.SwimlanesContentsProvider;
import oracle.diagram.framework.swimlanes.graphic.AbstractHeaderGraphic;
import oracle.diagram.framework.swimlanes.graphic.PoolGraphic;
import oracle.diagram.framework.swimlanes.graphic.SwimlaneGraphic;
import oracle.diagram.framework.swimlanes.graphic.SwimlaneGraphicConstraint;
import oracle.ide.thumbnail.ThumbnailConstants;

public abstract class ExtendedSwimlaneGraphic
extends SwimlaneGraphic {
    private SwimlaneGraphic _pool;
    private AbstractHeaderGraphic _header;
    public static final Color SELECTION_BACKGROUND_COLOR = UIManager.getDefaults().getColor("TextField.selectionBackground");
    public static final Color SELECTION_FOREGROUND_COLOR = UIManager.getDefaults().getColor("TextField.selectionForeground");

    protected ExtendedSwimlaneGraphic(IlvRect rect) {
        super(rect);
    }

    protected ExtendedSwimlaneGraphic(IlvRect rect, IlvLayoutManager layoutManager) {
        super(rect, layoutManager);
    }

    public void setTitle(String title) {
        this.setTitle(title, Anchor.CENTER);
    }

    public void setTitle(String title, Anchor titleAnchor) {
        AbstractHeaderGraphic header = this.getHeader();
        if (header != null && header.getTextAnchor() == titleAnchor && title != null && title.trim().length() > 0) {
            if (!title.equals(header.getLabel())) {
                header.setLabel(title);
            }
        } else {
            this.addSubComponents(title, titleAnchor, this.getPool());
            this.invalidate(true);
            this.doLayout();
            this.reDraw();
        }
    }

    public void setPoolGraphic(PoolGraphic pool) {
        if (pool != this.getPool()) {
            this.addSubComponents(this.getHeader() != null ? this.getHeader().getLabel() : null, this.getHeader() != null ? this.getHeader().getTextAnchor() : null, pool);
        }
    }

    protected abstract void addSubComponents(String var1, Anchor var2, SwimlaneGraphic var3);

    protected void setHeader(AbstractHeaderGraphic header) {
        this._header = header;
        if (this._header != null) {
            this._header.setProperty("ParentSelection", true);
        }
    }

    public AbstractHeaderGraphic getHeader() {
        return this._header;
    }

    protected void setPool(SwimlaneGraphic pool) {
        this._pool = pool;
    }

    public SwimlaneGraphic getPool() {
        return this._pool;
    }

    public IlvSelection makeSelection() {
        return new ExtendedSwimlaneSelection((IlvGraphic)this);
    }

    @Override
    protected void drawImpl(Graphics2D g2d, IlvRect clipRect, IlvTransformer tx) {
        boolean isThumbnail = Boolean.TRUE.equals(g2d.getRenderingHint(ThumbnailConstants.THUMBNAIL_RENDERING_HINT));
        boolean isPublish = Boolean.TRUE.equals(g2d.getRenderingHint(DiagramRenderingHints.PUBLISH_RENDERING_HINT));
        SubSelectionManager ssm = SubSelectionManager.getInstance();
        SwimlaneGraphic topSwimlane = this.getTopSwimlane();
        boolean isSelected = ssm.isSelected((IlvGraphic)topSwimlane, (IlvGraphic)this);
        Color fillColor = this.getShapeFillColor();
        Color fontColor = this.getShapeFontColor();
        Color headerFillColor = null;
        Color headerFontColor = null;
        if (isSelected && !isThumbnail && !isPublish) {
            this.setShapeFillColor(SELECTION_BACKGROUND_COLOR);
            this.setShapeFontColor(SELECTION_FOREGROUND_COLOR);
            if (this.getHeader() != null) {
                headerFillColor = this.getHeader().getShapeFillColor();
                this.getHeader().setShapeFillColor(SELECTION_BACKGROUND_COLOR);
                headerFontColor = this.getHeader().getShapeFontColor();
                this.getHeader().setShapeFontColor(SELECTION_FOREGROUND_COLOR);
            }
        }
        super.drawImpl(g2d, clipRect, tx);
        this.setShapeFillColor(fillColor);
        this.setShapeFontColor(fontColor);
        if (this.getHeader() != null) {
            this.getHeader().setShapeFillColor(headerFillColor);
            this.getHeader().setShapeFontColor(headerFontColor);
        }
    }

    @Override
    protected void fixDoLayoutImpl() {
        if (this.getHeader() != null && this.getHeader() instanceof IlvCompositeGraphic) {
            ExtendedSwimlaneGraphic.doLayoutCompositeGraphic(this.getHeader());
        }
    }

    private static void doLayoutCompositeGraphic(IlvCompositeGraphic cg) {
        IlvGraphic[] children;
        for (IlvGraphic child : children = cg.getChildren()) {
            if (!(child instanceof IlvCompositeGraphic)) continue;
            ((IlvCompositeGraphic)child).doLayout();
            ExtendedSwimlaneGraphic.doLayoutCompositeGraphic((IlvCompositeGraphic)child);
        }
    }

    @Override
    protected int getSwimlaneGraphicConstraintsImpl(LinkedList<SwimlaneGraphicConstraint> constraints, int startIndex) {
        int nextIndex = startIndex;
        SwimlaneGraphic pool = this.getPool();
        if (pool != null) {
            nextIndex = pool.getSwimlaneGraphicConstraintsImpl(constraints, nextIndex);
        }
        return super.getSwimlaneGraphicConstraintsImpl(constraints, nextIndex);
    }

    protected IlvRect computeContentsBBox() {
        SwimlanesContentsProvider provider = this.getContentsProvider();
        if (provider != null) {
            float border = this.getOutline().isBorderOn() ? this.getShapeLineThickness().floatValue() : 0.0f;
            IlvRect r = new IlvRect(this.boundingBox(null));
            r.width = border;
            r.height = border;
            Collection<IlvGraphic> graphics = provider.getGraphicsInSwimlane(this);
            if (graphics != null && !graphics.isEmpty()) {
                for (IlvGraphic g : graphics) {
                    r.add(g.boundingBox(null));
                }
                r.width += border;
                r.height += border;
            }
            return r;
        }
        return null;
    }

    private static IlvRect getSelectionBoundingBox(ExtendedSwimlaneGraphic sg, IlvTransformer tx) {
        return sg.getPool() != null && sg.getHeader() != null ? sg.getHeader().boundingBox(tx) : sg.boundingBox(tx);
    }

    private static class ExtendedSwimlaneSelection
    extends IlvSelection {
        public ExtendedSwimlaneSelection(IlvGraphic object) {
            super(object);
        }

        public boolean isOptimizedDrawingEnabled() {
            return false;
        }

        public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        }

        public IlvRect boundingBox(IlvTransformer ilvTransformer) {
            ExtendedSwimlaneGraphic sg = (ExtendedSwimlaneGraphic)this.getObject();
            return ExtendedSwimlaneGraphic.getSelectionBoundingBox(sg, ilvTransformer);
        }
    }
}

