/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.swimlanes.features;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import java.awt.Frame;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.framework.graphic.features.DefaultDistributePlugin;
import oracle.diagram.framework.graphic.features.DistributePanel;
import oracle.diagram.framework.swimlanes.SwimlanesPlugin;
import oracle.diagram.framework.swimlanes.graphic.SwimlaneGraphic;
import oracle.ide.Ide;

public class SwimlanesDistributePlugin
extends DefaultDistributePlugin {
    public SwimlanesDistributePlugin(DiagramContext context) {
        super(context);
    }

    @Override
    public boolean configureDistribute() {
        DistributePanel dPanel;
        boolean disableHorizontal = false;
        boolean disableVertical = false;
        SwimlanesPlugin plugin = this.getDiagramContext().getPlugin(SwimlanesPlugin.class);
        IlvManager mgr = this.getDiagramContext().getManagerView().getManager();
        if (plugin != null && plugin.getTopSwimlane(mgr) != null) {
            SwimlaneGraphic sg = null;
            IlvGraphicEnumeration selection = mgr.getSelectedObjects(true);
            if (selection.hasMoreElements()) {
                sg = plugin.getSwimlaneForGraphic(selection.nextElement());
                while (selection.hasMoreElements()) {
                    IlvGraphic element = selection.nextElement();
                    if (element instanceof IlvLinkImage || sg == plugin.getSwimlaneForGraphic(element)) continue;
                    SwimlaneGraphic topSwimlane = plugin.getTopSwimlane(mgr);
                    int flow = topSwimlane.getFlowDirection();
                    if (flow == 8 || flow == 4) {
                        disableHorizontal = true;
                        break;
                    }
                    if (flow != 1 && flow != 2) break;
                    disableVertical = true;
                    break;
                }
            }
        }
        if ((dPanel = new DistributePanel(disableHorizontal, disableVertical)).showDialog((Frame)Ide.getMainWindow())) {
            this.setDistributeFormat(dPanel.getDistributeFormat());
        }
        return true;
    }
}

