/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.readonly;

import ilog.views.IlvGraphic;
import java.net.URL;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.context.IdeContextPlugin;
import oracle.diagram.core.plugin.PluginUtil;
import oracle.diagram.framework.readonly.AbstractDiagramReadOnlyPlugin;
import oracle.diagram.framework.readonly.LinkReadOnlyPlugin;
import oracle.diagram.framework.readonly.ModificationContext;
import oracle.diagram.framework.readonly.ReadOnlyPlugin;
import oracle.ide.net.URLFileSystem;
import oracle.ide.vcs.VCSManager;

public class DefaultDiagramReadOnlyPlugin
extends AbstractDiagramReadOnlyPlugin {
    public DefaultDiagramReadOnlyPlugin(DiagramContext context) {
        super(context);
    }

    @Override
    public boolean isPermanentReadOnly() {
        URL url = this.getDiagramContext().getPlugin(IdeContextPlugin.class).getContext().getNode().getURL();
        boolean isReadOnly = URLFileSystem.isReadOnly((URL)url);
        if (isReadOnly && VCSManager.getVCSManager().isVersioned(url)) {
            return !VCSManager.getVCSManager().canCheckOut(url);
        }
        return isReadOnly;
    }

    @Override
    public boolean checkWritable(Object operationIdentifier, ModificationContext context) {
        if (ModificationContext.OperationCode.AddToDiagram.equals(operationIdentifier)) {
            return this.checkWritableAddToDiagram(context);
        }
        if (ModificationContext.OperationCode.Layout.equals(operationIdentifier)) {
            return this.checkWritableLayout(context);
        }
        if (ModificationContext.OperationCode.Drop.equals(operationIdentifier)) {
            return this.checkWritableDrop((ModificationContext.DropContext)context);
        }
        if (ModificationContext.OperationCode.Cut.equals(operationIdentifier)) {
            return this.checkWritableCut((ModificationContext.CutContext)context);
        }
        if (ModificationContext.OperationCode.Paste.equals(operationIdentifier)) {
            return this.checkWritablePaste((ModificationContext.PasteContext)context);
        }
        if (ModificationContext.OperationCode.EditorOnly.equals(operationIdentifier)) {
            return this.checkWritableEditorOnly();
        }
        if (ModificationContext.OperationCode.MoveGraphics.equals(operationIdentifier)) {
            return this.checkWritableMoveGraphics((ModificationContext.MoveGraphicsContext)context);
        }
        if (ModificationContext.OperationCode.ResizeNode.equals(operationIdentifier)) {
            return this.checkWritableResizeNode((ModificationContext.ResizeNodeContext)context);
        }
        if (ModificationContext.OperationCode.ReshapeLink.equals(operationIdentifier)) {
            return this.checkWritableReshapeLink((ModificationContext.ReshapeLinkContext)context);
        }
        if (ModificationContext.OperationCode.Edit.equals(operationIdentifier)) {
            return this.checkWritableEdit((ModificationContext.EditContext)context);
        }
        if (ModificationContext.OperationCode.CreateNode.equals(operationIdentifier)) {
            return this.checkWritableCreateNode((ModificationContext.CreateNodeContext)context);
        }
        if (ModificationContext.OperationCode.CreateLink.equals(operationIdentifier)) {
            return this.checkWritableCreateLink((ModificationContext.CreateLinkContext)context);
        }
        if (ModificationContext.OperationCode.ReconnectLink.equals(operationIdentifier)) {
            return this.checkWritableReconnectLink((ModificationContext.ReconnectLinkContext)context);
        }
        if (ModificationContext.OperationCode.Delete.equals(operationIdentifier)) {
            return this.checkWritableDelete((ModificationContext.DeleteContext)context);
        }
        return false;
    }

    protected boolean checkWritableDefault(IlvGraphic ... graphics) {
        boolean status = this.checkWritableDiagram();
        if (!status) {
            return false;
        }
        if (graphics != null) {
            for (IlvGraphic g : graphics) {
                if (g == null || (status &= this.checkWritableGraphic(g))) continue;
                return false;
            }
        }
        return status;
    }

    protected boolean checkWritableLayout(ModificationContext context) {
        return this.checkWritableDiagram();
    }

    protected boolean checkWritableAddToDiagram(ModificationContext context) {
        return this.checkWritableDiagram();
    }

    protected boolean checkWritableMoveGraphics(ModificationContext.MoveGraphicsContext moveGraphicContext) {
        return this.checkWritableDiagram();
    }

    protected boolean checkWritableResizeNode(ModificationContext.ResizeNodeContext resizeNodeContext) {
        return this.checkWritableDiagram();
    }

    protected boolean checkWritableReshapeLink(ModificationContext.ReshapeLinkContext reshapeLinkContext) {
        return this.checkWritableDiagram();
    }

    protected boolean checkWritableEdit(ModificationContext.EditContext editContext) {
        return this.checkWritableDefault(editContext.getGraphic());
    }

    protected boolean checkWritableCreateNode(ModificationContext.CreateNodeContext createNodeContext) {
        return this.checkWritableDefault(createNodeContext.getParent());
    }

    protected boolean checkWritableCreateLink(ModificationContext.CreateLinkContext createLinkContext) {
        LinkReadOnlyPlugin p;
        if (createLinkContext.getCreationGraphic() != null && (p = PluginUtil.getPlugin(this.getDiagramContext(), createLinkContext.getCreationGraphic(), LinkReadOnlyPlugin.class)) != null) {
            DiagramContext dContext = this.getDiagramContext();
            if (!p.isWritable(dContext, createLinkContext)) {
                return p.setWritable(dContext, createLinkContext);
            }
            return true;
        }
        return this.checkWritableDefault(createLinkContext.getParent(), createLinkContext.getFromGraphic(), createLinkContext.getToGraphic());
    }

    protected boolean checkWritableReconnectLink(ModificationContext.ReconnectLinkContext reconnectLinkContext) {
        LinkReadOnlyPlugin p;
        if (reconnectLinkContext.getLink() != null && (p = PluginUtil.getPlugin(this.getDiagramContext(), (IlvGraphic)reconnectLinkContext.getLink(), LinkReadOnlyPlugin.class)) != null) {
            DiagramContext dContext = this.getDiagramContext();
            if (!p.isWritable(dContext, reconnectLinkContext)) {
                return p.setWritable(dContext, reconnectLinkContext);
            }
            return true;
        }
        return this.checkWritableDefault(new IlvGraphic[]{reconnectLinkContext.getLink(), reconnectLinkContext.getOldTarget(), reconnectLinkContext.getNewTarget()});
    }

    protected boolean checkWritableDelete(ModificationContext.DeleteContext deleteContext) {
        return this.checkWritableDiagram();
    }

    protected boolean checkWritableEditorOnly() {
        return this.checkWritableDiagram();
    }

    protected boolean checkWritableCut(ModificationContext.CutContext cutContext) {
        return this.checkWritableDiagram();
    }

    protected boolean checkWritablePaste(ModificationContext.PasteContext pasteContext) {
        return this.checkWritableDiagram();
    }

    protected boolean checkWritableDrop(ModificationContext.DropContext dropContext) {
        return this.checkWritableDefault(dropContext.getTargetGraphic());
    }

    protected boolean checkWritableDiagram() {
        URL url = this.getDiagramContext().getPlugin(IdeContextPlugin.class).getContext().getNode().getURL();
        if (URLFileSystem.isReadOnly((URL)url)) {
            return URLFileSystem.setReadOnly((URL)url, (boolean)false);
        }
        return true;
    }

    protected boolean checkWritableGraphic(IlvGraphic g) {
        ReadOnlyPlugin p = PluginUtil.getPlugin(this.getDiagramContext(), g, ReadOnlyPlugin.class);
        if (p != null && !p.isWritable(this.getDiagramContext(), g)) {
            return p.setWritable(this.getDiagramContext(), g);
        }
        return true;
    }
}

