/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.preference.propertyeditor;

import java.util.ResourceBundle;
import oracle.diagram.framework.preference.propertyeditor.EnumPropertyTagFilter;
import oracle.diagram.framework.preference.propertyeditor.ListPropertyEditorImpl;

class EnumPropertyEditorImpl
extends ListPropertyEditorImpl {
    private final Class<? extends Enum> _enumClazz;
    private volatile EnumPropertyTagFilter _tagFilter;

    public EnumPropertyEditorImpl(Class<? extends Enum> enumClazz, ResourceBundle rb, String baseKey) {
        super(rb, baseKey, true);
        if (enumClazz == null) {
            throw new IllegalArgumentException("Argument enumClazz must not be null");
        }
        this._enumClazz = enumClazz;
    }

    String getTagValue(Enum value) {
        String[] content = this.getContent();
        int index = value.ordinal();
        return content[index];
    }

    @Override
    public String getAsText() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        return this.getTagValue((Enum)value);
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null) {
            this.setValue(null);
            return;
        }
        String[] tags = super.getTags();
        for (int i = 0; i < tags.length; ++i) {
            if (!tags[i].equals(text)) continue;
            this.setValue(this._enumClazz.getEnumConstants()[i]);
            return;
        }
        throw new IllegalArgumentException("Input text does not contain a valid value: " + text);
    }

    @Override
    public String[] getTags() {
        String[] tags = super.getTags();
        if (this._tagFilter != null) {
            tags = this._tagFilter.filterTags(tags);
            assert (tags != null);
        }
        return tags;
    }

    public final void setEnumPropertyTagFilter(EnumPropertyTagFilter filter) {
        this._tagFilter = filter;
    }

    public final EnumPropertyTagFilter getEnumPropertyTagFilter() {
        return this._tagFilter;
    }
}

