/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.preference.propertyeditor;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.ResourceBundle;
import oracle.diagram.framework.preference.propertyeditor.PropertyEditorFactoryDelegate;
import oracle.diagram.res.PreferenceResource;

public class BooleanPropertyEditor
extends PropertyEditorFactoryDelegate {
    private static String TRUE;
    private static String FALSE;
    private static String NULL_VALUE;

    public BooleanPropertyEditor() {
        this(false);
    }

    protected BooleanPropertyEditor(boolean paintable) {
        super(new Z_Editor(paintable), Boolean.class);
        ResourceBundle rb = PreferenceResource.getBundle();
        TRUE = rb.getString("booleanEditor.true.text");
        FALSE = rb.getString("booleanEditor.false.text");
        NULL_VALUE = rb.getString("booleanEditor.nullValue.text");
    }

    private static class Z_Editor
    implements PropertyEditor {
        private PropertyChangeListener _listener;
        private Boolean _value = Boolean.FALSE;
        private final boolean _paintable;

        public Z_Editor(boolean paintable) {
            this._paintable = paintable;
        }

        @Override
        public final void setValue(Object o) {
            this._value = (Boolean)o;
            this.firePropertyChange();
        }

        @Override
        public final Object getValue() {
            return this._value;
        }

        @Override
        public final boolean isPaintable() {
            return this._paintable;
        }

        @Override
        public final void paintValue(Graphics gfx, Rectangle box) {
            String value = this.getAsText();
            FontMetrics fm = gfx.getFontMetrics();
            int ascent = fm.getAscent();
            int fontHeight = ascent + fm.getDescent();
            gfx.drawString(value, box.x + 1, box.y + (box.height - fontHeight) / 2 + ascent);
        }

        @Override
        public final String getAsText() {
            return this._value != null && this._value != false ? TRUE : FALSE;
        }

        @Override
        public String getJavaInitializationString() {
            return this._value != null && this._value != false ? "true" : "false";
        }

        @Override
        public final void setAsText(String text) throws IllegalArgumentException {
            String trimmed;
            String string = trimmed = text != null ? text.trim() : null;
            if (trimmed == null || trimmed.length() == 0) {
                throw new IllegalArgumentException(NULL_VALUE);
            }
            if (trimmed.equalsIgnoreCase(TRUE)) {
                this.setValue(Boolean.TRUE);
            } else if (trimmed.equalsIgnoreCase(FALSE)) {
                this.setValue(Boolean.FALSE);
            } else if (trimmed.equalsIgnoreCase("true")) {
                this.setValue(Boolean.TRUE);
            } else if (trimmed.equalsIgnoreCase("false")) {
                this.setValue(Boolean.FALSE);
            } else {
                throw new IllegalArgumentException(trimmed);
            }
        }

        @Override
        public final String[] getTags() {
            return new String[]{TRUE, FALSE};
        }

        @Override
        public final Component getCustomEditor() {
            return null;
        }

        @Override
        public final boolean supportsCustomEditor() {
            return false;
        }

        private void firePropertyChange() {
            if (this._listener != null) {
                this._listener.propertyChange(new PropertyChangeEvent(this, "BooleanPropertyEditor.Z_Editor???", null, this._value));
            }
        }

        @Override
        public final void addPropertyChangeListener(PropertyChangeListener l) {
            this._listener = l;
        }

        @Override
        public final void removePropertyChangeListener(PropertyChangeListener l) {
            this._listener = null;
        }
    }
}

