/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.preference;

import oracle.diagram.framework.preference.AbstractPreferenceStore;
import oracle.diagram.framework.preference.PreferenceDefinition;

public final class FactoryDefaultsPreferenceStore
extends AbstractPreferenceStore {
    private final PreferenceDefinition[] _defs;

    public FactoryDefaultsPreferenceStore(PreferenceDefinition[] definitions) {
        this._defs = new PreferenceDefinition[definitions.length];
        System.arraycopy(definitions, 0, this._defs, 0, definitions.length);
    }

    @Override
    public boolean hasPreferenceValue(PreferenceDefinition preference) {
        for (PreferenceDefinition pd : this._defs) {
            if (pd != preference) continue;
            return true;
        }
        return false;
    }

    @Override
    protected final Object getPreferenceValueImpl(PreferenceDefinition preference) {
        for (PreferenceDefinition pd : this._defs) {
            if (pd.getId() != preference.getId()) continue;
            return pd.getFactoryDefaultValue();
        }
        return null;
    }

    @Override
    protected final Object setPreferenceValueImpl(PreferenceDefinition preference, Object value) {
        throw new IllegalStateException("Cannot set the preference values on a FactoryDefaultsPreferenceStore");
    }
}

