/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.preference;

import java.util.ArrayList;
import java.util.List;
import oracle.bm.util.DebugUtils;
import oracle.diagram.framework.preference.PreferenceDefinition;
import oracle.diagram.framework.preference.PreferenceStore;
import oracle.diagram.framework.preference.PreferenceStoreListener;
import oracle.diagram.framework.preference.event.PreferenceStoreEvent;

public abstract class AbstractPreferenceStore
implements PreferenceStore {
    private final List<PreferenceStoreListener> _listeners = new ArrayList<PreferenceStoreListener>();

    protected AbstractPreferenceStore() {
    }

    @Override
    public void addPreferenceStoreListener(PreferenceStoreListener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    @Override
    public void removePreferenceStoreListener(PreferenceStoreListener listener) {
        this._listeners.remove(listener);
    }

    @Override
    public final Object getPreferenceValue(PreferenceDefinition preference) {
        return this.getPreferenceValueImpl(preference);
    }

    @Override
    public final Object setPreferenceValue(PreferenceDefinition preference, Object value) {
        return this.setPreferenceValuesImpl(new PreferenceDefinition[]{preference}, new Object[]{value})[0];
    }

    @Override
    public final void setPreferenceValues(PreferenceDefinition[] preferences, Object[] values) {
        this.setPreferenceValuesImpl(preferences, values);
    }

    private Object[] setPreferenceValuesImpl(PreferenceDefinition[] preferences, Object[] values) {
        Object[] oldValues = new Object[values.length];
        for (int i = 0; i < preferences.length; ++i) {
            if (this.isValid(preferences[i], values[i])) {
                oldValues[i] = this.setPreferenceValueImpl(preferences[i], values[i]);
                continue;
            }
            assert (DebugUtils.warning((String)("Value for preference " + preferences[i].getNLSName() + " is not valid: " + values[i])));
            oldValues[i] = this.getPreferenceValueImpl(preferences[i]);
            values[i] = oldValues[i];
        }
        this.firePreferenceChange(preferences, oldValues, values);
        return oldValues;
    }

    protected boolean isValid(PreferenceDefinition preference, Object value) {
        return preference.getType().isInstance(value);
    }

    protected abstract Object setPreferenceValueImpl(PreferenceDefinition var1, Object var2);

    protected abstract Object getPreferenceValueImpl(PreferenceDefinition var1);

    protected final void firePreferenceChange(PreferenceDefinition[] prefs, Object[] oldValues, Object[] newValues) {
        PreferenceStoreEvent evt = new PreferenceStoreEvent(this, prefs, oldValues, newValues);
        this.beforeFirePreferenceChange(evt);
        this.firePreferenceChange(evt);
    }

    protected void beforeFirePreferenceChange(PreferenceStoreEvent evt) {
    }

    protected void firePreferenceChange(PreferenceStoreEvent event) {
        int size = this._listeners.size();
        if (size > 0) {
            PreferenceStoreListener[] copy;
            for (PreferenceStoreListener l : copy = this._listeners.toArray(new PreferenceStoreListener[this._listeners.size()])) {
                try {
                    l.preferenceStoreChanged(event);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

