/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.link.glyph;

import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import oracle.diagram.framework.link.RenderedGlyph;

public class DiamondGlyph
extends RenderedGlyph {
    private Shape _shape;
    private float _height = 10.0f;
    private float _width = 10.0f;
    private boolean _filled = true;

    public DiamondGlyph() {
        this.initShape();
    }

    public DiamondGlyph(boolean filled) {
        this.initShape();
        this._filled = filled;
    }

    @Override
    protected Shape getShape() {
        return this._shape;
    }

    @Override
    protected RenderedGlyph.FillColor getFillColor() {
        return this._filled ? RenderedGlyph.FillColor.EDGE_COLOR : RenderedGlyph.FillColor.BACK_COLOR;
    }

    public void setFilled(boolean filled) {
        this._filled = filled;
    }

    protected void initShape() {
        GeneralPath shape = new GeneralPath();
        shape.moveTo(0.0f, 0.0f);
        shape.lineTo(-this._width / 2.0f, this._height / 2.0f);
        shape.lineTo(-this._width, 0.0f);
        shape.lineTo(-this._width / 2.0f, -this._height / 2.0f);
        shape.closePath();
        this._shape = shape;
        RenderingHints rHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        rHints.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE));
        rHints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        this.setRenderingHints(rHints);
    }
}

