/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.link.glyph;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.linkconnector.IlvShapePath;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import oracle.diagram.framework.link.LinkUtil;
import oracle.diagram.framework.link.RenderedGlyph;

public class CrowsFootGlyph
extends RenderedGlyph {
    private Point2D[] _topLine;
    private Point2D[] _bottomLine;
    protected static final float HEIGHT = 8.0f;
    protected static final float WIDTH = 12.0f;

    public CrowsFootGlyph() {
        this.initShape();
    }

    @Override
    protected Shape getShape() {
        return null;
    }

    @Override
    protected RenderedGlyph.FillColor getFillColor() {
        return RenderedGlyph.FillColor.EDGE_COLOR;
    }

    protected void initShape() {
        this._bottomLine = new Point2D[2];
        this._bottomLine[1] = new Point2D.Float(12.0f, 8.0f);
        this._bottomLine[0] = new Point2D.Float(-12.0f, 0.0f);
        this._topLine = new Point2D[2];
        this._topLine[1] = new Point2D.Float(12.0f, -8.0f);
        this._topLine[0] = new Point2D.Float(-12.0f, 0.0f);
        RenderingHints rHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.setRenderingHints(rHints);
    }

    @Override
    public Shape getTransformedShape(IlvGraphic node, IlvPoint from, IlvPoint to, IlvTransformer transformer, float dx) {
        AffineTransform t = this.calcAffineTransform(from, to, transformer, dx);
        if (t != null) {
            return t.createTransformedShape(this.getBoundShape(node, transformer, t));
        }
        return null;
    }

    protected Shape getBoundShape(IlvGraphic node, IlvTransformer nTrans, AffineTransform glyphTrans) {
        IlvRect nodeBox = node.boundingBox(nTrans);
        PathIterator nodePathIte = node instanceof IlvShapePath ? ((IlvShapePath)node).getShapePath(nTrans) : nodeBox.getPathIterator(new AffineTransform());
        Point2D[] tBottomLine = new Point2D[2];
        glyphTrans.transform(this._bottomLine, 0, tBottomLine, 0, 2);
        IlvPoint bottomInters = LinkUtil.getClosestIntersectionPoint(tBottomLine[0], tBottomLine[1], nodePathIte);
        PathIterator nodePathIte2 = node instanceof IlvShapePath ? ((IlvShapePath)node).getShapePath(nTrans) : nodeBox.getPathIterator(new AffineTransform());
        Point2D[] tTopLine = new Point2D[2];
        glyphTrans.transform(this._topLine, 0, tTopLine, 0, 2);
        IlvPoint topInters = LinkUtil.getClosestIntersectionPoint(tTopLine[0], tTopLine[1], nodePathIte2);
        return this.getDynamicShape(bottomInters, topInters, glyphTrans);
    }

    protected Shape getDynamicShape(IlvPoint bInter, IlvPoint tInter, AffineTransform glyphTrans) {
        GeneralPath dynShape = new GeneralPath();
        dynShape.moveTo(-12.0f, 0.0f);
        dynShape.lineTo(0.0f, 0.0f);
        dynShape.lineTo(-12.0f, 0.0f);
        AffineTransform invGTrans = null;
        try {
            invGTrans = glyphTrans.createInverse();
        }
        catch (NoninvertibleTransformException nex) {
            invGTrans = new AffineTransform();
        }
        if (bInter != null) {
            Point2D.Float revBInter = new Point2D.Float();
            invGTrans.transform((Point2D)bInter, revBInter);
            if (((Point2D)revBInter).getY() >= 0.0) {
                dynShape.lineTo((float)((Point2D)revBInter).getX(), (float)((Point2D)revBInter).getY());
                dynShape.lineTo(-10.5f, 0.0f);
            }
        }
        if (tInter != null) {
            if (bInter != null) {
                dynShape.moveTo(-12.0f, 0.0f);
            }
            Point2D.Float revTInter = new Point2D.Float();
            invGTrans.transform((Point2D)tInter, revTInter);
            if (((Point2D)revTInter).getY() <= 0.0) {
                dynShape.lineTo((float)((Point2D)revTInter).getX(), (float)((Point2D)revTInter).getY());
                dynShape.lineTo(-10.5f, 0.0f);
            }
        }
        return dynShape;
    }
}

