/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.link;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import oracle.diagram.framework.link.Glyph;
import oracle.diagram.framework.transformer.TransformerUtil;

public class GraphicGlyph
implements Glyph {
    private IlvGraphic _graphic;
    private IlvRect _boundingBox = new IlvRect();

    public GraphicGlyph(IlvGraphic ilvgraphic) {
        this._graphic = ilvgraphic;
        this._graphic.move(-this.getWidth(), -this.getHeight() / 2.0f);
    }

    @Override
    public void draw(Graphics g, IlvGraphic node, IlvPoint from, IlvPoint to, IlvTransformer transformer, float dx) {
        AffineTransform t = new AffineTransform();
        t.translate(to.x, to.y);
        float a = to.x - from.x;
        float b = to.y - from.y;
        double angle = 1.5707963267948966 - Math.atan(a / b);
        if (b < 0.0f) {
            angle += Math.PI;
        }
        t.rotate(angle);
        if (a < 0.0f) {
            t.rotate(Math.PI);
            t.translate(this.getWidth(), 0.0);
        }
        if (dx != 0.0f) {
            t.translate(dx, 0.0);
        }
        t.scale(transformer.getx11(), transformer.getx22());
        IlvTransformer trans = TransformerUtil.getTransformer(t);
        this._graphic.draw(g, trans);
        this._boundingBox.reshape(0.0f, 0.0f, this.getWidth(), this.getHeight());
        trans.apply(this._boundingBox);
    }

    @Override
    public float getWidth() {
        return (float)this._graphic.boundingBox().getWidth();
    }

    @Override
    public float getHeight() {
        return (float)this._graphic.boundingBox().getHeight();
    }

    @Override
    public IlvRect boundingBox() {
        return this._boundingBox;
    }
}

