/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.interaction;

import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.event.InteractorChangedEvent;
import ilog.views.event.InteractorListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public abstract class InteractorEventHook {
    private IlvManagerView _view;
    private final InteractorListener _listener = new InteractorChangeListener();

    public InteractorEventHook(IlvManagerView view) {
        this._view = view;
        IlvManagerViewInteractor i = this._view.getInteractor();
        if (i != null) {
            this._listener.interactorChanged(new InteractorChangedEvent(this._view, null, i));
        }
        this._view.addInteractorListener(this._listener);
    }

    public synchronized void dispose() {
        if (this._view != null) {
            this._view.removeInteractorListener(this._listener);
            this._listener.interactorChanged(new InteractorChangedEvent(this._view, this._view.getInteractor(), null));
            this._view = null;
        }
    }

    protected final IlvManagerView getManagerView() {
        return this._view;
    }

    protected boolean isHookableInteractor(IlvManagerViewInteractor interactor) {
        return true;
    }

    protected MouseListener getMouseListener() {
        return null;
    }

    protected MouseMotionListener getMouseMotionListener() {
        return null;
    }

    protected KeyListener getKeyListener() {
        return null;
    }

    protected FocusListener getFocusListener() {
        return null;
    }

    private final class InteractorChangeListener
    implements InteractorListener {
        private InteractorChangeListener() {
        }

        public void interactorChanged(InteractorChangedEvent event) {
            IlvManagerViewInteractor oldInteractor = event.getOldValue();
            IlvManagerViewInteractor newInteractor = event.getNewValue();
            MouseListener ml = InteractorEventHook.this.getMouseListener();
            MouseMotionListener mml = InteractorEventHook.this.getMouseMotionListener();
            KeyListener kl = InteractorEventHook.this.getKeyListener();
            FocusListener fl = InteractorEventHook.this.getFocusListener();
            if (oldInteractor != null && InteractorEventHook.this.isHookableInteractor(oldInteractor)) {
                if (ml != null) {
                    oldInteractor.removeMouseListener(ml);
                }
                if (mml != null) {
                    oldInteractor.removeMouseMotionListener(mml);
                }
                if (kl != null) {
                    oldInteractor.removeKeyListener(kl);
                }
                if (fl != null) {
                    oldInteractor.removeFocusListener(fl);
                }
            }
            if (newInteractor != null && InteractorEventHook.this.isHookableInteractor(newInteractor)) {
                if (ml != null) {
                    newInteractor.removeMouseListener(ml);
                    newInteractor.addMouseListener(ml);
                }
                if (mml != null) {
                    newInteractor.removeMouseMotionListener(mml);
                    newInteractor.addMouseMotionListener(mml);
                }
                if (kl != null) {
                    newInteractor.removeKeyListener(kl);
                    newInteractor.addKeyListener(kl);
                }
                if (fl != null) {
                    newInteractor.removeFocusListener(fl);
                    newInteractor.addFocusListener(fl);
                }
            }
        }
    }
}

