/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.interaction;

import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvRect;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import java.awt.Rectangle;
import oracle.diagram.core.interaction.InteractorEventAware;
import oracle.diagram.core.interaction.event.DiagramPendingActionEvent;
import oracle.diagram.core.interaction.event.InteractorEvent;
import oracle.diagram.framework.interaction.EditInteractor;
import oracle.diagram.framework.interaction.InPlaceEditContext;

public abstract class InPlaceEditor
extends IlvManagerViewInteractor
implements InteractorEventAware {
    protected static final String REINVOKED_PROPERTY = "oracle.diagram.reInvoked";
    protected static final int COMMIT_TYPE_ONE_SHOT = 0;
    protected static final int COMMIT_TYPE_REINVOKE = 1;
    private final TransformerListener _transformerListener = new ViewTransformerListener();
    private final EditInteractor _editInteractor;
    private final InPlaceEditContext _context;
    private int _commitType = 0;

    protected InPlaceEditor(EditInteractor editInteractor, InPlaceEditContext context) {
        this._editInteractor = editInteractor;
        this._context = context;
    }

    protected final boolean isEditionAllowed() {
        return this.getEditInteractor().isEditionAllowed();
    }

    protected final boolean isCreationAllowed() {
        return this.getEditInteractor().isCreationAllowed();
    }

    protected final boolean isGrapherMode() {
        return this.getEditInteractor().isGrapherMode();
    }

    protected final int getCommitType() {
        return this._commitType;
    }

    protected void attach(IlvManagerView view) {
        super.attach(view);
        view.addTransformerListener(this._transformerListener);
    }

    protected void detach() {
        this.getManagerView().removeTransformerListener(this._transformerListener);
        this.cleanup();
        super.detach();
    }

    protected final EditInteractor getEditInteractor() {
        return this._editInteractor;
    }

    protected final InPlaceEditContext getContext() {
        return this._context;
    }

    protected void cleanup() {
    }

    protected abstract Rectangle getEditComponentBounds();

    public abstract void edit();

    public void commit(int commitType) {
        this._commitType = commitType;
    }

    public abstract void abort();

    @Override
    public boolean processInteractorEvent(InteractorEvent event) {
        if (event instanceof DiagramPendingActionEvent) {
            DiagramPendingActionEvent epae = (DiagramPendingActionEvent)event;
            if (epae.getAction().getCommandId() == 5) {
                epae.consume();
                return true;
            }
            this.commit(0);
            return true;
        }
        return false;
    }

    protected InPlaceEditContext reinvoke() {
        InPlaceEditContext reinvokeContext = new InPlaceEditContext(this.getContext());
        reinvokeContext.setProperty(REINVOKED_PROPERTY, Boolean.TRUE);
        this.getEditInteractor().setReinvokeContext(reinvokeContext);
        return reinvokeContext;
    }

    private final class ViewTransformerListener
    implements TransformerListener {
        private ViewTransformerListener() {
        }

        public void transformerChanged(TransformerChangedEvent event) {
            Rectangle b = InPlaceEditor.this.getEditComponentBounds();
            if (b != null) {
                IlvRect rOld = new IlvRect((float)b.x, (float)b.y, (float)b.width, (float)b.height);
                if (event.getOldValue() != null) {
                    event.getOldValue().inverse(rOld);
                }
                IlvRect rNew = new IlvRect((float)b.x, (float)b.y, (float)b.width, (float)b.height);
                if (event.getNewValue() != null) {
                    event.getNewValue().inverse(rNew);
                }
                rNew.add(rOld);
                event.getNewValue().apply(rNew);
                InPlaceEditor.this.getManagerView().invalidateRect(rNew);
                InPlaceEditor.this.getManagerView().reDrawViews();
                InPlaceEditor.this.commit(0);
            } else if (InPlaceEditor.this.getManagerView() != null && InPlaceEditor.this.getManagerView().getInteractor() == InPlaceEditor.this) {
                InPlaceEditor.this.getManagerView().popInteractor();
            }
        }
    }
}

