/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.interaction;

import ilog.views.IlvApplyObject;
import ilog.views.IlvFontInterface;
import ilog.views.IlvGraphic;
import ilog.views.IlvLabelInterface;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvRect;
import ilog.views.IlvToolkit;
import ilog.views.IlvTransformer;
import ilog.views.event.InteractorChangedEvent;
import ilog.views.event.InteractorListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.AffineTransform;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.diagram.framework.interaction.EditInteractor;
import oracle.diagram.framework.interaction.InPlaceEditContext;
import oracle.diagram.framework.interaction.InPlaceEditor;
import oracle.diagram.framework.manager.ManagerUtil;

public abstract class ComponentInPlaceEditor
extends InPlaceEditor {
    protected boolean _editing = false;
    protected IlvGraphic _editedObject;
    protected IlvManager _editedManager;
    private JComponent _component;
    private boolean _isDetached = false;
    public static final Font DEFAULT_FONT = IlvToolkit.defaultFont;

    protected ComponentInPlaceEditor(EditInteractor editInteractor, InPlaceEditContext context) {
        super(editInteractor, context);
    }

    protected abstract boolean setObjectLabel(IlvGraphic var1, String var2);

    protected abstract void setObjectLabelWithUndo(IlvGraphic var1, String var2);

    protected abstract void revertImpl();

    protected abstract void editImpl(Font var1);

    protected abstract Object getComponentValue();

    protected abstract void cleanUpComponent();

    protected Font getFont(IlvGraphic obj) {
        Font font = null;
        if (obj instanceof IlvFontInterface) {
            font = ((IlvFontInterface)obj).getFont();
        }
        if (font == null) {
            font = DEFAULT_FONT;
        }
        return font;
    }

    protected IlvTransformer getDrawingTransformer() {
        IlvManager transformingManager;
        IlvTransformer transformer = this.getTransformer();
        if (this._editedManager != null && this._editedObject != null && this._editedManager != this.getManager() && (transformingManager = ManagerUtil.getTransformingManager(this._editedObject)) != null) {
            transformer = transformingManager.getDrawingTransformer(this.getManagerView());
        }
        return transformer;
    }

    protected final Rectangle getComponentBounds() {
        return this.getComponent().getBounds();
    }

    protected void setComponentBounds(int x, int y, int w, int h) {
        Container parent = this._component.getParent();
        Rectangle rr = parent.getBounds();
        if (w > rr.width) {
            w = rr.width;
        }
        if (h > rr.height) {
            h = rr.height;
        }
        if (x + w > rr.width) {
            x = rr.width - w;
        }
        if (y + h > rr.height) {
            y = rr.height - h;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        this._component.setBounds(x, y, w, h);
    }

    protected IlvRect getLabelBBox(IlvGraphic obj, IlvTransformer t) {
        if (obj instanceof IlvLabelInterface) {
            IlvRect r = ((IlvLabelInterface)obj).getLabelBBox(t);
            if (r == null) {
                r = obj.boundingBox(t);
            } else {
                r.intersection(obj.boundingBox(t));
            }
            return r;
        }
        return obj.boundingBox(t);
    }

    @Override
    protected void attach(IlvManagerView view) {
        super.attach(view);
        if (this._isDetached) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ComponentInPlaceEditor.this.abort();
                }
            });
        }
    }

    @Override
    protected void detach() {
        super.detach();
        this._isDetached = true;
    }

    @Override
    public void edit() {
        InPlaceEditContext context = this.getContext();
        IlvGraphic editedObject = context.getSubObject() != null ? context.getSubObject() : context.getMainObject();
        this.setEditedObject(editedObject);
        this.setEditedManager(context.getManager() != null ? context.getManager() : ManagerUtil.getManager(editedObject));
        this.setEditing(true);
        Font font = this.getFont(editedObject);
        if (font == null) {
            font = DEFAULT_FONT;
        }
        IlvTransformer transformer = this.getDrawingTransformer();
        font = font.deriveFont(new AffineTransform(transformer.zoomXFactor(), 0.0, 0.0, transformer.zoomYFactor(), 0.0, 0.0));
        this.editImpl(font);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void commit(int commitType) {
        super.commit(commitType);
        if (this._editing) {
            this.getEditInteractor().setExitStatus(EditInteractor.Status.COMMIT);
            try {
                IlvManager manager = this.getEditedManager();
                IlvGraphic object = this.getEditedObject();
                if ((manager == null || !manager.isManaged(object)) && object.getGraphicBag() == null || !this.isEditing()) return;
                this.setEditing(false);
                Object value = this.getComponentValue();
                if (manager.isManaged(object)) {
                    manager.applyToObject(object, (IlvApplyObject)new ApplyChange(), value, true);
                    return;
                }
                if (object.getGraphicBag() instanceof IlvGraphic && manager.isManaged((IlvGraphic)object.getGraphicBag())) {
                    manager.applyToObject((IlvGraphic)object.getGraphicBag(), (IlvApplyObject)new ApplyChange(), value, true);
                    return;
                }
                this.setObjectLabelWithUndo(object, value.toString());
                return;
            }
            finally {
                if (!this.isDetached()) {
                    new DetachInteractorListener().run();
                }
            }
        } else {
            if (this._isDetached) return;
            new DetachInteractorListener().run();
        }
    }

    @Override
    public void abort() {
        this.getEditInteractor().setExitStatus(EditInteractor.Status.ABORT);
        this.revertImpl();
        IlvManagerView view = this.getManagerView();
        this.setEditing(false);
        if (view != null && view.getInteractor() == this) {
            view.popInteractor();
        } else if (!this._isDetached) {
            new DetachInteractorListener().run();
        } else {
            this.cleanup();
        }
    }

    @Override
    protected void cleanup() {
        if (this._component != null && this.getManagerView() != null) {
            Rectangle bounds = this._component.getBounds();
            this.cleanUpComponent();
            JComponent toberemoved = this._component;
            this._component = null;
            this.getManagerView().remove((Component)toberemoved);
            if (bounds != null) {
                this.getManagerView().invalidateRect(new IlvRect((float)bounds.x, (float)bounds.y, (float)bounds.width, (float)bounds.height));
                this.getManagerView().reDrawViews();
            }
        }
        this.setEditedObject(null);
        this.setEditedManager(null);
        this.setEditing(false);
    }

    protected final void setEditing(boolean editing) {
        this._editing = editing;
    }

    protected final boolean isEditing() {
        return this._editing;
    }

    protected final void setEditedObject(IlvGraphic editedObject) {
        this._editedObject = editedObject;
    }

    protected final IlvGraphic getEditedObject() {
        return this._editedObject;
    }

    protected final void setEditedManager(IlvManager editedManager) {
        this._editedManager = editedManager;
    }

    protected final IlvManager getEditedManager() {
        return this._editedManager;
    }

    protected final boolean isDetached() {
        return this._isDetached;
    }

    protected final void setComponent(JComponent component) {
        this._component = component;
    }

    protected final JComponent getComponent() {
        return this._component;
    }

    public final class MyKeyListener
    implements KeyListener {
        @Override
        public void keyTyped(KeyEvent e) {
            ComponentInPlaceEditor.this.processKeyEvent(e);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            ComponentInPlaceEditor.this.processKeyEvent(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            ComponentInPlaceEditor.this.processKeyEvent(e);
        }
    }

    protected final class DetachInteractorListener
    implements InteractorListener,
    Runnable {
        protected DetachInteractorListener() {
        }

        public void interactorChanged(InteractorChangedEvent interactorChangedEvent) {
            IlvManagerView view = interactorChangedEvent.getManagerView();
            if (view.getInteractor() == ComponentInPlaceEditor.this) {
                view.popInteractor();
                view.removeInteractorListener((InteractorListener)this);
            }
        }

        @Override
        public void run() {
            IlvManagerView view = ComponentInPlaceEditor.this.getManagerView();
            if (view != null) {
                if (view.getInteractor() == ComponentInPlaceEditor.this) {
                    view.popInteractor();
                } else {
                    view.addInteractorListener((InteractorListener)this);
                    ComponentInPlaceEditor.this.cleanup();
                }
            }
        }
    }

    protected final class EditingInputVerifier
    extends InputVerifier {
        private boolean _isEnabled = true;

        public void setEnabled(boolean isEnabled) {
            this._isEnabled = isEnabled;
        }

        @Override
        public boolean shouldYieldFocus(JComponent input) {
            if (ComponentInPlaceEditor.this._editing && this._isEnabled) {
                ComponentInPlaceEditor.this.commit(0);
            }
            return true;
        }

        @Override
        public boolean verify(JComponent input) {
            return true;
        }
    }

    protected final class ApplyChange
    implements IlvApplyObject {
        protected ApplyChange() {
        }

        public void apply(IlvGraphic obj, Object param) {
            String text = (String)param;
            ComponentInPlaceEditor.this.setObjectLabelWithUndo(obj, text);
        }
    }
}

