/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.highlight;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.framework.graphic.IMultipresentationView;
import oracle.diagram.framework.highlight.ShapeHighlighter;
import oracle.diagram.framework.highlight.ShapeHighlighterDecorator;
import oracle.diagram.framework.manager.ManagerUtil;

public class SelectorHighlighter
implements MouseMotionListener {
    private IlvGraphic m_currentGraphic;
    private IlvPoint m_tempPoint;
    private ShapeHighlighterDecorator m_highlighter;
    private MouseEvent m_lastEvent;
    private boolean m_enabled;
    private DiagramContext m_context;

    public SelectorHighlighter(DiagramContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Diagram Context is null");
        }
        this.m_tempPoint = new IlvPoint(0.0f, 0.0f);
        this.m_enabled = true;
        this.m_context = context;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.m_lastEvent = e;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        IlvGraphic newGraphic;
        this.m_lastEvent = e;
        if (!this.m_enabled) {
            return;
        }
        IlvManagerView mgrView = this.m_context.getManagerView();
        ShapeHighlighterDecorator highlighter = this.fetchHighlighter();
        if (highlighter == null) {
            return;
        }
        if (this.m_currentGraphic != null && ManagerUtil.getManager(this.m_currentGraphic) == null) {
            this.m_currentGraphic = null;
        }
        if ((newGraphic = this.findGraphic(e, mgrView)) != this.m_currentGraphic) {
            if (this.m_currentGraphic != null) {
                this.graphicExited(this.m_currentGraphic);
                this.m_currentGraphic = null;
            }
            if (newGraphic != null) {
                this.graphicEntered(newGraphic);
                this.m_currentGraphic = newGraphic;
            }
        }
    }

    public void reset() {
        if (this.m_highlighter != null) {
            this.m_highlighter.reset();
        }
    }

    protected boolean isNode(IlvGraphic ilvgraphic) {
        if (ilvgraphic == null) {
            return false;
        }
        IlvGraphicBag ilvgraphicbag = ilvgraphic.getGraphicBag();
        if (!(ilvgraphicbag instanceof IlvGrapher)) {
            return false;
        }
        boolean isNode = ((IlvGrapher)ilvgraphicbag).isNode(ilvgraphic);
        return isNode && ((IlvGrapher)ilvgraphicbag).isVisible(ilvgraphic);
    }

    protected IlvGraphic findGraphic(MouseEvent e, IlvManagerView mgrView) {
        IlvManager manager = mgrView.getManager();
        this.m_tempPoint.setLocation((Point2D)e.getPoint());
        IlvGraphic g = manager.getObject(this.m_tempPoint, mgrView, true);
        if (g instanceof IMultipresentationView) {
            g = ((IMultipresentationView)g).getNearestHighlightableObject();
        }
        if (!(g == null || this.m_currentGraphic == null || this.m_currentGraphic instanceof IlvManager && ManagerUtil.isAncestor((IlvManager)this.m_currentGraphic, g) || ManagerUtil.getManager(g).getLayer(g) <= ManagerUtil.getManager(this.m_currentGraphic).getLayer(this.m_currentGraphic))) {
            IlvTransformer t1 = ManagerUtil.getConversionTransformer(ManagerUtil.getTopManager(this.m_currentGraphic), ManagerUtil.getTransformingManager(this.m_currentGraphic));
            IlvRect bbox1 = this.m_currentGraphic.boundingBox();
            t1.apply(bbox1);
            IlvTransformer t2 = ManagerUtil.getConversionTransformer(ManagerUtil.getTopManager(g), ManagerUtil.getTransformingManager(g));
            IlvRect bbox2 = g.boundingBox();
            t2.apply(bbox2);
            if (bbox1.contains(bbox2)) {
                return this.m_currentGraphic;
            }
        }
        if (!this.isNode(g)) {
            return null;
        }
        return g;
    }

    protected void graphicEntered(IlvGraphic graphic) {
        ShapeHighlighterDecorator highlighter = this.fetchHighlighter();
        if (highlighter != null) {
            highlighter.highlightGraphic(graphic, true);
        }
    }

    protected void graphicExited(IlvGraphic graphic) {
        ShapeHighlighterDecorator highlighter = this.fetchHighlighter();
        if (highlighter != null) {
            highlighter.unhighlightGraphic(graphic, true);
        }
    }

    private ShapeHighlighterDecorator fetchHighlighter() {
        ShapeHighlighter highlighter;
        if (this.m_highlighter == null && (highlighter = this.m_context.getPlugin(ShapeHighlighter.class)) != null) {
            this.m_highlighter = new ShapeHighlighterDecorator(highlighter);
        }
        return this.m_highlighter;
    }

    public void forceMouseMotionEvent() {
        if (this.m_lastEvent != null) {
            this.m_currentGraphic = null;
            this.mouseMoved(this.m_lastEvent);
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.m_enabled) {
            this.m_enabled = enabled;
            if (!enabled && this.m_highlighter != null) {
                this.m_highlighter.reset();
            }
        }
    }
}

