/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic.port;

import ilog.views.IlvGraphic;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvRectangle;
import ilog.views.graphic.composite.layout.IlvAttachmentConstraint;
import ilog.views.graphic.composite.layout.IlvAttachmentLayout;
import ilog.views.graphic.composite.layout.IlvAttachmentLocation;
import ilog.views.graphic.composite.layout.IlvLayoutManager;
import ilog.views.linkconnector.IlvShapePath;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.graphic.ContainerGraphic;
import oracle.diagram.framework.graphic.RectangleOutline;
import oracle.diagram.framework.graphic.layout.GraphicBorderLayout;
import oracle.diagram.framework.graphic.port.HorizontalPinBar;
import oracle.diagram.framework.graphic.port.PinBar;
import oracle.diagram.framework.graphic.port.PinPosition;
import oracle.diagram.framework.graphic.port.ShapeWithPins;
import oracle.diagram.framework.graphic.port.VerticalPinBar;
import oracle.diagram.framework.preference.VisualProperty;
import oracle.diagram.framework.selection.SubSelectionManager;

public class ContainerWithPins
extends ContainerGraphic
implements ShapeWithPins,
VisualProperty {
    private RectangleOutline _outline;
    private BorderShape[] _pinBars = new BorderShape[4];
    private IlvGraphic _content;
    private Color m_fillColor = null;
    private Color m_lineColor = null;
    private Color m_fontColor = null;
    private Font m_font = null;
    private boolean _pinsSameVisualProperties = true;

    public ContainerWithPins(IlvRect rect) {
        super(new GraphicBorderLayout());
        this.init(rect);
        this.commitUI();
    }

    public ContainerWithPins(IlvRect rect, IlvGraphic content) {
        super(new GraphicBorderLayout());
        this.init(rect);
        this.addContent(content, "Center");
        this._content = content;
        this.commitUI();
    }

    public boolean getPinsSameVisualProperties() {
        return this._pinsSameVisualProperties;
    }

    public void setPinsSameVisualProperties(boolean sameVisualProperties) {
        this._pinsSameVisualProperties = sameVisualProperties;
    }

    public IlvGraphic getContentShape() {
        return this._content;
    }

    public void setContentShape(IlvGraphic g) {
        if (this._content != null) {
            int contentIndex = this.getChildIndex(g);
            this.removeChild(contentIndex);
        }
        this.addContent(g, "Center");
        this._content = g;
        this.commitUI();
    }

    @Override
    public IlvGraphic[] getPins(PinPosition pos) {
        BorderShape barShape = this._pinBars[pos.arrayPosition()];
        return barShape == null ? new IlvGraphic[]{} : barShape.getPinBar().getPins();
    }

    @Override
    public void setPins(IlvGraphic[] pins, PinPosition pos, float dividerSize) {
        PinBar pinBar;
        BorderShape borderShape = this._pinBars[pos.arrayPosition()];
        if (borderShape == null) {
            this._pinBars[pos.arrayPosition()] = borderShape = new BorderShape();
        }
        if ((pinBar = borderShape.getPinBar()) == null) {
            PinBar pinBar2 = pinBar = pos == PinPosition.EAST || pos == PinPosition.WEST ? new VerticalPinBar(dividerSize) : new HorizontalPinBar(dividerSize);
            if (this._pinsSameVisualProperties) {
                pinBar.setShapeFillColor(this.getShapeFillColor());
                pinBar.setShapeLineColor(this.getShapeLineColor());
            }
            pinBar.setName(pos.borderPosition());
            borderShape.setPinBar(pinBar);
        }
        pinBar.setPins(pins);
        if (pins.length == 0 && borderShape.getGraphicBag() == this && this.getChildIndex((IlvGraphic)borderShape) >= 0) {
            boolean[] displayed = new boolean[4];
            for (PinPosition pp : PinPosition.values()) {
                BorderShape bs = this._pinBars[pp.arrayPosition()];
                displayed[pp.arrayPosition()] = bs == null ? false : bs.getGraphicBag() == this && this.getChildIndex((IlvGraphic)bs) >= 0;
            }
            IlvGraphic outline = this.getChildren(0);
            this.setChildren(null);
            this.setLayout(new GraphicBorderLayout());
            this.addContent(outline);
            if (this.getContentShape() != null) {
                this.addContent(this.getContentShape(), "Center");
            }
            for (PinPosition pp : PinPosition.values()) {
                if (!displayed[pp.arrayPosition()]) continue;
                this.addContent(this._pinBars[pp.arrayPosition()], pp.borderPosition());
            }
        } else if (pins.length > 0 && borderShape.getGraphicBag() == null) {
            this.addContent(borderShape, pos.borderPosition());
        }
        this.invalidate(true);
        this.doLayout();
        this.reDraw();
    }

    @Override
    public PathIterator getShapePath(IlvTransformer t) {
        GeneralPath gp = new GeneralPath();
        gp.append(this._content instanceof IlvShapePath ? ((IlvShapePath)this._content).getShapePath(t) : this._content.boundingBox(t).getPathIterator(new AffineTransform()), true);
        for (BorderShape pShape : this._pinBars) {
            if (pShape == null) continue;
            gp.append(pShape.getPinBar().getShapePath(t), false);
        }
        return gp.getPathIterator(new AffineTransform());
    }

    @Override
    public DimensionFloat getMinimumSize(DimensionFloat minimum) {
        DimensionFloat d = super.getMinimumSize(minimum);
        for (PinPosition pp : PinPosition.values()) {
            boolean displayed;
            BorderShape bs = this._pinBars[pp.arrayPosition()];
            boolean bl = bs == null ? false : (displayed = bs.getGraphicBag() == this && this.getChildIndex((IlvGraphic)bs) >= 0);
            if (!displayed) continue;
            DimensionFloat pindim = bs.getPinBar().getMinimumSize(new DimensionFloat());
            if (pp == PinPosition.EAST || pp == PinPosition.WEST) {
                d.height = Math.max(d.height, pindim.height + this.getExtraMinHeight());
                continue;
            }
            d.width = Math.max(d.width, pindim.width + this.getExtraMinWidth());
        }
        return d;
    }

    protected float getExtraMinHeight() {
        return 0.0f;
    }

    protected float getExtraMinWidth() {
        return 0.0f;
    }

    protected void init(IlvRect rect) {
        this.setTopLevel(true);
        this._outline = new RectangleOutline(rect);
        this._outline.setVisible(false);
        this.addContent(this._outline);
        SubSelectionManager.setSelectable(this._outline, false);
        this.setProperty("NonEllipsisShape", Boolean.TRUE);
    }

    protected void commitUI() {
        this.invalidate(true);
        this.doLayout();
        this.reDraw();
    }

    @Override
    public Color getShapeFillColor() {
        return this.m_fillColor;
    }

    @Override
    public void setShapeFillColor(Color color) {
        this.m_fillColor = color;
        if (this._content != null && this._content instanceof VisualProperty) {
            ((VisualProperty)this._content).setShapeFillColor(color);
        }
        if (this._pinsSameVisualProperties) {
            for (BorderShape bar : this._pinBars) {
                if (bar == null || bar.getPinBar() == null) continue;
                bar.getPinBar().setShapeFillColor(color);
            }
        }
    }

    @Override
    public Font getShapeFont() {
        return this.m_font;
    }

    @Override
    public void setShapeFont(Font font) {
        this.m_font = font;
        if (this._content != null && this._content instanceof VisualProperty) {
            ((VisualProperty)this._content).setShapeFont(font);
        }
    }

    @Override
    public Color getShapeLineColor() {
        return this.m_lineColor;
    }

    @Override
    public void setShapeLineColor(Color color) {
        this.m_lineColor = color;
        if (this._content != null && this._content instanceof VisualProperty) {
            ((VisualProperty)this._content).setShapeLineColor(color);
        }
        if (this._pinsSameVisualProperties) {
            for (BorderShape bar : this._pinBars) {
                if (bar == null || bar.getPinBar() == null) continue;
                bar.getPinBar().setShapeLineColor(color);
            }
        }
    }

    @Override
    public Color getShapeFontColor() {
        return this.m_fontColor;
    }

    @Override
    public void setShapeFontColor(Color color) {
        this.m_fontColor = color;
        if (this._content != null && this._content instanceof VisualProperty) {
            ((VisualProperty)this._content).setShapeFontColor(color);
        }
    }

    private static class BorderShape
    extends ContainerGraphic {
        public BorderShape() {
            IlvRectangle r = new IlvRectangle();
            r.setVisible(false);
            this.setChildren(0, (IlvGraphic)r);
            SubSelectionManager.setSelectable((IlvGraphic)r, false);
            SubSelectionManager.setSelectable((IlvGraphic)this, false);
            this.setProperty("NonEllipsisShape", Boolean.TRUE);
            this.setTopLevel(true);
            this.setLayout((IlvLayoutManager)new IlvAttachmentLayout());
        }

        public PinBar getPinBar() {
            return (PinBar)this.getChildren(1);
        }

        public void setPinBar(PinBar pinBar) {
            this.setChildren(1, (IlvGraphic)pinBar);
            this.setConstraints(1, new IlvAttachmentConstraint(IlvAttachmentLocation.Center, IlvAttachmentLocation.Center));
        }

        @Override
        public DimensionFloat getMinimumSize(DimensionFloat minimum) {
            PinBar bar = this.getPinBar();
            DimensionFloat dim = bar.getMinimumSize(new DimensionFloat());
            minimum.width = bar.isVertical() ? dim.width : Float.MAX_VALUE;
            minimum.height = bar.isVertical() ? Float.MAX_VALUE : dim.height;
            return minimum;
        }

        @Override
        public DimensionFloat getPreferedSize(DimensionFloat preferedSize) {
            PinBar bar = this.getPinBar();
            DimensionFloat dim = bar.getMinimumSize(new DimensionFloat());
            preferedSize.width = bar.isVertical() ? dim.width : Float.MAX_VALUE;
            preferedSize.height = bar.isVertical() ? Float.MAX_VALUE : dim.height;
            return preferedSize;
        }
    }
}

