/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic.features;

import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.core.util.GraphicIterator;
import oracle.diagram.framework.action.Actions;
import oracle.diagram.framework.graphic.features.ZOrderPlugin;
import oracle.diagram.framework.manager.ManagerUtil;

public class DefaultZOrderPlugin
extends AbstractPlugin
implements ZOrderPlugin {
    private final DiagramContext _context;

    public DefaultZOrderPlugin(DiagramContext context) {
        this._context = context;
    }

    @Override
    public boolean canBringToFront() {
        return this.hasSelectedGraphics();
    }

    @Override
    public void bringToFront() {
        this.changeSelectedGraphicsZOrder(Actions.CMD_BRING_TO_FRONT);
    }

    @Override
    public boolean canSendToBack() {
        return this.hasSelectedGraphics();
    }

    @Override
    public void sendToBack() {
        this.changeSelectedGraphicsZOrder(Actions.CMD_SEND_TO_BACK);
    }

    protected final DiagramContext getDiagramContext() {
        return this._context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeSelectedGraphicsZOrder(int action) {
        IlvManager mgr = this.getManager();
        if (mgr != null) {
            GraphicIterator iterator = new GraphicIterator(mgr.getSelectedObjects(true));
            try {
                mgr.initReDraws();
                for (IlvGraphic graphic : iterator) {
                    if (action == Actions.CMD_SEND_TO_BACK) {
                        ManagerUtil.sendToBack(graphic);
                    } else if (action == Actions.CMD_BRING_TO_FRONT) {
                        ManagerUtil.bringToFront(graphic);
                    }
                    ManagerUtil.invalidateRegion(graphic);
                }
            }
            finally {
                mgr.reDrawViews();
            }
        }
    }

    protected boolean hasSelectedGraphics() {
        IlvManager mgr = this.getManager();
        if (mgr != null) {
            return mgr.getSelectedObjectsCount(true) > 0;
        }
        return false;
    }

    protected IlvManager getManager() {
        IlvManagerView view = this._context.getManagerView();
        if (view != null) {
            return view.getManager();
        }
        return null;
    }
}

