/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvLinkConnector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvPoint;
import ilog.views.IlvTransformer;
import ilog.views.linkconnector.IlvClippingLinkConnector;
import oracle.diagram.framework.graphic.FakeNode;
import oracle.diagram.framework.graphic.GraphicPin;

public class NodeGraphicPin
extends GraphicPin {
    @Override
    public void connect(IlvPoint p, IlvTransformer t) {
        if (this.isOrigin()) {
            this.getLink().setFrom(this.getGraphic());
        } else {
            this.getLink().setTo(this.getGraphic());
        }
        IlvLinkConnector connector = this.getLinkConnector(this.getLink(), this.isOrigin());
        IlvGraphic g = connector.getNode();
        if (g instanceof FakeNode && connector instanceof IlvClippingLinkConnector) {
            connector = new IlvClippingLinkConnector();
            connector.attach(this.getLink(), this.isOrigin(), false);
        }
        connector.connectLink(this.getLink(), p, this.isOrigin(), t);
    }

    @Override
    public IlvPoint getConnectionPoint() {
        return this.getLinkConnector(this.getLink(), this.isOrigin()).getConnectionPoint(this.getLink(), this.isOrigin(), null);
    }

    protected IlvLinkConnector getLinkConnector(IlvLinkImage link, boolean origin) {
        IlvLinkConnector lc = IlvLinkConnector.Get((IlvLinkImage)link, (boolean)origin);
        if (lc == null) {
            throw new IllegalStateException("Missing link connector");
        }
        return lc;
    }

    @Override
    protected void disconnectImpl() {
        this.getLinkConnector(this.getLink(), this.isOrigin()).disconnectLink(this.getLink(), this.isOrigin());
    }
}

