/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.filter.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvNamedProperty;
import oracle.diagram.framework.filter.Filter;

public interface GraphicFilter
extends Filter<IlvGraphic> {
    public static final GraphicFilter NODE = new GraphicFilter(){

        @Override
        public boolean accept(IlvGraphic graphic) {
            return !(graphic instanceof IlvLinkImage);
        }

        public String toString() {
            return "is node";
        }
    };
    public static final GraphicFilter LINK = new GraphicFilter(){

        @Override
        public boolean accept(IlvGraphic graphic) {
            return graphic instanceof IlvLinkImage;
        }

        public String toString() {
            return "is link";
        }
    };
    public static final GraphicFilter MANAGER = new GraphicFilter(){

        @Override
        public boolean accept(IlvGraphic graphic) {
            return graphic instanceof IlvManager;
        }

        public String toString() {
            return "is manager";
        }
    };

    public static class NamedPropertyEquals
    implements GraphicFilter {
        private IlvNamedProperty m_prop;

        public NamedPropertyEquals(IlvNamedProperty prop) {
            this.m_prop = prop;
        }

        @Override
        public boolean accept(IlvGraphic graphic) {
            return graphic.getNamedProperty(this.m_prop.getName()) != null && this.m_prop.equals(graphic.getNamedProperty(this.m_prop.getName()));
        }

        public String toString() {
            return this.getShortName() + ".NamedPropertyEquals(graphic.getNamedProperty())";
        }

        private String getShortName() {
            String shortName = this.m_prop.getName();
            int lastDot = shortName.lastIndexOf(46);
            if (lastDot != -1) {
                shortName = shortName.substring(lastDot + 1, shortName.length());
            }
            return shortName;
        }
    }
}

