/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.editor;

import ilog.views.IlvManagerView;
import ilog.views.IlvTransformer;
import java.net.URL;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.core.util.DiagramDTCache;
import oracle.diagram.framework.editor.DiagramDTSettingsPlugin;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;

public abstract class AbstractDiagramDTSettingsPlugin
extends AbstractPlugin
implements DiagramDTSettingsPlugin {
    private final DiagramContext _context;
    private static final String PREFIX = "oracle.diagram.";
    private static final String TX_ITEM = "oracle.diagram.tx";
    private static final String X11 = "x11";
    private static final String X12 = "x12";
    private static final String X21 = "x21";
    private static final String X22 = "x22";
    private static final String X0 = "x0";
    private static final String Y0 = "y0";

    protected AbstractDiagramDTSettingsPlugin(DiagramContext context) {
        this._context = context;
    }

    @Override
    public void saveSettings(StructuredPropertyAccess pa) {
        this.saveTransformer(pa);
    }

    @Override
    public void restoreSettings(StructuredPropertyAccess pa) {
        this.restoreTransformer(pa);
    }

    @Override
    public StructuredPropertyAccess getPropertyAccess() {
        return DiagramDTCache.getInstance().get(this.getDocumentURL());
    }

    public static void saveTransformer(StructuredPropertyAccess dtCache, IlvTransformer tx) {
        StructuredPropertyAccess txItem = dtCache.getChildNode(TX_ITEM);
        if (txItem != null) {
            dtCache.removeChild(txItem);
        }
        txItem = new DefaultStructuredPropertyAccess(TX_ITEM);
        txItem.setProperty(X11, Double.toString(tx.getx11()));
        txItem.setProperty(X12, Double.toString(tx.getx12()));
        txItem.setProperty(X21, Double.toString(tx.getx21()));
        txItem.setProperty(X22, Double.toString(tx.getx22()));
        txItem.setProperty(X0, Double.toString(tx.getx0()));
        txItem.setProperty(Y0, Double.toString(tx.gety0()));
        dtCache.appendChild(txItem);
    }

    protected final DiagramContext getDiagramContext() {
        return this._context;
    }

    protected abstract URL getDocumentURL();

    protected void saveTransformer(StructuredPropertyAccess dtCache) {
        IlvManagerView view = this.getDiagramContext().getManagerView();
        if (view != null) {
            IlvTransformer tx = view.getTransformer();
            AbstractDiagramDTSettingsPlugin.saveTransformer(dtCache, tx);
        }
    }

    protected void restoreTransformer(StructuredPropertyAccess dtCache) {
        StructuredPropertyAccess txItem = dtCache.getChildNode(TX_ITEM);
        if (txItem != null) {
            String x11 = txItem.getProperty(X11, null);
            String x12 = txItem.getProperty(X12, null);
            String x21 = txItem.getProperty(X21, null);
            String x22 = txItem.getProperty(X22, null);
            String x0 = txItem.getProperty(X0, null);
            String y0 = txItem.getProperty(Y0, null);
            if (x11 != null && x12 != null && x21 != null && x22 != null && x0 != null && y0 != null) {
                IlvTransformer tx = new IlvTransformer(Double.valueOf(x11).doubleValue(), Double.valueOf(x12).doubleValue(), Double.valueOf(x21).doubleValue(), Double.valueOf(x22).doubleValue(), Double.valueOf(x0).doubleValue(), Double.valueOf(y0).doubleValue());
                IlvManagerView view = this.getDiagramContext().getManagerView();
                view.setTransformer(tx);
            }
        }
    }
}

