/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.copypaste;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.framework.copypaste.AbstractCopyPastePlugin;
import oracle.diagram.framework.datatransfer.SelectionTransferData;
import oracle.diagram.framework.datatransfer.SelectionTransferable;
import oracle.diagram.framework.readonly.ReadOnlyUtil;
import oracle.ide.IdeClipboard;
import oracle.javatools.clipboard.ClipboardStack;

public class DefaultCopyPastePlugin
extends AbstractCopyPastePlugin {
    protected static final DataFlavor FLAVOR = SelectionTransferable.FLAVOR;
    private final DataFlavor _flavor;

    public DefaultCopyPastePlugin(DiagramContext context) {
        this(context, FLAVOR);
    }

    public DefaultCopyPastePlugin(DiagramContext context, DataFlavor flavor) {
        super(context);
        this._flavor = flavor;
    }

    @Override
    public boolean canCopy() {
        if (!this.hasSelection()) {
            return super.canCopy();
        }
        return true;
    }

    @Override
    public boolean canCut() {
        if (ReadOnlyUtil.isPermanentReadOnlyContext(this.getDiagramContext())) {
            return false;
        }
        if (!this.hasSelection()) {
            return super.canCut();
        }
        return true;
    }

    @Override
    public boolean canPaste() {
        if (ReadOnlyUtil.isPermanentReadOnlyContext(this.getDiagramContext())) {
            return false;
        }
        Clipboard clipboard = IdeClipboard.getClipboard();
        if (!clipboard.isDataFlavorAvailable(this.getDataFlavor())) {
            return super.canPaste();
        }
        return true;
    }

    @Override
    public void copy() {
        Clipboard clipboard = IdeClipboard.getClipboard();
        if (this.hasSelection()) {
            ClipboardStack.pushCurrentClipboard();
            try {
                clipboard.setContents(new SelectionTransferable(this.getManager(), this.getDataFlavor(), null), null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void cut() {
        Clipboard clipboard = IdeClipboard.getClipboard();
        if (this.hasSelection()) {
            IlvManager mgr = this.getManager();
            if (mgr != null) {
                ArrayList<IlvGraphic> graphics = new ArrayList<IlvGraphic>(mgr.getSelectedObjectsCount(true));
                IlvGraphicEnumeration e = mgr.getSelectedObjects(true);
                while (e.hasMoreElements()) {
                    graphics.add(e.nextElement());
                }
                if (!ReadOnlyUtil.checkWritableCut(this.getDiagramContext(), graphics.toArray(new IlvGraphic[graphics.size()]))) {
                    return;
                }
            }
            ClipboardStack.pushCurrentClipboard();
            try {
                clipboard.setContents(new SelectionTransferable(this.getManager(), this.getDataFlavor(), null), null);
                this.deleteForCut();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void deleteForCut() {
        IlvManager mgr = this.getManager();
        if (mgr != null) {
            mgr.deleteSelections(true, true);
        }
    }

    @Override
    public void paste() {
        Clipboard clipboard = IdeClipboard.getClipboard();
        if (clipboard.isDataFlavorAvailable(this.getDataFlavor())) {
            try {
                Transferable t = clipboard.getContents(null);
                IlvManagerView view = this.getDiagramContext().getManagerView();
                if (view == null) {
                    return;
                }
                if (t != null && !ReadOnlyUtil.checkWritablePaste(this.getDiagramContext(), t)) {
                    return;
                }
                IlvPoint ptCenter = new IlvPoint((float)(view.getX() + view.getWidth() / 2), (float)(view.getY() + view.getHeight() / 2));
                view.getTransformer().inverse(ptCenter);
                this.postPaste(SelectionTransferData.deserializeTo(this.getManager(), (String)t.getTransferData(this.getDataFlavor()), ptCenter, true));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            super.paste();
        }
    }

    protected void postPaste(IlvGraphicEnumeration pastedGraphics) {
    }

    protected IlvGraphicEnumeration getSelection() {
        IlvManager mgr = this.getManager();
        if (mgr == null) {
            return null;
        }
        return mgr.getSelectedObjects(true);
    }

    protected boolean hasSelection() {
        IlvManager mgr = this.getManager();
        if (mgr == null) {
            return false;
        }
        return mgr.getSelectedObjectsCount(true) != 0;
    }

    protected IlvManager getManager() {
        IlvManagerView view = this.getDiagramContext().getManagerView();
        if (view == null) {
            return null;
        }
        return view.getManager();
    }

    protected DataFlavor getDataFlavor() {
        return this._flavor;
    }
}

