/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.completion;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class RangeListModel<T>
implements ListModel {
    private List<T> m_storage;
    private int m_start;
    private int m_end;
    private List<ListDataListener> m_dataListeners;

    public RangeListModel(List<T> storage) {
        if (storage == null) {
            throw new IllegalArgumentException("storage is null");
        }
        this.m_storage = new ArrayList<T>(storage);
        this.m_start = 0;
        this.m_end = this.m_storage.size();
        this.m_dataListeners = new LinkedList<ListDataListener>();
    }

    @Override
    public int getSize() {
        return this.m_end - this.m_start;
    }

    public T getElementAt(int index) {
        int actualIndex = this.m_start + index;
        if (actualIndex >= this.m_start && actualIndex < this.m_end) {
            return this.m_storage.get(actualIndex);
        }
        return null;
    }

    public void setRange(int start, int end) {
        int oldStart = this.m_start;
        int oldEnd = this.m_end;
        int n = this.m_storage.size();
        int n2 = start < 0 ? 0 : (this.m_start = start > n ? n : start);
        int n3 = end < start ? start : (this.m_end = end > n ? n : end);
        if (oldStart != this.m_start || oldEnd != this.m_end) {
            ListDataEvent e = new ListDataEvent(this, 0, 0, this.m_end - this.m_start - 1);
            this.fireListDataEvent(e);
        }
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        if (l != null) {
            this.m_dataListeners.add(l);
        }
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        if (l != null) {
            this.m_dataListeners.remove(l);
        }
    }

    protected void fireListDataEvent(ListDataEvent e) {
        for (ListDataListener l : this.m_dataListeners) {
            l.contentsChanged(e);
        }
    }
}

