/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.action.handler;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import oracle.diagram.framework.action.Actions;
import oracle.diagram.framework.action.handler.AbstractHandler;
import oracle.diagram.framework.link.features.StraightenLinkPlugin;
import oracle.diagram.framework.readonly.ReadOnlyUtil;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;

public class StraightenLinkHandler
extends AbstractHandler {
    public boolean handleEvent(IdeAction action, Context context) {
        if (action.getCommandId() == Actions.CMD_STRAIGHTEN_LINK) {
            StraightenLinkPlugin plugin = this.getStraightenLinkPlugin(context);
            if (plugin != null && ReadOnlyUtil.checkWritable(this.getDiagramContext(context))) {
                plugin.straightenLink();
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        if (action.getCommandId() == Actions.CMD_STRAIGHTEN_LINK) {
            StraightenLinkPlugin plugin = this.getStraightenLinkPlugin(context);
            if (plugin != null) {
                IlvManagerView mView = this.getManagerView(context);
                IlvManager manager = mView.getManager();
                IlvGraphicEnumeration selection = manager.getSelectedObjects(true);
                boolean hasLinkSelected = false;
                while (!hasLinkSelected && selection.hasMoreElements()) {
                    IlvLinkImage link;
                    IlvGraphic element = selection.nextElement();
                    if (!(element instanceof IlvLinkImage) || (link = (IlvLinkImage)element).getFrom() == link.getTo()) continue;
                    hasLinkSelected = true;
                }
                action.setEnabled(hasLinkSelected);
            } else {
                action.setEnabled(false);
            }
            return true;
        }
        return false;
    }

    protected StraightenLinkPlugin getStraightenLinkPlugin(Context context) {
        return this.getPlugin(context, StraightenLinkPlugin.class);
    }
}

