/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.accessibility;

import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import java.awt.Color;
import java.util.List;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.diagram.framework.accessibility.ADACreate;
import oracle.diagram.framework.graphic.IMultipresentationContainer;

public abstract class ADACreateNode
extends ADACreate {
    protected static final String PARENT_SUBKEY = "parent";

    protected ADACreateNode() {
    }

    @Override
    protected String getBaseResourceKey() {
        return "ADACreateNode";
    }

    public boolean createNode() {
        List<IlvGraphic> contexts = this.getValidContexts();
        if (contexts.isEmpty()) {
            return false;
        }
        if (contexts.size() == 1) {
            return this.createNode(contexts.iterator().next());
        }
        final JList<Object> visualList = new JList<Object>(contexts.toArray());
        visualList.setBorder(new LineBorder(Color.BLACK));
        visualList.setName(this.getResources().getString(ADACreateNode.makeResKey(this.getBaseResourceKey(), PARENT_SUBKEY, "text")));
        visualList.setSelectionMode(0);
        visualList.setCellRenderer(new ADACreate.GraphicListCellRenderer());
        visualList.setVisibleRowCount(10);
        final ADACreate.ADACreateDialog dlg = new ADACreate.ADACreateDialog(new JScrollPane(visualList));
        ListSelectionListener lsl = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                dlg.setOKButtonEnabled(!visualList.isSelectionEmpty());
            }
        };
        visualList.addListSelectionListener(lsl);
        IlvGraphic singleSelectionGraphic = this.getInitialSelection();
        int singleSelectionIndex = contexts.indexOf(singleSelectionGraphic);
        if (singleSelectionIndex == -1 && singleSelectionGraphic != null && singleSelectionGraphic instanceof IMultipresentationContainer) {
            IlvGraphic pres = ((IMultipresentationContainer)singleSelectionGraphic).getCurrentPresentation();
            singleSelectionIndex = contexts.indexOf(pres);
        }
        if (singleSelectionIndex != -1) {
            visualList.addSelectionInterval(singleSelectionIndex, singleSelectionIndex);
        } else {
            int diagramIndex = contexts.indexOf(this.getRoot());
            if (diagramIndex != -1) {
                visualList.addSelectionInterval(diagramIndex, diagramIndex);
            } else if (!contexts.isEmpty()) {
                visualList.addSelectionInterval(0, 0);
            }
        }
        boolean result = dlg.runDialog();
        if (result) {
            return this.createNode((IlvGraphic)visualList.getSelectedValue());
        }
        return result;
    }

    protected abstract IlvManager getRoot();

    protected abstract List<IlvGraphic> getValidContexts();

    protected abstract boolean createNode(IlvGraphic var1);
}

