/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.core.util;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvManager;
import oracle.bm.util.DebugUtils;
import oracle.diagram.core.util.CoreGraphicUtils;
import oracle.diagram.core.util.IObjectNamingPolicy;

public final class DefaultObjectNamingPolicy
implements IObjectNamingPolicy {
    @Override
    public void setObjectName(IlvGraphic obj) {
        if (obj == null) {
            return;
        }
        String suffix = obj.getGraphicBag() instanceof IlvManager ? Integer.toString(((IlvManager)obj.getGraphicBag()).getCardinal()) : null;
        this.setObjectNameImpl(obj, suffix);
        if (obj instanceof IlvGraphicBag) {
            for (IlvGraphic graphic : CoreGraphicUtils.getBreadthFirstIlvGraphicIterator(obj)) {
                assert (graphic != null);
                this.setObjectNameImpl(graphic, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setObjectNameImpl(IlvGraphic obj, String suffix) {
        if (obj == null) {
            return;
        }
        try {
            if (CoreGraphicUtils.getTestName(obj) != null && !CoreGraphicUtils.getTestName(obj).isEmpty()) {
                return;
            }
            if (obj.getName() != null && !obj.getName().isEmpty()) {
                CoreGraphicUtils.setTestName(obj, obj.getName());
                return;
            }
            StringBuilder builder = new StringBuilder();
            builder.append(obj.getClass().getSimpleName());
            String tooltip = obj.getToolTipText();
            if (obj.getGraphicBag() instanceof IlvGraphicBag) {
                if (suffix != null) {
                    builder.append(".").append(suffix);
                }
                if (tooltip != null && !tooltip.isEmpty()) {
                    builder.append(".").append(tooltip);
                }
                boolean b = CoreGraphicUtils.setTestName(obj, builder.toString());
                if (!$assertionsDisabled) {
                    if (b) {
                    } else if (!DebugUtils.warning((String)("New test name " + builder.toString() + " for object " + obj + " is not unique in the container " + obj.getGraphicBag()))) {
                        throw new AssertionError();
                    }
                }
            } else {
                if (tooltip != null && !tooltip.isEmpty()) {
                    builder.append(".").append(tooltip);
                }
                boolean b = CoreGraphicUtils.setTestName(obj, builder.toString());
                if (!$assertionsDisabled) {
                    if (b) {
                    } else if (!DebugUtils.warning((String)("New test name " + builder.toString() + " for object " + obj + " is not unique in the container " + obj.getGraphicBag()))) {
                        throw new AssertionError();
                    }
                }
            }
        }
        finally {
            assert (CoreGraphicUtils.getTestName(obj) != null || DebugUtils.warning((String)("Name is null for object: " + obj)));
        }
    }
}

