/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.core.editor;

import ilog.views.IlvGrid;
import ilog.views.IlvManagerView;
import ilog.views.IlvRect;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.framework.graphic.DiagramRenderingHints;
import oracle.diagram.framework.print.PrintPlugin;

final class JViewPrintComponent
extends JComponent {
    private int myX;
    private int myY;
    private int myWidth;
    private int myHeight;
    private IlvManagerView myView;

    JViewPrintComponent(IlvManagerView view) {
        this.myView = view;
    }

    @Override
    public void validate() {
        IlvRect area = this.getPrintArea();
        if (area == null) {
            IlvRect rect = this.myView.computeBBox();
            this.myWidth = this.round(rect.width) + 1;
            this.myHeight = this.round(rect.height) + 1;
            this.myX = this.round(rect.x);
            this.myY = this.round(rect.y);
        } else {
            double zoom = this.myView.getTransformer().getx11();
            this.myWidth = this.round((double)area.width * zoom);
            this.myHeight = this.round((double)area.height * zoom);
            this.myView.getTransformer().boundingBox(area, false);
            this.myX = this.round(area.x);
            this.myY = this.round(area.y);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        IlvGrid grid = this.myView.getGrid();
        this.myView.setGrid(null);
        int mode = this.myView.getRedrawMode();
        this.myView.setRedrawMode(1);
        Graphics2D g = (Graphics2D)graphics.create(0, 0, this.myWidth, this.myHeight);
        g.setRenderingHint(DiagramRenderingHints.PUBLISH_RENDERING_HINT, Boolean.TRUE);
        g.translate(-this.myX, -this.myY);
        this.myView.setVisible(this.myView.getManager().getLayersCount(), false);
        this.myView.print((Graphics)g);
        g.dispose();
        this.myView.setVisible(this.myView.getManager().getLayersCount(), true);
        this.myView.setRedrawMode(mode);
        this.myView.setGrid(grid);
    }

    @Override
    public int getWidth() {
        return this.myWidth;
    }

    @Override
    public int getHeight() {
        return this.myHeight;
    }

    private IlvRect getPrintArea() {
        DiagramContext context = DiagramContext.getDiagramContext(this.myView);
        if (context == null) {
            return null;
        }
        PrintPlugin plugin = context.getPlugin(PrintPlugin.class);
        if (plugin == null) {
            return null;
        }
        return plugin.getPrintArea();
    }

    private int round(double value) {
        return (int)Math.round(value);
    }
}

