/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.core.editor;

import ilog.views.IlvGraphic;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.context.IdeContextPlugin;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.core.plugin.PluginManager;
import oracle.diagram.core.plugin.PluginUtil;
import oracle.diagram.core.plugin.RequestRouterPlugin;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.editor.OpenAbortedException;
import oracle.ide.help.HelpInfo;
import oracle.ide.util.StructuredPropertyAccess;

public abstract class Diagram {
    private final DiagramContext _diagramContext = new DiagramContext(this);

    public Diagram() {
        this._diagramContext.addPlugin(RequestRouterPlugin.class, new RequestRouter());
    }

    public final Context getContext() {
        IdeContextPlugin icp = this.getDiagramContext().getPlugin(IdeContextPlugin.class);
        return icp != null ? icp.getContext() : null;
    }

    public final DiagramContext getDiagramContext() {
        return this._diagramContext;
    }

    public void initContext(Context srcContext, Context diagramContext) {
    }

    public boolean canMorphContext() {
        return true;
    }

    public HelpInfo getHelpInfo() {
        return null;
    }

    public void close() {
        this._diagramContext.dispose();
    }

    public abstract void open() throws OpenAbortedException;

    public abstract Controller getController();

    public abstract void saveSettings(StructuredPropertyAccess var1);

    public abstract void loadSettings(StructuredPropertyAccess var1);

    public abstract void activate();

    public abstract void deactivate();

    protected static void rethrowOpenException(Throwable th) throws OpenAbortedException {
        if (th instanceof OpenAbortedException) {
            throw (OpenAbortedException)th;
        }
        OpenAbortedException oaex = new OpenAbortedException();
        oaex.initCause(th);
        throw oaex;
    }

    private final class RequestRouter
    extends AbstractPlugin
    implements RequestRouterPlugin {
        private RequestRouter() {
        }

        @Override
        public <T extends Plugin> T getPlugin(IlvGraphic graphic, Class<T> pluginClass) {
            for (int i = 0; i < 2; ++i) {
                T plugin;
                PluginManager pm;
                PluginManager pluginManager = pm = i == 0 ? PluginUtil.getPluginManager(graphic) : Diagram.this.getDiagramContext();
                if (pm == null || (plugin = pm.getPlugin(pluginClass)) == null) continue;
                return plugin;
            }
            return null;
        }
    }
}

