/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.maps.core.MapCanvas;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.ui.ErrorDialog;
import oracle.mdeditor.ui.ProgressDialog;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.spatial.edit.layer.AbstractDataSetLayer;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.MDSException;
import oracle.spatial.edit.ui.VersioningTableModel;

public class VersioningTablePanel
extends JPanel {
    private ArrayList<AbstractDataSetLayer> layers = null;
    private String[] tablesModel = null;
    private VersioningTableModel tableModel = new VersioningTableModel();
    private JTable table = new JTable(this.tableModel);
    private JScrollPane statusScrollPane = new JScrollPane(this.table);
    private JLabel keyLabel = new JLabel(MessagesBundle.getMessage("Label_primary_key"));
    private JComboBox keyCombo = new JComboBox();
    private JButton applyKeyButton = new JButton(MessagesBundle.getMessage("Apply"));
    private JButton enableVersionButton = new JButton(MessagesBundle.getMessage("Enable_versioning"));
    private Hashtable<String, String> keyColumn = new Hashtable();
    private Hashtable<String, Boolean> isVersioned = new Hashtable();
    private ImageIcon okIcon = Icons.getIcon("check.png");
    private ImageIcon errorIcon = Icons.getIcon("error.png");
    private int selectedRow = -1;
    private Frame frame = null;

    public VersioningTablePanel(Frame frameForThread, ArrayList<AbstractDataSetLayer> layers, String[] tablesModel) throws Exception {
        this.layers = layers;
        this.tablesModel = tablesModel;
        this.frame = frameForThread;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(330, 150));
        this.applyKeyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersioningTablePanel.this.applyKeyButton_actionPerformed(e);
            }
        });
        this.enableVersionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersioningTablePanel.this.enableVersionButton_actionPerformed(e);
            }
        });
        this.add((Component)this.statusScrollPane, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 5, 0), 0, 100));
        this.add((Component)this.keyLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.keyCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.applyKeyButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 10), 0, 0));
        this.add((Component)this.enableVersionButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 20), 0, 0));
        this.table.setSelectionMode(0);
        ListSelectionModel rowSM = this.table.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                VersioningTablePanel.this.processTableSelection();
            }
        });
        this.fillUI();
        if (this.tableModel.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
        if (!this.isReadyForEditing()) {
            int option = JOptionPane.showConfirmDialog(this.frame, MessagesBundle.getMessage("Versioning_question"));
            if (option != 0) {
                throw new Exception(MessagesBundle.getMessage("Layer_not_prepared_for_editing"));
            }
            ProgressDialog dlg = new ProgressDialog(this.frame);
            VersioningPostProcessingThread vth = new VersioningPostProcessingThread(dlg);
            vth.start();
            dlg.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillUI() {
        if (this.layers == null || this.layers.size() == 0) {
            return;
        }
        AbstractDataAccessObject da = null;
        try {
            for (AbstractDataSetLayer layer : this.layers) {
                String table = layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable");
                try {
                    da = layer.getDataSource().getDataAccessObject();
                    da.openConnection();
                    boolean versionEnabled = layer.isVersionEnabled();
                    this.isVersioned.put(table.toUpperCase(), versionEnabled);
                    String pkey = null;
                    pkey = da.getTablePrimaryKey(table);
                    if (pkey != null) {
                        this.keyColumn.put(table.toUpperCase(), pkey);
                        String lykey = layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn");
                        if (lykey != null && lykey.equalsIgnoreCase("ROWID")) {
                            layer.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn", pkey);
                        }
                    }
                }
                catch (MDSException ex) {
                    ErrorDialog.showErrorDialog(ex, this, MessagesBundle.getFormattedMessage("Unable_toget_table_information", table), MessagesBundle.getMessage("Error"), 2);
                }
                catch (Exception e) {
                    System.out.println(MessagesBundle.getFormattedMessage("Unable_toget_table_information", table));
                }
                ImageIcon pkey = null;
                pkey = this.keyColumn.get(table.toUpperCase()) != null ? this.okIcon : this.errorIcon;
                ImageIcon ve = null;
                Boolean b = this.isVersioned.get(table.toUpperCase());
                ve = b != null && b == true ? this.okIcon : this.errorIcon;
                this.tableModel.addStatusRow(-1, table, pkey, ve);
            }
        }
        catch (Exception ex) {
            System.out.println(MessagesBundle.getMessage("Versioning_check_error"));
        }
        finally {
            if (da != null) {
                try {
                    da.closeConnection();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void processTableSelection() {
        this.selectedRow = this.table.getSelectedRow();
        AbstractDataSetLayer layer = this.layers.get(this.selectedRow);
        if (this.selectedRow > -1) {
            String table = (String)this.tableModel.getValueAt(this.selectedRow, 0);
            String key = this.keyColumn.get(table.toUpperCase());
            this.keyCombo.removeAllItems();
            if (key == null) {
                this.keyCombo.setEnabled(true);
                String[] attrs = layer.getNonComplexAttributes();
                if (attrs == null) {
                    ErrorDialog.showErrorDialog(null, this, MessagesBundle.getFormattedMessage("Unable_toget_table_attributes", table), MessagesBundle.getMessage("Error"), 2);
                } else if (attrs.length > 0) {
                    for (int i = 0; i < attrs.length; ++i) {
                        this.keyCombo.addItem(attrs[i]);
                    }
                }
                if (this.keyCombo.getItemCount() > 0) {
                    this.applyKeyButton.setEnabled(true);
                } else {
                    this.applyKeyButton.setEnabled(false);
                }
            } else {
                this.keyCombo.setEnabled(false);
                this.keyCombo.addItem(key);
                this.applyKeyButton.setEnabled(false);
            }
            Boolean ve = this.isVersioned.get(table);
            if (!(key == null || ve != null && ve.booleanValue())) {
                this.enableVersionButton.setEnabled(true);
            } else {
                this.enableVersionButton.setEnabled(false);
            }
        } else {
            this.keyCombo.removeAllItems();
            this.keyCombo.setEnabled(false);
            this.enableVersionButton.setEnabled(false);
        }
    }

    public boolean isReadyForEditing() {
        if (this.tableModel.getRowCount() == 0) {
            return false;
        }
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            String table = (String)this.tableModel.getValueAt(i, 0);
            String key = this.keyColumn.get(table.toUpperCase());
            if (key == null) {
                return false;
            }
            Boolean ve = this.isVersioned.get(table.toUpperCase());
            if (ve != null && ve.booleanValue()) continue;
            return false;
        }
        return true;
    }

    private void applyKeyButton_actionPerformed(ActionEvent e) {
        if (this.selectedRow < 0 || this.keyCombo.getItemCount() == 0) {
            return;
        }
        AbstractDataSetLayer layer = this.layers.get(this.selectedRow);
        String table = layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable");
        String key = this.keyCombo.getSelectedItem().toString();
        boolean isSet = false;
        Throwable exception = null;
        this.setWaitCursor();
        try {
            isSet = this.setTablePrimaryKey(layer, key);
        }
        catch (MDSException ex) {
            exception = ex;
        }
        catch (Exception ex) {
            exception = ex;
        }
        this.setDefaultCursor();
        if (!isSet) {
            ErrorDialog.showErrorDialog(exception, this, MessagesBundle.getFormattedMessage("Unable_toset_table_primarykey", key, table), MessagesBundle.getMessage("Error"), 2);
            return;
        }
        this.tableModel.setValueAt(this.okIcon, this.selectedRow, 1);
        this.keyColumn.put(table.toUpperCase(), key);
        this.keyCombo.removeAllItems();
        this.keyCombo.addItem(key);
        this.keyCombo.setEnabled(false);
        this.applyKeyButton.setEnabled(false);
        this.enableVersionButton.setEnabled(true);
        this.enableVersionButton_actionPerformed(null);
    }

    private void enableVersionButton_actionPerformed(ActionEvent e) {
        SwingWorker<Void, Void> w = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() throws Exception {
                int confirm;
                if (VersioningTablePanel.this.selectedRow < 0) {
                    return null;
                }
                AbstractDataSetLayer layer = (AbstractDataSetLayer)VersioningTablePanel.this.layers.get(VersioningTablePanel.this.selectedRow);
                String table = layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable");
                String tbModel = VersioningTablePanel.this.tablesModel[VersioningTablePanel.this.selectedRow];
                String spatialModel = null;
                if (tbModel != null && tbModel.indexOf("topology:") > -1) {
                    spatialModel = tbModel.substring(9);
                }
                if (spatialModel != null && (confirm = JOptionPane.showConfirmDialog(ErrorDialog.getFrameForDialog(VersioningTablePanel.this), "All topology tables associated with topology " + spatialModel + " will be version enabled. Continue?", MessagesBundle.getMessage("Refresh_connection"), 0, 2)) != 0) {
                    return null;
                }
                boolean isEnabled = false;
                Throwable exception = null;
                MapCanvas cv = layer.getCanvas();
                if (cv != null) {
                    cv.propertyChange(new PropertyChangeEvent(VersioningTablePanel.this, "progressIndeterminate", null, true));
                    cv.propertyChange(new PropertyChangeEvent(VersioningTablePanel.this, "progressString", null, MessagesBundle.getFormattedMessage("Task_enabling_versioning", table)));
                }
                VersioningTablePanel.this.setWaitCursor();
                try {
                    isEnabled = VersioningTablePanel.this.enableTableVersioning(layer, tbModel);
                }
                catch (MDSException ex) {
                    exception = ex;
                }
                catch (Exception ex) {
                    exception = ex;
                }
                VersioningTablePanel.this.setDefaultCursor();
                if (isEnabled) {
                    if (cv != null) {
                        cv.propertyChange(new PropertyChangeEvent(VersioningTablePanel.this, "state", null, (Object)SwingWorker.StateValue.DONE));
                    }
                    if (spatialModel != null) {
                        for (int i = 0; i < VersioningTablePanel.this.layers.size(); ++i) {
                            String tbmd;
                            if (i == VersioningTablePanel.this.selectedRow || (tbmd = VersioningTablePanel.this.tablesModel[i]) == null || !tbmd.equalsIgnoreCase(tbModel)) continue;
                            VersioningTablePanel.this.tableModel.setValueAt(VersioningTablePanel.this.okIcon, i, 2);
                            VersioningTablePanel.this.isVersioned.put(((AbstractDataSetLayer)VersioningTablePanel.this.layers.get(i)).getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable").toUpperCase(), true);
                        }
                    }
                    VersioningTablePanel.this.tableModel.setValueAt(VersioningTablePanel.this.okIcon, VersioningTablePanel.this.selectedRow, 2);
                    VersioningTablePanel.this.isVersioned.put(table.toUpperCase(), true);
                    VersioningTablePanel.this.enableVersionButton.setEnabled(false);
                } else {
                    if (cv != null) {
                        cv.propertyChange(new PropertyChangeEvent(VersioningTablePanel.this, "state", null, (Object)SwingWorker.StateValue.DONE));
                    }
                    ErrorDialog.showErrorDialog(exception, VersioningTablePanel.this, MessagesBundle.getFormattedMessage("Unable_toenable_table_versioning", table), MessagesBundle.getMessage("Error"), 2);
                }
                return null;
            }
        };
        w.execute();
    }

    public String getKeyColumn(String table) {
        if (table == null) {
            return null;
        }
        return this.keyColumn.get(table.toUpperCase());
    }

    private void setWaitCursor() {
        this.setCursor(new Cursor(3));
    }

    private void setDefaultCursor() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private boolean setTablePrimaryKey(AbstractDataSetLayer layer, String key) throws Exception, MDSException {
        if (layer == null || key == null) {
            return false;
        }
        String table = layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable");
        if (table == null) {
            return false;
        }
        AbstractDataAccessObject dataAccess = null;
        boolean status = false;
        try {
            dataAccess = layer.getDataSource().getDataAccessObject();
            dataAccess.openConnection();
            status = dataAccess.setTablePrimaryKey(table, key);
            if (status) {
                layer.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn", key);
            }
        }
        catch (MDSException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (dataAccess != null) {
                try {
                    dataAccess.closeConnection();
                }
                catch (Exception ep) {
                    ep.printStackTrace();
                }
            }
        }
        return status;
    }

    private boolean enableTableVersioning(AbstractDataSetLayer layer, String tbModel) throws Exception, MDSException {
        if (layer == null) {
            return false;
        }
        boolean status = false;
        status = layer.enableVersioning();
        return status;
    }

    private class VersioningPostProcessingThread
    extends Thread {
        private ProgressDialog pgrdlg = null;

        public VersioningPostProcessingThread(ProgressDialog dlg) {
            this.pgrdlg = dlg;
        }

        @Override
        public void run() {
            this.pgrdlg.setTitle(MessagesBundle.getMessage("Versioning_post_processing"));
            for (int i = 0; i < VersioningTablePanel.this.tableModel.getRowCount(); ++i) {
                String tbmd;
                String key;
                String table = (String)VersioningTablePanel.this.tableModel.getValueAt(i, 0);
                String tbModel = VersioningTablePanel.this.tablesModel[i];
                String spatialModel = null;
                if (tbModel != null && tbModel.indexOf("topology:") > -1) {
                    spatialModel = tbModel.substring(9);
                }
                if ((key = (String)VersioningTablePanel.this.keyColumn.get(table.toUpperCase())) == null) {
                    String keyCol = ((AbstractDataSetLayer)VersioningTablePanel.this.layers.get(i)).getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn");
                    if (keyCol == null || keyCol.equalsIgnoreCase("ROWID")) continue;
                    try {
                        this.pgrdlg.setTaskMessage(MessagesBundle.getFormattedMessage("Task_set_primarykey", keyCol, table));
                        if (!VersioningTablePanel.this.setTablePrimaryKey((AbstractDataSetLayer)VersioningTablePanel.this.layers.get(i), keyCol)) continue;
                        VersioningTablePanel.this.tableModel.setValueAt(VersioningTablePanel.this.okIcon, i, 1);
                        VersioningTablePanel.this.keyColumn.put(table.toUpperCase(), keyCol);
                        this.pgrdlg.setTaskMessage(MessagesBundle.getFormattedMessage("Task_enabling_versioning", table));
                        if (!VersioningTablePanel.this.enableTableVersioning((AbstractDataSetLayer)VersioningTablePanel.this.layers.get(i), tbModel)) continue;
                        if (spatialModel != null) {
                            for (int j = 0; j < VersioningTablePanel.this.tableModel.getRowCount(); ++j) {
                                if (j == i || (tbmd = VersioningTablePanel.this.tablesModel[j]) == null || !tbmd.equalsIgnoreCase(tbModel)) continue;
                                VersioningTablePanel.this.tableModel.setValueAt(VersioningTablePanel.this.okIcon, j, 2);
                                VersioningTablePanel.this.isVersioned.put(((AbstractDataSetLayer)VersioningTablePanel.this.layers.get(j)).getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable").toUpperCase(), true);
                            }
                        }
                        VersioningTablePanel.this.tableModel.setValueAt(VersioningTablePanel.this.okIcon, i, 2);
                        VersioningTablePanel.this.isVersioned.put(table.toUpperCase(), true);
                    }
                    catch (MDSException ex) {
                        ex.printStackTrace();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    continue;
                }
                Boolean ve = (Boolean)VersioningTablePanel.this.isVersioned.get(table.toUpperCase());
                if (ve != null && ve.booleanValue()) continue;
                try {
                    this.pgrdlg.setTaskMessage(MessagesBundle.getFormattedMessage("Task_enabling_versioning", table));
                    if (!VersioningTablePanel.this.enableTableVersioning((AbstractDataSetLayer)VersioningTablePanel.this.layers.get(i), tbModel)) continue;
                    if (spatialModel != null) {
                        for (int j = 0; j < VersioningTablePanel.this.tableModel.getRowCount(); ++j) {
                            if (j == i || (tbmd = VersioningTablePanel.this.tablesModel[j]) == null || !tbmd.equalsIgnoreCase(tbModel)) continue;
                            VersioningTablePanel.this.tableModel.setValueAt(VersioningTablePanel.this.okIcon, j, 2);
                            VersioningTablePanel.this.isVersioned.put(((AbstractDataSetLayer)VersioningTablePanel.this.layers.get(j)).getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable").toUpperCase(), true);
                        }
                    }
                    VersioningTablePanel.this.tableModel.setValueAt(VersioningTablePanel.this.okIcon, i, 2);
                    VersioningTablePanel.this.isVersioned.put(table.toUpperCase(), true);
                    continue;
                }
                catch (MDSException ex) {
                    ex.printStackTrace();
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.pgrdlg.setVisible(false);
        }
    }
}

