/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.ui;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class DisableVersioningTableModel
extends AbstractTableModel {
    Vector statusRecords = new Vector();
    protected static int NUM_COLUMNS = 2;
    protected static int START_NUM_ROWS = 0;
    protected int numRows = 0;
    static final String TABLENAME = MessagesBundle.getMessage("Layer_name");
    static final String DISABLEVERSIONING = MessagesBundle.getMessage("Disable_versioning");

    public DisableVersioningTableModel() {
        for (int i = 0; i < START_NUM_ROWS; ++i) {
            this.statusRecords.addElement(new StatusRecord());
        }
        this.numRows = 0;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return TABLENAME;
            }
            case 1: {
                return DISABLEVERSIONING;
            }
        }
        return "";
    }

    @Override
    public int getColumnCount() {
        return NUM_COLUMNS;
    }

    public Class getColumnClass(int col) {
        if (col == 0) {
            return String.class;
        }
        if (col == 1) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 0;
    }

    @Override
    public int getRowCount() {
        if (this.numRows < START_NUM_ROWS) {
            return START_NUM_ROWS;
        }
        return this.numRows;
    }

    public int getNumberOfRecords() {
        return this.numRows;
    }

    @Override
    public Object getValueAt(int row, int col) {
        try {
            StatusRecord rec = (StatusRecord)this.statusRecords.elementAt(row);
            switch (col) {
                case 0: {
                    return rec.tableName;
                }
                case 1: {
                    return rec.disableVersion;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        StatusRecord rec = (StatusRecord)this.statusRecords.elementAt(row);
        if (value == null) {
            if (col == 0) {
                rec.tableName = null;
            } else if (col == 1) {
                rec.disableVersion = null;
            }
        } else if (col == 0) {
            rec.tableName = (String)value;
        } else if (col == 1) {
            rec.disableVersion = (Boolean)value;
        }
        this.fireTableCellUpdated(row, col);
    }

    public void clearData() {
        this.statusRecords.removeAllElements();
        if (this.numRows > START_NUM_ROWS) {
            this.fireTableRowsDeleted(START_NUM_ROWS, this.numRows - 1);
        }
        for (int i = 0; i < START_NUM_ROWS; ++i) {
            this.statusRecords.addElement(new StatusRecord());
            this.fireTableRowsUpdated(i, i);
        }
        this.numRows = 0;
    }

    public void addStatusRow(int idx) {
        if (idx == -1) {
            this.statusRecords.add(new StatusRecord());
            this.fireTableRowsInserted(this.numRows, this.numRows);
        } else {
            this.statusRecords.insertElementAt(new StatusRecord(), idx + 1);
            this.fireTableRowsInserted(idx + 1, idx + 1);
        }
        ++this.numRows;
    }

    public void addStatusRow(int idx, String tableName, Boolean disable) {
        StatusRecord rec = new StatusRecord();
        rec.tableName = tableName;
        rec.disableVersion = disable;
        if (idx == -1) {
            this.statusRecords.add(rec);
            this.fireTableRowsInserted(this.numRows, this.numRows);
        } else {
            this.statusRecords.insertElementAt(rec, idx + 1);
            this.fireTableRowsInserted(idx + 1, idx + 1);
        }
        ++this.numRows;
    }

    public void deleteStatusRow(int idx) {
        this.statusRecords.removeElementAt(idx);
        this.fireTableRowsDeleted(idx, idx);
        --this.numRows;
        if (this.numRows < START_NUM_ROWS) {
            this.statusRecords.addElement(new StatusRecord());
            this.fireTableRowsInserted(this.numRows, this.numRows);
            ++this.numRows;
        }
    }

    class StatusRecord {
        String tableName = null;
        Boolean disableVersion = null;

        StatusRecord() {
        }
    }
}

