/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.producer;

import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.List;
import oracle.maps.util.TransformUtils;
import oracle.spatial.edit.layer.AnnotationTextSetLayer;
import oracle.spatial.edit.model.AbstractDataSet;
import oracle.spatial.edit.producer.AbstractDataSetProducer;

public class AnnotationTextSetProducer
extends AbstractDataSetProducer {
    public AnnotationTextSetProducer(AnnotationTextSetLayer layer) {
        super(layer);
    }

    @Override
    public String getSpatialType() {
        return AbstractDataSet.ANNOTATION_TEXT_SET;
    }

    @Override
    public String buildQuery(Area queryArea, int srid) {
        String baseTable = this.layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable");
        String keyColumn = this.layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn");
        String spatialColumn = this.layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn");
        String queryCondition = this.layer.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.queryCondition");
        String tableAlias = "meo_atext";
        StringBuilder query = new StringBuilder("SELECT ");
        if (keyColumn.equalsIgnoreCase("rowid")) {
            query.append(tableAlias + ".rowid, " + tableAlias + ".*");
        } else {
            query.append("*");
        }
        query.append(" FROM " + baseTable + " " + tableAlias + " WHERE (");
        List<Rectangle2D> rectangles = TransformUtils.areaToRectangles(queryArea);
        if (rectangles.size() > 30 || rectangles.size() == 0) {
            rectangles.clear();
            rectangles.add(queryArea.getBounds2D());
        }
        boolean first = true;
        for (Rectangle2D rec : rectangles) {
            if (!first) {
                query.append(" OR ");
            }
            query.append("SDO_FILTER(" + tableAlias + "." + spatialColumn + ".privateenvelope" + ", SDO_GEOMETRY(2003, " + srid + ", NULL" + ", SDO_ELEM_INFO_ARRAY(1, 1003, 3)" + ", SDO_ORDINATE_ARRAY(" + rec.getMinX() + "," + rec.getMinY() + "," + rec.getMaxX() + "," + rec.getMaxY() + "))) = 'TRUE'");
            first = false;
        }
        query.append(")");
        if (queryCondition != null) {
            query.append(" AND " + queryCondition);
        }
        return query.toString();
    }
}

