/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.model.topology;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import oracle.mapviewer.share.TopoChildFeatureDescriptor;
import oracle.mapviewer.share.TopoPrimitiveDescriptor;
import oracle.spatial.edit.model.topology.TopologyModel;
import oracle.spatial.geometry.JGeometry;

public class TopologyGeometry
implements Cloneable {
    private int tgId = 0;
    private int tgLayerId = 0;
    private String tgType = null;
    private ArrayList<TopoPrimitiveDescriptor> topoPrimitives = null;
    private ArrayList<TopoChildFeatureDescriptor> topoChildFeatures = null;
    private Rectangle2D tgMbr = null;
    private JGeometry[] geometries = null;

    public Object clone() {
        try {
            TopoPrimitiveDescriptor todef;
            int i;
            TopologyGeometry obj = (TopologyGeometry)super.clone();
            if (this.topoPrimitives != null) {
                obj.topoPrimitives = new ArrayList();
                for (i = 0; i < this.topoPrimitives.size(); ++i) {
                    todef = new TopoPrimitiveDescriptor();
                    todef.setTopoId(this.topoPrimitives.get(i).getTopoId());
                    todef.setTopoType(this.topoPrimitives.get(i).getTopoType());
                    obj.topoPrimitives.add(todef);
                }
            }
            if (this.topoChildFeatures != null && this.topoChildFeatures.size() > 0) {
                obj.topoChildFeatures = new ArrayList();
                for (i = 0; i < this.topoChildFeatures.size(); ++i) {
                    todef = new TopoChildFeatureDescriptor();
                    todef.setLayerId(this.topoChildFeatures.get(i).getLayerId());
                    todef.setFeatureId(this.topoChildFeatures.get(i).getFeatureId());
                    obj.topoChildFeatures.add((TopoChildFeatureDescriptor)todef);
                }
            }
            return obj;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public int getId() {
        return this.tgId;
    }

    public void setId(int id) {
        this.tgId = id;
    }

    public int getLayerId() {
        return this.tgLayerId;
    }

    public void setLayerId(int lid) {
        this.tgLayerId = lid;
    }

    public boolean addTopoPrimitive(int topoId, int topoType) {
        if (this.topoPrimitives == null) {
            this.topoPrimitives = new ArrayList();
        }
        for (int i = 0; i < this.topoPrimitives.size(); ++i) {
            TopoPrimitiveDescriptor obj = this.topoPrimitives.get(i);
            if (obj.getTopoId() != topoId || obj.getTopoType() != topoType) continue;
            return true;
        }
        TopoPrimitiveDescriptor obj = new TopoPrimitiveDescriptor();
        obj.setTopoId(topoId);
        obj.setTopoType(topoType);
        this.topoPrimitives.add(obj);
        return true;
    }

    public boolean removeTopoPrimitive(long topoId, long topoType) {
        if (this.topoPrimitives == null || this.topoPrimitives.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.topoPrimitives.size(); ++i) {
            TopoPrimitiveDescriptor obj = this.topoPrimitives.get(i);
            if ((long)obj.getTopoId() != topoId || (long)obj.getTopoType() != topoType) continue;
            TopoPrimitiveDescriptor tp = this.topoPrimitives.remove(i);
            return tp != null;
        }
        return false;
    }

    public boolean hasTopoPrimitive(int topoId, int topoType) {
        if (this.topoPrimitives == null) {
            return false;
        }
        for (int i = 0; i < this.topoPrimitives.size(); ++i) {
            TopoPrimitiveDescriptor obj = this.topoPrimitives.get(i);
            if (obj.getTopoId() != topoId || obj.getTopoType() != topoType) continue;
            return true;
        }
        return false;
    }

    public TopoPrimitiveDescriptor[] getTopoPrimitives() {
        if (this.topoPrimitives == null || this.topoPrimitives.size() == 0) {
            return null;
        }
        return this.topoPrimitives.toArray(new TopoPrimitiveDescriptor[this.topoPrimitives.size()]);
    }

    public TopoPrimitiveDescriptor[] getTopoPrimitives(int type) {
        if (this.topoPrimitives == null || this.topoPrimitives.size() == 0) {
            return null;
        }
        ArrayList<TopoPrimitiveDescriptor> primitives = new ArrayList<TopoPrimitiveDescriptor>();
        for (int i = 0; i < this.topoPrimitives.size(); ++i) {
            TopoPrimitiveDescriptor obj = this.topoPrimitives.get(i);
            if (obj.getTopoType() != type) continue;
            primitives.add(obj);
        }
        if (primitives.size() == 0) {
            return null;
        }
        return primitives.toArray(new TopoPrimitiveDescriptor[primitives.size()]);
    }

    public int getNumberOfTopoPrimitives() {
        if (this.topoPrimitives == null || this.topoPrimitives.size() == 0) {
            return 0;
        }
        return this.topoPrimitives.size();
    }

    public void setTopoType(String type) {
        if (type == null || !type.equalsIgnoreCase("POINT") && !type.equalsIgnoreCase("LINE") && !type.equalsIgnoreCase("POLYGON") && !type.equalsIgnoreCase("COLLECTION")) {
            return;
        }
        this.tgType = type;
    }

    public String getTopoType() {
        return this.tgType;
    }

    public int getTopoTypeIntValue() {
        if (this.tgType == null) {
            return 0;
        }
        if (this.tgType.equalsIgnoreCase("POINT")) {
            return 1;
        }
        if (this.tgType.equalsIgnoreCase("LINE")) {
            return 2;
        }
        if (this.tgType.equalsIgnoreCase("POLYGON")) {
            return 3;
        }
        if (this.tgType.equalsIgnoreCase("COLLECTION")) {
            return 4;
        }
        return 0;
    }

    public Rectangle2D getMBR() {
        return this.tgMbr;
    }

    public void clearMBR() {
        this.tgMbr = null;
    }

    public Rectangle2D updateMBR(TopologyModel topoModel) {
        this.tgMbr = null;
        if (topoModel == null) {
            return this.tgMbr;
        }
        ArrayList<TopoPrimitiveDescriptor> primitives = null;
        if (this.topoPrimitives != null && this.topoPrimitives.size() > 0) {
            primitives = this.topoPrimitives;
        } else if (this.topoChildFeatures != null && this.topoChildFeatures.size() > 0) {
            primitives = topoModel.getTopoPrimitives(this.tgLayerId, this.getChildFeatures());
        }
        if (primitives != null) {
            for (int i = 0; i < primitives.size(); ++i) {
                int topoId = primitives.get(i).getTopoId();
                int topoType = primitives.get(i).getTopoType();
                Rectangle2D mbr = null;
                if (topoType == 1) {
                    mbr = topoModel.getNodeMBR(topoId);
                } else if (topoType == 2) {
                    mbr = topoModel.getEdgeMBR(topoId);
                } else if (topoType == 3) {
                    mbr = topoModel.getFaceMBR(topoId);
                }
                if (mbr == null) continue;
                if (this.tgMbr == null) {
                    this.tgMbr = mbr;
                    continue;
                }
                this.tgMbr.add(mbr);
            }
        }
        return this.tgMbr;
    }

    public JGeometry[] getGeometries(TopologyModel model) {
        if (this.geometries != null) {
            return this.geometries;
        }
        return this.buildGeometries(model);
    }

    public void clearGeometries() {
        this.geometries = null;
    }

    public JGeometry[] buildGeometries(TopologyModel model) {
        int topoId;
        JGeometry geom;
        int topoType;
        int i;
        this.geometries = null;
        if (model == null) {
            return null;
        }
        ArrayList<TopoPrimitiveDescriptor> primitives = null;
        if (this.topoPrimitives != null && this.topoPrimitives.size() > 0) {
            primitives = this.topoPrimitives;
        } else if (this.topoChildFeatures != null && this.topoChildFeatures.size() > 0) {
            primitives = model.getTopoPrimitives(this.tgLayerId, this.getChildFeatures());
        }
        if (primitives == null) {
            return null;
        }
        ArrayList<JGeometry> geoms = new ArrayList<JGeometry>();
        for (i = 0; i < primitives.size(); ++i) {
            topoType = primitives.get(i).getTopoType();
            if (topoType != 3 || (geom = model.getFaceGeometry(topoId = primitives.get(i).getTopoId())) == null) continue;
            geoms.add(geom);
        }
        for (i = 0; i < primitives.size(); ++i) {
            topoType = primitives.get(i).getTopoType();
            if (topoType != 2 || (geom = model.getEdgeGeometry(topoId = primitives.get(i).getTopoId())) == null) continue;
            geoms.add(geom);
        }
        for (i = 0; i < primitives.size(); ++i) {
            topoType = primitives.get(i).getTopoType();
            if (topoType != 1 || (geom = model.getNodeGeometry(topoId = primitives.get(i).getTopoId())) == null) continue;
            geoms.add(geom);
        }
        this.geometries = geoms.size() == 0 ? null : geoms.toArray(new JGeometry[geoms.size()]);
        return this.geometries;
    }

    public boolean addChildFeature(int layerId, int featureId) {
        if (this.topoChildFeatures == null) {
            this.topoChildFeatures = new ArrayList();
        }
        for (int i = 0; i < this.topoChildFeatures.size(); ++i) {
            TopoChildFeatureDescriptor obj = this.topoChildFeatures.get(i);
            if (obj.getLayerId() != layerId || obj.getFeatureId() != featureId) continue;
            return true;
        }
        TopoChildFeatureDescriptor obj = new TopoChildFeatureDescriptor();
        obj.setLayerId(layerId);
        obj.setFeatureId(featureId);
        this.topoChildFeatures.add(obj);
        return true;
    }

    public boolean removeChildFeature(int layerId, int featureId) {
        if (this.topoChildFeatures == null || this.topoChildFeatures.size() == 0) {
            return false;
        }
        for (int i = 0; i < this.topoChildFeatures.size(); ++i) {
            TopoChildFeatureDescriptor obj = this.topoChildFeatures.get(i);
            if (obj.getLayerId() != layerId || obj.getFeatureId() != featureId) continue;
            TopoChildFeatureDescriptor tp = this.topoChildFeatures.remove(i);
            return tp != null;
        }
        return false;
    }

    public TopoChildFeatureDescriptor[] getChildFeatures() {
        if (this.topoChildFeatures == null || this.topoChildFeatures.size() == 0) {
            return null;
        }
        return this.topoChildFeatures.toArray(new TopoChildFeatureDescriptor[this.topoChildFeatures.size()]);
    }

    public int getNumberOfChildFeatures() {
        if (this.topoChildFeatures == null || this.topoChildFeatures.size() == 0) {
            return 0;
        }
        return this.topoChildFeatures.size();
    }

    public boolean hasChildFeature(int layerId, int featureId) {
        if (this.topoChildFeatures == null) {
            return false;
        }
        for (int i = 0; i < this.topoChildFeatures.size(); ++i) {
            TopoChildFeatureDescriptor obj = this.topoChildFeatures.get(i);
            if (obj.getLayerId() != layerId || obj.getFeatureId() != featureId) continue;
            return true;
        }
        return false;
    }
}

