/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.model.topology;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import oracle.maps.core.Drawable;
import oracle.maps.core.GeoObject;
import oracle.maps.geoobject.AbstractFeature;
import oracle.spatial.edit.model.topology.TopologyGeometry;
import oracle.spatial.edit.model.topology.TopologyModel;
import oracle.spatial.geometry.JGeometry;

public class TopologyFeature
extends AbstractFeature {
    private TopologyModel topoModel = null;

    @Override
    public boolean isSubElementOf(GeoObject obj) {
        return false;
    }

    @Override
    public List<GeoObject> substract(List<? extends GeoObject> obj) {
        throw new UnsupportedOperationException();
    }

    public TopologyModel getTopologyModel() {
        return this.topoModel;
    }

    public void setTopologyModel(TopologyModel model) {
        this.topoModel = model;
    }

    @Override
    public Rectangle2D getMBR() {
        if (this.spatialAttr == null) {
            return null;
        }
        if (this.getSpatialAttribute().getMBR() == null) {
            this.getSpatialAttribute().updateMBR(this.topoModel);
        }
        return this.getSpatialAttribute().getMBR();
    }

    @Override
    public int getSpatialDimension() {
        if (this.spatialAttr == null || this.topoModel == null) {
            return -1;
        }
        JGeometry[] geoms = this.getSpatialAttribute().getGeometries(this.topoModel);
        if (geoms == null || geoms.length == 0) {
            return -1;
        }
        return geoms[0].getDimensions();
    }

    @Override
    public TopologyGeometry getSpatialAttribute() {
        return (TopologyGeometry)this.spatialAttr;
    }

    @Override
    public void setSpatialAttribute(Object spatialAttr) {
        this.spatialAttr = (TopologyGeometry)spatialAttr;
    }

    @Override
    public TopologyGeometry getSpatialAttributeClone() {
        return (TopologyGeometry)this.getSpatialAttribute().clone();
    }

    public int getNumberOfTopoPrimitives() {
        TopologyGeometry tpgeom = this.getSpatialAttribute();
        if (tpgeom == null) {
            return 0;
        }
        return tpgeom.getNumberOfTopoPrimitives();
    }

    public int getNumberOfChildFeatures() {
        TopologyGeometry tpgeom = this.getSpatialAttribute();
        if (tpgeom == null) {
            return 0;
        }
        return tpgeom.getNumberOfChildFeatures();
    }

    @Override
    public Point2D[] getSpatialJavaPoints() {
        if (this.spatialAttr == null || this.topoModel == null) {
            return null;
        }
        return null;
    }

    @Override
    public Drawable getDrawable(AffineTransform viewportTransform) {
        if (this.spatialAttr == null) {
            return null;
        }
        JGeometry[] geoms = this.getSpatialAttribute().getGeometries(this.topoModel);
        if (geoms == null || geoms.length == 0) {
            return null;
        }
        return Drawable.createDrawable(geoms, viewportTransform);
    }
}

