/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.model.annotationtext;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import oracle.maps.core.Drawable;
import oracle.maps.core.GeoObject;
import oracle.maps.geoobject.AbstractFeature;
import oracle.sdovis.edit.util.JGeometryUtil;
import oracle.sdovis.text.AnnotationText;
import oracle.sdovis.text.AnnotationTextElement;
import oracle.spatial.geometry.JGeometry;

public class AnnotationTextFeature
extends AbstractFeature {
    public static int LVL_FEATURE = 0;
    public static int LVL_ELEMENT = 1;
    public static int LVL_COMPONENT = 2;
    public static int LVL_VERTEX = 3;
    public static int COMP_LOCATION = 0;
    public static int COMP_LEADERLINE = 1;
    private int level = LVL_FEATURE;
    private int element = -1;
    private int component = -1;
    private int vertex_offset = -1;

    public AnnotationText getSpatialAttribute() {
        return (AnnotationText)this.spatialAttr;
    }

    @Override
    public void setSpatialAttribute(Object sptAttr) {
        this.spatialAttr = (AnnotationText)sptAttr;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        AnnotationTextFeature other = (AnnotationTextFeature)obj;
        return this.level == other.level && this.element == other.element && this.component == other.component && this.vertex_offset == other.vertex_offset;
    }

    @Override
    public Rectangle2D getMBR() {
        if (this.spatialAttr == null) {
            return null;
        }
        return this.getSpatialAttribute().getMBR();
    }

    @Override
    public int getSpatialDimension() {
        if (this.spatialAttr == null) {
            return -1;
        }
        JGeometry env = this.getSpatialAttribute().getEnvelope();
        if (env == null) {
            return -1;
        }
        return env.getDimensions();
    }

    public AnnotationText getSpatialAttributeClone() {
        return (AnnotationText)this.getSpatialAttribute().clone();
    }

    @Override
    public Point2D[] getSpatialJavaPoints() {
        if (this.spatialAttr == null) {
            return null;
        }
        AnnotationTextElement[] elems = this.getSpatialAttribute().getElements();
        if (elems == null || elems.length == 0) {
            return null;
        }
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (int i = 0; i < elems.length; ++i) {
            JGeometry leaderline;
            Point2D[] llloc;
            JGeometry location = elems[i].getLocation();
            Point2D[] loc = JGeometryUtil.getJavaPoints((JGeometry)location);
            if (loc != null) {
                for (int j = 0; j < loc.length; ++j) {
                    points.add(loc[j]);
                }
            }
            if ((llloc = JGeometryUtil.getJavaPoints((JGeometry)(leaderline = elems[i].getLeaderLine()))) == null) continue;
            for (int j = 0; j < llloc.length; ++j) {
                points.add(llloc[j]);
            }
        }
        Rectangle2D mbr = this.getMBR();
        if (mbr != null) {
            points.add(new Point2D.Double(mbr.getMinX(), mbr.getMinY()));
            points.add(new Point2D.Double(mbr.getMinX(), mbr.getMaxY()));
            points.add(new Point2D.Double(mbr.getMaxX(), mbr.getMinY()));
            points.add(new Point2D.Double(mbr.getMaxX(), mbr.getMaxY()));
        }
        if (points.size() == 0) {
            return null;
        }
        return points.toArray(new Point2D[points.size()]);
    }

    @Override
    public Drawable getDrawable(AffineTransform viewportTransform) {
        if (this.spatialAttr == null) {
            return null;
        }
        if (this.level == LVL_FEATURE) {
            return this.feature2Drawable(viewportTransform);
        }
        if (this.level == LVL_ELEMENT) {
            return this.element2Drawable(this.getSpatialAttribute().getElement(this.element), viewportTransform);
        }
        if (this.level == LVL_COMPONENT) {
            JGeometry geom = null;
            if (this.component == COMP_LOCATION) {
                geom = this.getSpatialAttribute().getElement(this.element).getLocation();
            } else if (this.component == COMP_LEADERLINE) {
                geom = this.getSpatialAttribute().getElement(this.element).getLeaderLine();
            }
            return Drawable.createDrawable(geom, viewportTransform);
        }
        return null;
    }

    @Override
    public boolean isSubElementOf(GeoObject obj) {
        if (!(obj instanceof AnnotationTextFeature)) {
            return false;
        }
        AnnotationTextFeature other = (AnnotationTextFeature)obj;
        if (!this.layer.equals(other.layer) || !this.getKey().equals(other.getKey())) {
            return false;
        }
        if (this.level <= other.level) {
            return false;
        }
        if (this.level == LVL_ELEMENT) {
            return true;
        }
        if (this.element != other.element) {
            return false;
        }
        if (this.level == LVL_COMPONENT) {
            return true;
        }
        return this.component == other.component;
    }

    @Override
    public List<GeoObject> substract(List<? extends GeoObject> obj) {
        throw new UnsupportedOperationException();
    }

    public int getElement() {
        if (this.level >= LVL_ELEMENT) {
            return this.element;
        }
        return -1;
    }

    public int getComponent() {
        if (this.level >= LVL_COMPONENT) {
            return this.component;
        }
        return -1;
    }

    public void setSubElementInfo(int level, int element, int component, int vertex_offset) {
        this.level = level;
        this.element = element;
        this.component = component;
        this.vertex_offset = vertex_offset;
    }

    public AnnotationText createTransformedSpatialAttribute(AffineTransform at) throws Exception {
        AnnotationText result = this.getSpatialAttributeClone();
        if (this.level == LVL_FEATURE) {
            for (AnnotationTextElement elem : result.getElements()) {
                this.transformComponents(elem, -1, at);
            }
        } else if (this.level == LVL_ELEMENT) {
            this.transformComponents(result.getElement(this.element), -1, at);
        } else if (this.level == LVL_COMPONENT) {
            this.transformComponents(result.getElement(this.element), this.component, at);
        }
        return result;
    }

    private Drawable element2Drawable(AnnotationTextElement element, AffineTransform tfm) {
        Drawable dr = Drawable.createDrawable(element.getLocation(), tfm);
        Drawable dr2 = Drawable.createDrawable(element.getLeaderLine(), tfm);
        if (dr != null && dr2 != null) {
            dr.setNext(dr2);
        }
        return dr;
    }

    private Drawable feature2Drawable(AffineTransform tfm) {
        if (this.spatialAttr == null) {
            return null;
        }
        AnnotationTextElement[] annotationTextElement = this.getSpatialAttribute().getElements();
        if (annotationTextElement == null || annotationTextElement.length == 0) {
            return null;
        }
        Drawable head = null;
        Drawable prev = null;
        for (int i = 0; i < annotationTextElement.length; ++i) {
            Drawable dr = this.element2Drawable(annotationTextElement[i], tfm);
            if (dr == null) continue;
            if (prev != null) {
                prev.setNext(dr);
            } else {
                head = dr;
            }
            prev = dr.getLast();
        }
        return head;
    }

    private void transformComponents(AnnotationTextElement elem, int comp, AffineTransform tfm) throws Exception {
        if (comp == COMP_LOCATION || comp == -1) {
            elem.setLocation(JGeometryUtil.transformGeometry((JGeometry)elem.getLocation(), (AffineTransform)tfm, (boolean)true, (boolean)true));
        }
        if (comp == COMP_LEADERLINE || comp == -1) {
            elem.setLeaderLine(JGeometryUtil.transformGeometry((JGeometry)elem.getLeaderLine(), (AffineTransform)tfm));
        }
    }
}

