/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.index.topology;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import oracle.maps.core.GeoObject;
import oracle.maps.geoobject.AbstractFeature;
import oracle.sdovis.edit.util.GeometryUtil;
import oracle.sdovis.edit.util.JGeometryUtil;
import oracle.spatial.edit.index.AbstractIndexedDataSet;
import oracle.spatial.edit.index.RTreeIndex;
import oracle.spatial.edit.model.topology.TopologyFeature;
import oracle.spatial.edit.model.topology.TopologyGeometry;
import oracle.spatial.edit.model.topology.TopologyModel;
import oracle.spatial.edit.model.topology.TopologySet;
import oracle.spatial.geometry.JGeometry;

public class IndexedTopologySet
extends AbstractIndexedDataSet {
    public IndexedTopologySet(TopologySet tset) {
        this.dataSet = tset;
        this.dataSet.setIndexedSet(this);
        RTreeIndex rtree = new RTreeIndex();
        rtree.create(null);
        this.sptIndex = rtree;
    }

    @Override
    public AbstractFeature identify(Point2D point, double tolerance, int granularity) {
        int gtype;
        int k;
        TopologyGeometry tpgeom;
        JGeometry[] geoms;
        TopologyFeature pf;
        int i;
        TopologyFeature tf = null;
        if (this.dataSet == null) {
            return null;
        }
        TopologyModel model = ((TopologySet)this.dataSet).getTopologyModel();
        if (model == null) {
            return null;
        }
        List<GeoObject> feats = this.getFeatures(point, tolerance);
        if (feats == null || feats.size() == 0) {
            return null;
        }
        double minDist = Double.MAX_VALUE;
        block0: for (i = 0; i < feats.size(); ++i) {
            pf = (TopologyFeature)feats.get(i);
            if (pf == null || pf.getSpatialAttribute() == null || (geoms = (tpgeom = pf.getSpatialAttribute()).getGeometries(model)) == null || geoms.length == 0) continue;
            for (k = 0; k < geoms.length; ++k) {
                double dy;
                Point2D pt;
                double dx;
                double distance;
                gtype = geoms[k].getType();
                if (gtype != 1 || !((distance = Math.sqrt((dx = (pt = geoms[k].getJavaPoint()).getX() - point.getX()) * dx + (dy = pt.getY() - point.getY()) * dy)) <= tolerance) || !(distance < minDist)) continue;
                minDist = distance;
                tf = pf;
                continue block0;
            }
        }
        if (tf != null) {
            return tf;
        }
        minDist = Double.MAX_VALUE;
        block2: for (i = 0; i < feats.size(); ++i) {
            pf = (TopologyFeature)feats.get(i);
            if (pf == null || pf.getSpatialAttribute() == null || (geoms = (tpgeom = pf.getSpatialAttribute()).getGeometries(model)) == null || geoms.length == 0) continue;
            for (k = 0; k < geoms.length; ++k) {
                Point2D[][] boundary;
                gtype = geoms[k].getType();
                if (gtype != 2 || (boundary = JGeometryUtil.getBoundaryOfElement((JGeometry)geoms[k], (int)0)) == null) continue;
                Point2D[] bounds = boundary[0];
                for (int m = 0; m < bounds.length - 1; ++m) {
                    Point2D p1 = bounds[m];
                    Point2D p2 = bounds[m + 1];
                    double[] dist = GeometryUtil.distToLine((Point2D)point, (Point2D)p1, (Point2D)p2);
                    if (!(dist[0] <= tolerance) || !(dist[0] < minDist)) continue;
                    minDist = dist[0];
                    tf = pf;
                    break;
                }
                if (tf != null) continue block2;
            }
        }
        if (tf != null) {
            return tf;
        }
        ArrayList<TopologyFeature> candidates = new ArrayList<TopologyFeature>();
        block5: for (int i2 = 0; i2 < feats.size(); ++i2) {
            TopologyGeometry tpgeom2;
            JGeometry[] geoms2;
            TopologyFeature pf2 = (TopologyFeature)feats.get(i2);
            if (pf2 == null || pf2.getSpatialAttribute() == null || (geoms2 = (tpgeom2 = pf2.getSpatialAttribute()).getGeometries(model)) == null || geoms2.length == 0) continue;
            for (int k2 = 0; k2 < geoms2.length; ++k2) {
                Point2D[][] boundary;
                int gtype2 = geoms2[k2].getType();
                if (gtype2 != 3 || (boundary = JGeometryUtil.getBoundaryOfElement((JGeometry)geoms2[k2], (int)0)) == null) continue;
                int extbounds = 0;
                if (geoms2[k2].getElemInfo()[1] == 2003) {
                    extbounds = boundary.length - 1;
                }
                if (!GeometryUtil.pointInPolygon((Point2D)point, (Point2D[])boundary[extbounds])) continue;
                if (boundary.length == 1) {
                    tf = pf2;
                    candidates.add(pf2);
                    continue block5;
                }
                boolean insideVoid = false;
                int startVoids = 1;
                int endVoids = boundary.length - 1;
                if (geoms2[k2].getElemInfo()[1] == 2003) {
                    startVoids = 0;
                    endVoids = boundary.length - 2;
                }
                for (int l = startVoids; l <= endVoids; ++l) {
                    if (!GeometryUtil.pointInPolygon((Point2D)point, (Point2D[])boundary[l])) continue;
                    insideVoid = true;
                    break;
                }
                if (insideVoid) continue;
                tf = pf2;
                candidates.add(pf2);
                continue block5;
            }
        }
        if (candidates.size() == 1) {
            return (TopologyFeature)candidates.get(0);
        }
        return this.faceHitDetection(candidates, point);
    }

    private TopologyFeature faceHitDetection(List candidates, Point2D point) {
        int index = -1;
        double minDist = Double.POSITIVE_INFINITY;
        double px = point.getX();
        double py = point.getY();
        for (int i = 0; i < candidates.size(); ++i) {
            JGeometry[] geoms;
            TopologyGeometry tg;
            TopologyFeature feature = (TopologyFeature)candidates.get(i);
            if (feature == null || (tg = feature.getSpatialAttribute()) == null || (geoms = tg.getGeometries(((TopologySet)this.dataSet).getTopologyModel())) == null) continue;
            double geomSegMinDist = Double.POSITIVE_INFINITY;
            for (int j = 0; j < geoms.length; ++j) {
                int gtype = geoms[j].getType();
                if (gtype != 3) continue;
                JGeometry g = geoms[j];
                double[] coords = g.getOrdinatesArray();
                int dim = g.getDimensions();
                double sx = coords[0];
                double sy = coords[1];
                double ex = 0.0;
                double ey = 0.0;
                for (int k = 1; k < coords.length / dim; ++k) {
                    ex = coords[k * dim];
                    ey = coords[k * dim + 1];
                    double dist = GeometryUtil.distToLine((double)px, (double)py, (double)sx, (double)sy, (double)ex, (double)ey)[0];
                    if (dist < geomSegMinDist) {
                        geomSegMinDist = dist;
                    }
                    sx = ex;
                    sy = ey;
                }
            }
            if (!(geomSegMinDist < minDist)) continue;
            minDist = geomSegMinDist;
            index = i;
        }
        return index >= 0 ? (TopologyFeature)candidates.get(index) : null;
    }
}

