/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.index.topology;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.sdovis.edit.util.GeometryUtil;
import oracle.sdovis.edit.util.JGeometrySegment;
import oracle.sdovis.edit.util.JGeometrySegmentPoint;
import oracle.sdovis.edit.util.JGeometryUtil;
import oracle.spatial.edit.index.AbstractSpatialIndex;
import oracle.spatial.edit.index.RTreeIndex;
import oracle.spatial.edit.model.topology.TopologyModel;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.topo.Edge;
import oracle.spatial.topo.Face;
import oracle.spatial.topo.Node;
import oracle.spatial.topo.Point2DD;

public class IndexedTopologyModel {
    private TopologyModel model = null;
    Hashtable<String, AbstractSpatialIndex> edgeGeomTree = new Hashtable();

    public IndexedTopologyModel(TopologyModel model) {
        this.model = model;
    }

    public TopologyModel getTopologyModel() {
        return this.model;
    }

    public AbstractSpatialIndex buildEdgeSegmentTree(int edgeId) {
        if (this.model == null) {
            return null;
        }
        Edge edge = null;
        try {
            edge = this.model.getEdge(edgeId);
        }
        catch (Exception e) {
            return null;
        }
        if (edge == null) {
            return null;
        }
        this.edgeGeomTree.remove("" + edge.getId());
        JGeometry geom = this.model.getEdgeGeometry(edge.getId());
        if (geom == null) {
            return null;
        }
        RTreeIndex index = new RTreeIndex();
        ((AbstractSpatialIndex)index).create(null);
        if (index == null) {
            return null;
        }
        Vector<double[]> mbrs = new Vector<double[]>();
        Vector<JGeometrySegment> segments = new Vector<JGeometrySegment>();
        double[] mbr = null;
        JGeometrySegment fseg = null;
        int[] elemInfo = geom.getElemInfo();
        int nelems = elemInfo.length / 3;
        int dim = geom.getDimensions();
        double[] oords = geom.getOrdinatesArray();
        int offset = 0;
        int etype = elemInfo[1];
        if (etype == 4) {
            offset = 3;
            --nelems;
        }
        for (int l = 0; l < nelems; ++l) {
            int i;
            int segpos;
            int coordsStart = elemInfo[3 * l + offset];
            int coordsEnd = -1;
            coordsEnd = l < nelems - 1 ? elemInfo[3 * (l + 1) + offset] : oords.length;
            if (elemInfo[3 * l + 2 + offset] == 2) {
                segpos = 0;
                for (i = coordsStart - 1; i < coordsEnd - dim; i += dim * 2) {
                    fseg = new JGeometrySegment();
                    fseg.setElementIndex(0);
                    fseg.setSegmentIndex(segpos++);
                    fseg.setSubElementIndex(l);
                    fseg.setSegmentType(JGeometrySegment.ARC_TYPE);
                    mbr = GeometryUtil.getArcMBR((double)oords[i], (double)oords[i + 1], (double)oords[i + dim], (double)oords[i + dim + 1], (double)oords[i + 2 * dim], (double)oords[i + 2 * dim + 1]);
                    if (mbr == null) continue;
                    mbrs.add(mbr);
                    segments.add(fseg);
                }
                continue;
            }
            segpos = 0;
            for (i = coordsStart - 1; i < coordsEnd - dim; i += dim) {
                mbr = new double[4];
                mbr[0] = Math.min(oords[i], oords[i + dim]);
                mbr[2] = Math.max(oords[i], oords[i + dim]);
                mbr[1] = Math.min(oords[i + 1], oords[i + dim + 1]);
                mbr[3] = Math.max(oords[i + 1], oords[i + dim + 1]);
                fseg = new JGeometrySegment();
                fseg.setElementIndex(0);
                fseg.setSegmentIndex(segpos++);
                fseg.setSubElementIndex(l);
                fseg.setSegmentType(JGeometrySegment.LINE_TYPE);
                mbrs.add(mbr);
                segments.add(fseg);
            }
        }
        double[][][] mbhs = new double[mbrs.size()][2][2];
        Object[] o = new Object[mbrs.size()];
        for (int i = 0; i < mbrs.size(); ++i) {
            double[] segmbr = (double[])mbrs.get(i);
            JGeometrySegment seg = (JGeometrySegment)segments.get(i);
            mbhs[i][0][0] = segmbr[0];
            mbhs[i][0][1] = segmbr[2];
            mbhs[i][1][0] = segmbr[1];
            mbhs[i][1][1] = segmbr[3];
            o[i] = seg;
        }
        try {
            index.getTree().packTree(mbhs, o);
            this.edgeGeomTree.put("" + edge.getId(), index);
        }
        catch (Exception e) {
            index = null;
            System.out.println("Exception in buildEdgeSegmentTree: " + e.getMessage());
            return null;
        }
        return index;
    }

    public JGeometrySegmentPoint getEdgeSegmentPoint(Point2D point, double tolerance) {
        if (this.model == null || point == null) {
            return null;
        }
        Point2D intersectPoint = null;
        Rectangle2D.Double mbr = new Rectangle2D.Double(point.getX() - tolerance, point.getY() - tolerance, tolerance * 2.0, tolerance * 2.0);
        Edge[] edges = this.model.searchEdges(mbr);
        if (edges == null || edges.length == 0) {
            return null;
        }
        double minDist = Double.MAX_VALUE;
        JGeometrySegmentPoint out = null;
        for (int i = 0; i < edges.length; ++i) {
            double dy;
            double dx;
            double dist;
            Point2D inter;
            JGeometrySegmentPoint finter = this.getEdgeSegmentPoint(edges[i].getId(), point, tolerance);
            if (finter == null || (inter = finter.getPoint()) == null || !((dist = Math.sqrt((dx = point.getX() - inter.getX()) * dx + (dy = point.getY() - inter.getY()) * dy)) < minDist)) continue;
            minDist = dist;
            intersectPoint = inter;
            out = finter;
        }
        return out;
    }

    public JGeometrySegmentPoint getEdgeSegmentPoint(int edgeId, Point2D point, double tolerance) {
        Point2D intersectPoint = null;
        JGeometrySegment fseg = null;
        int fsegloc = -1;
        JGeometry geom = this.model.getEdgeGeometry(edgeId);
        if (geom == null) {
            return null;
        }
        AbstractSpatialIndex index = this.edgeGeomTree.get("" + edgeId);
        if (index == null) {
            index = this.buildEdgeSegmentTree(edgeId);
        }
        if (index == null) {
            return null;
        }
        if (!(index instanceof RTreeIndex)) {
            return null;
        }
        int dim = 2;
        double[] oords = null;
        int offset = 0;
        double dx = 0.0;
        double dy = 0.0;
        int[] elemInfo = null;
        try {
            boolean gotSome = false;
            double[][] searchMBR = new double[][]{new double[2], new double[2]};
            searchMBR[0][0] = point.getX() - tolerance;
            searchMBR[0][1] = point.getX() + tolerance;
            searchMBR[1][0] = point.getY() - tolerance;
            searchMBR[1][1] = point.getY() + tolerance;
            double minDist = Double.MAX_VALUE;
            ArrayList a = new ArrayList(500);
            a.clear();
            gotSome = ((RTreeIndex)index).getTree().search((double[][])searchMBR, a);
            if (gotSome) {
                for (int i = 0; i < a.size(); ++i) {
                    Point2D.Double p2;
                    Point2D.Double p1;
                    double[] dist;
                    JGeometrySegment o = (JGeometrySegment)a.get(i);
                    int seg = o.getSegmentIndex();
                    int subelemindex = o.getSubElementIndex();
                    if (o.getSegmentType() != JGeometrySegment.LINE_TYPE) continue;
                    dim = geom.getDimensions();
                    oords = geom.getOrdinatesArray();
                    offset = 0;
                    if (subelemindex > 0) {
                        elemInfo = geom.getElemInfo();
                        offset = elemInfo[3 * subelemindex] - 1;
                    }
                    if ((dist = GeometryUtil.distToLine((Point2D)point, (Point2D)(p1 = new Point2D.Double(oords[dim * seg + offset], oords[dim * seg + 1 + offset])), (Point2D)(p2 = new Point2D.Double(oords[dim * (seg + 1) + offset], oords[dim * (seg + 1) + 1 + offset])))) == null || !(dist[0] <= tolerance) || !(dist[0] < minDist)) continue;
                    minDist = dist[0];
                    fseg = o;
                    fsegloc = (int)dist[1];
                    if ((int)dist[1] == 0) {
                        intersectPoint = p1;
                        continue;
                    }
                    if ((int)dist[1] == 1) {
                        intersectPoint = p2;
                        continue;
                    }
                    intersectPoint = GeometryUtil.getIntersectionPoint((Point2D)point, (Point2D)p1, (Point2D)p2);
                    fsegloc = 2;
                    if (intersectPoint == null) continue;
                    dx = intersectPoint.getX() - ((Point2D)p1).getX();
                    if (Math.sqrt(dx * dx + (dy = intersectPoint.getY() - ((Point2D)p1).getY()) * dy) <= tolerance) {
                        intersectPoint = p1;
                        fsegloc = 0;
                        continue;
                    }
                    dx = intersectPoint.getX() - ((Point2D)p2).getX();
                    if (!(Math.sqrt(dx * dx + (dy = intersectPoint.getY() - ((Point2D)p2).getY()) * dy) <= tolerance)) continue;
                    intersectPoint = p2;
                    fsegloc = 1;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception in getEdgeSegmentPoint: " + e.getMessage());
            intersectPoint = null;
        }
        if (intersectPoint == null) {
            return null;
        }
        return new JGeometrySegmentPoint(intersectPoint, fseg, fsegloc, "" + edgeId);
    }

    public Node[] getNodes(Rectangle2D mbr) {
        if (mbr == null || this.model == null) {
            return null;
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        Edge[] edges = this.model.searchEdges(mbr);
        if (edges != null) {
            for (int i = 0; i < edges.length; ++i) {
                Point2DD pt;
                int nodeId = edges[i].getOriginNode();
                Node nd = null;
                nd = this.model.getNode(nodeId);
                if (nd != null && mbr.contains((pt = nd.getCoord()).getX(), pt.getY()) && !nodes.contains(nd)) {
                    nodes.add(nd);
                }
                if ((nd = this.model.getNode(nodeId = edges[i].getEndNode())) == null || !mbr.contains((pt = nd.getCoord()).getX(), pt.getY()) || nodes.contains(nd)) continue;
                nodes.add(nd);
            }
        }
        if (nodes.size() == 0) {
            return null;
        }
        return nodes.toArray(new Node[nodes.size()]);
    }

    public Node identifyNode(Point2D point, double tolerance) {
        int[] islandNodes;
        if (this.model == null) {
            return null;
        }
        Rectangle2D.Double mbr = new Rectangle2D.Double(point.getX() - tolerance, point.getY() - tolerance, tolerance * 2.0, tolerance * 2.0);
        Edge[] edges = this.model.searchEdges(mbr);
        Node outNode = null;
        double minDist = Double.MAX_VALUE;
        if (edges != null) {
            for (int i = 0; i < edges.length; ++i) {
                double dy;
                Point2DD pt;
                double dx;
                double distance;
                int nodeId = edges[i].getOriginNode();
                Node nd = null;
                nd = this.model.getNode(nodeId);
                if (nd != null && (distance = Math.sqrt((dx = (pt = nd.getCoord()).getX() - point.getX()) * dx + (dy = pt.getY() - point.getY()) * dy)) <= tolerance && distance < minDist) {
                    minDist = distance;
                    outNode = nd;
                }
                if ((nd = this.model.getNode(nodeId = edges[i].getEndNode())) == null || !((distance = Math.sqrt((dx = (pt = nd.getCoord()).getX() - point.getX()) * dx + (dy = pt.getY() - point.getY()) * dy)) <= tolerance) || !(distance < minDist)) continue;
                minDist = distance;
                outNode = nd;
            }
        }
        if (outNode != null) {
            return outNode;
        }
        Face uf = this.model.getFace(-1);
        if (uf != null && (islandNodes = uf.getIslandNodes()) != null) {
            for (int j = 0; j < islandNodes.length; ++j) {
                double dy;
                Point2DD pt;
                double dx;
                double distance;
                Node nd = this.model.getNode(islandNodes[j]);
                if (nd == null || !((distance = Math.sqrt((dx = (pt = nd.getCoord()).getX() - point.getX()) * dx + (dy = pt.getY() - point.getY()) * dy)) <= tolerance) || !(distance < minDist)) continue;
                minDist = distance;
                outNode = nd;
            }
        }
        if (outNode != null) {
            return outNode;
        }
        Face[] faces = this.model.searchFaces(mbr);
        if (faces == null || faces.length == 0) {
            return null;
        }
        for (int i = 0; i < faces.length; ++i) {
            int[] islandNodes2 = faces[i].getIslandNodes();
            if (islandNodes2 == null) continue;
            for (int j = 0; j < islandNodes2.length; ++j) {
                double dy;
                Point2DD pt;
                double dx;
                double distance;
                Node nd = this.model.getNode(islandNodes2[j]);
                if (nd == null || !((distance = Math.sqrt((dx = (pt = nd.getCoord()).getX() - point.getX()) * dx + (dy = pt.getY() - point.getY()) * dy)) <= tolerance) || !(distance < minDist)) continue;
                minDist = distance;
                outNode = nd;
            }
        }
        return outNode;
    }

    public Edge[] getEdges(Rectangle2D mbr) {
        if (mbr == null || this.model == null) {
            return null;
        }
        return this.model.searchEdges(mbr);
    }

    public Edge identifyEdge(Point2D point, double tolerance) {
        if (this.model == null) {
            return null;
        }
        Rectangle2D.Double mbr = new Rectangle2D.Double(point.getX() - tolerance, point.getY() - tolerance, tolerance * 2.0, tolerance * 2.0);
        Edge[] edges = this.model.searchEdges(mbr);
        if (edges == null || edges.length == 0) {
            return null;
        }
        Edge outEdge = null;
        double minDist = Double.MAX_VALUE;
        block0: for (int i = 0; i < edges.length; ++i) {
            JGeometry geom = this.model.getEdgeGeometry(edges[i].getId());
            Point2D[][] boundary = JGeometryUtil.getBoundaryOfElement((JGeometry)geom, (int)0);
            if (boundary == null) continue;
            Point2D[] bounds = boundary[0];
            for (int m = 0; m < bounds.length - 1; ++m) {
                Point2D p1 = bounds[m];
                Point2D p2 = bounds[m + 1];
                double[] dist = GeometryUtil.distToLine((Point2D)point, (Point2D)p1, (Point2D)p2);
                if (!(dist[0] <= tolerance) || !(dist[0] < minDist)) continue;
                minDist = dist[0];
                outEdge = edges[i];
                continue block0;
            }
        }
        return outEdge;
    }

    public Face[] getFaces(Rectangle2D mbr) {
        if (mbr == null || this.model == null) {
            return null;
        }
        return this.model.searchFaces(mbr);
    }

    public Face identifyFace(Point2D point, double tolerance) {
        if (this.model == null) {
            return null;
        }
        Rectangle2D.Double mbr = new Rectangle2D.Double(point.getX() - tolerance, point.getY() - tolerance, tolerance * 2.0, tolerance * 2.0);
        Face[] faces = this.model.searchFaces(mbr);
        if (faces == null || faces.length == 0) {
            return null;
        }
        ArrayList<Face> candidates = new ArrayList<Face>();
        for (int i = 0; i < faces.length; ++i) {
            int extbounds;
            Point2D[][] boundary;
            JGeometry geom = this.model.getFaceGeometry(faces[i].getID());
            if (geom == null || (boundary = JGeometryUtil.getBoundaryOfElement((JGeometry)geom, (int)0)) == null || !GeometryUtil.pointInPolygon((Point2D)point, (Point2D[])boundary[extbounds = 0])) continue;
            candidates.add(faces[i]);
        }
        if (candidates.size() == 1) {
            return (Face)candidates.get(0);
        }
        return this.faceHitDetection(candidates, point);
    }

    public void removeEdgeSegmentTree(int edge) {
        this.edgeGeomTree.remove("" + edge);
    }

    private Face faceHitDetection(List candidates, Point2D point) {
        int index = -1;
        double minDist = Double.POSITIVE_INFINITY;
        double px = point.getX();
        double py = point.getY();
        for (int i = 0; i < candidates.size(); ++i) {
            Face face = (Face)candidates.get(i);
            if (face == null) continue;
            JGeometry geom = this.model.getFaceGeometry(face.getID());
            double geomSegMinDist = Double.POSITIVE_INFINITY;
            double[] coords = geom.getOrdinatesArray();
            int dim = geom.getDimensions();
            double sx = coords[0];
            double sy = coords[1];
            double ex = 0.0;
            double ey = 0.0;
            for (int k = 1; k < coords.length / dim; ++k) {
                ex = coords[k * dim];
                ey = coords[k * dim + 1];
                double dist = GeometryUtil.distToLine((double)px, (double)py, (double)sx, (double)sy, (double)ex, (double)ey)[0];
                if (dist < geomSegMinDist) {
                    geomSegMinDist = dist;
                }
                sx = ex;
                sy = ey;
            }
            if (!(geomSegMinDist < minDist)) continue;
            minDist = geomSegMinDist;
            index = i;
        }
        return index >= 0 ? (Face)candidates.get(index) : null;
    }
}

