/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class XYPanel
extends JPanel {
    private JLabel xLabel = new JLabel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JTextField xTxt = new JTextField();
    private JTextField yTxt = new JTextField();
    private JLabel yLabel = new JLabel();
    private JLabel jLabelFiller = new JLabel();
    private JLabel jLabelFillerX = new JLabel();

    public XYPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.setSize(new Dimension(210, 51));
        this.xLabel.setText(MessagesBundle.getMessage("Label_x"));
        this.yLabel.setText(MessagesBundle.getMessage("Label_y"));
        this.add((Component)this.xTxt, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 0, 0), 50, 0));
        this.add((Component)this.xLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.yTxt, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 0, 0), 50, 0));
        this.add((Component)this.yLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.jLabelFiller, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jLabelFillerX, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setSize2D(double x, double y) {
        this.setXValue(x);
        this.setYValue(y);
    }

    public void setXValue(double x) {
        NumberFormat nf = NumberFormat.getInstance();
        this.xTxt.setText(nf.format(x));
    }

    public double getXValue() {
        NumberFormat nf = NumberFormat.getInstance();
        try {
            return nf.parse(this.xTxt.getText()).doubleValue();
        }
        catch (Exception e) {
            return 12.0;
        }
    }

    public boolean isXNumberValid() {
        NumberFormat nf = NumberFormat.getInstance();
        try {
            nf.parse(this.xTxt.getText()).doubleValue();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setYValue(double y) {
        NumberFormat nf = NumberFormat.getInstance();
        this.yTxt.setText(nf.format(y));
    }

    public double getYValue() {
        NumberFormat nf = NumberFormat.getInstance();
        try {
            return nf.parse(this.yTxt.getText()).doubleValue();
        }
        catch (Exception e) {
            return 12.0;
        }
    }

    public boolean isYNumberValid() {
        NumberFormat nf = NumberFormat.getInstance();
        try {
            nf.parse(this.yTxt.getText()).doubleValue();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void disableItems() {
        this.xTxt.setEnabled(false);
        this.yTxt.setEnabled(false);
    }

    public void enableItems() {
        this.xTxt.setEnabled(true);
        this.yTxt.setEnabled(true);
    }

    public void setLabels(String labelX, String labelY) {
        this.xLabel.setText(labelX);
        this.yLabel.setText(labelY);
    }

    public void setBorderTitle(String title) {
        if (title != null) {
            this.setBorder(BorderFactory.createTitledBorder(title));
        } else {
            this.setBorder(null);
        }
    }

    public void setXFieldTooltip(String tooltip) {
        if (tooltip == null) {
            this.xTxt.setToolTipText("");
        } else {
            this.xTxt.setToolTipText(tooltip);
        }
    }

    public void setYFieldTooltip(String tooltip) {
        if (tooltip == null) {
            this.yTxt.setToolTipText("");
        } else {
            this.yTxt.setToolTipText(tooltip);
        }
    }
}

