/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.mdeditor.ui.GeometryRenderPanel;
import oracle.mdeditor.ui.GeometryViewPanel;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.JSDOGeometry;
import oracle.sdovis.SRS;
import oracle.sdovis.StyledFeatureI;
import oracle.sdovis.Theme;
import oracle.sdovis.edit.util.GeometryUtil;
import oracle.spatial.edit.util.SelectionBoxListener;
import oracle.spatial.edit.util.SimplifyGeometrySet;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.topo.Edge;
import oracle.spatial.topo.Point2DD;

public class SimplifyPreviewPanel
extends JPanel {
    private JLabel simpliLabel = new JLabel(MessagesBundle.getMessage("Label_algorithm"));
    private JRadioButton dpRbutton = new JRadioButton(MessagesBundle.getMessage("Douglas_peucker"));
    private JRadioButton vwRbutton = new JRadioButton(MessagesBundle.getMessage("Visvalingham_whyatt"));
    private ButtonGroup simpliGroup = new ButtonGroup();
    private GeometryRenderPanel themeRenderPanel = new GeometryRenderPanel();
    private GeometryViewPanel themeView = this.themeRenderPanel.getGeometryViewPanel();
    private JPanel dpPanel = new JPanel();
    private JLabel thresholdLabel = new JLabel();
    private JTextField thresholdTxt = new JTextField();
    private JLabel ratioLabel = new JLabel();
    private JTextField ratioTxt = new JTextField();
    private JButton previewButton = new JButton();
    private JButton resetButton = new JButton();
    private JPanel vwPanel = new JPanel();
    private JLabel percentLabel = new JLabel();
    private JSlider percentSlider = new JSlider();
    JCheckBox tallertriBox = new JCheckBox();
    private JLabel ratiowvLabel = new JLabel();
    private JTextField ratiowvTxt = new JTextField();
    private JButton previewButton1 = new JButton();
    private SimplifyGeometrySet topoSimplifySet = null;
    private Hashtable<String, Edge> selEdges = new Hashtable();
    private JLabel applyToLabel = new JLabel();
    private JComboBox applyCombo = new JComboBox();
    private JButton clearSelectionButton = new JButton();
    private JGeometry[] simplifiedGeoms = null;
    private SRS srs = null;

    private Point2D[] getEdgeCoords(Edge e) {
        if (e == null || e.getCoords() == null) {
            return null;
        }
        Point2DD[] ecoords = e.getCoords();
        Point2D[] pts = new Point2D[ecoords.length];
        for (int i = 0; i < ecoords.length; ++i) {
            pts[i] = new Point2D.Double(ecoords[i].getX(), ecoords[i].getY());
        }
        return pts;
    }

    public SimplifyPreviewPanel(SRS srs) {
        this.srs = srs;
        this.themeView.setBoxSelectionListener(new BoxSelection());
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(521, 386));
        this.thresholdTxt.setText("0");
        this.ratioTxt.setText("100");
        this.ratiowvTxt.setText("100");
        this.simpliGroup.add(this.dpRbutton);
        this.simpliGroup.add(this.vwRbutton);
        this.dpRbutton.setSelected(true);
        this.dpRbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimplifyPreviewPanel.this.dpRbutton_actionPerformed(e);
            }
        });
        this.vwRbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimplifyPreviewPanel.this.vwRbutton_actionPerformed(e);
            }
        });
        this.createDPpanel();
        this.createVWpanel();
        this.applyToLabel.setText(MessagesBundle.getMessage("Label_apply_to"));
        this.applyCombo.addItem(MessagesBundle.getMessage("All_geometries"));
        this.applyCombo.addItem(MessagesBundle.getMessage("Selected_geometries"));
        this.applyCombo.addItem(MessagesBundle.getMessage("Unselected_geometries"));
        this.clearSelectionButton.setText(MessagesBundle.getMessage("Clear_selected_geometries"));
        this.clearSelectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimplifyPreviewPanel.this.clearSelectionButton_actionPerformed(e);
            }
        });
        this.add((Component)this.simpliLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.dpRbutton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this.vwRbutton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this.applyToLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.applyCombo, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this.clearSelectionButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this.dpPanel, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this.themeRenderPanel, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 17, 1, new Insets(5, 10, 10, 10), 0, 0));
    }

    private void createDPpanel() {
        this.dpPanel.setLayout(new GridBagLayout());
        this.dpPanel.setSize(new Dimension(240, 240));
        this.dpPanel.setBorder(BorderFactory.createEtchedBorder());
        this.thresholdLabel.setText(MessagesBundle.getMessage("Label_threshold"));
        this.previewButton.setText(MessagesBundle.getMessage("Simplify"));
        this.ratioLabel.setText(MessagesBundle.getMessage("Points_percentage"));
        this.ratioTxt.setToolTipText(MessagesBundle.getMessage("Tooltip_simplified_points"));
        this.ratioTxt.setEditable(false);
        this.previewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimplifyPreviewPanel.this.previewButton_actionPerformed(e);
            }
        });
        this.resetButton.setText(MessagesBundle.getMessage("Reset"));
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimplifyPreviewPanel.this.resetButton_actionPerformed(e);
            }
        });
        this.dpPanel.add((Component)this.thresholdLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.dpPanel.add((Component)this.thresholdTxt, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 2, 0, 0), 0, 0));
        this.dpPanel.add((Component)this.previewButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 10), 0, 0));
        this.dpPanel.add((Component)this.ratioLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 0), 0, 0));
        this.dpPanel.add((Component)this.ratioTxt, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 2, 10, 0), 0, 0));
        this.dpPanel.add((Component)this.resetButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 10, 10), 0, 0));
    }

    public void setTopologySet(SimplifyGeometrySet topoSet) {
        this.topoSimplifySet = topoSet;
        if (topoSet == null || topoSet.getTopologyEdgeGeometries() == null || topoSet.getTopologyEdgeGeometries().size() == 0) {
            this.themeRenderPanel.enableSelectionButton(false);
            this.applyCombo.setEnabled(false);
            this.clearSelectionButton.setEnabled(false);
        } else {
            this.themeRenderPanel.enableSelectionButton(true);
            this.applyCombo.setEnabled(true);
            this.clearSelectionButton.setEnabled(true);
        }
    }

    private void createVWpanel() {
        this.vwPanel.setLayout(new GridBagLayout());
        this.vwPanel.setSize(new Dimension(240, 240));
        this.vwPanel.setBorder(BorderFactory.createEtchedBorder());
        this.ratiowvLabel.setText(MessagesBundle.getMessage("Points_percentage"));
        this.ratiowvTxt.setToolTipText(MessagesBundle.getMessage("Tooltip_simplified_points"));
        this.ratiowvTxt.setEditable(false);
        this.percentLabel.setText(MessagesBundle.getMessage("Label_percentage_ofpoints_remove"));
        this.percentSlider.setMinorTickSpacing(5);
        this.percentSlider.setMajorTickSpacing(10);
        this.percentSlider.setPaintTicks(true);
        this.percentSlider.setSnapToTicks(true);
        this.percentSlider.setPaintTrack(true);
        this.percentSlider.setPaintLabels(true);
        this.percentSlider.setValue(0);
        this.percentSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!SimplifyPreviewPanel.this.percentSlider.getValueIsAdjusting()) {
                    // empty if block
                }
            }
        });
        this.previewButton1.setText(MessagesBundle.getMessage("Simplify"));
        this.previewButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimplifyPreviewPanel.this.previewButton_actionPerformed(e);
            }
        });
        this.tallertriBox.setText(MessagesBundle.getMessage("Taller_triangles"));
        this.tallertriBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.vwPanel.add((Component)this.percentLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.vwPanel.add((Component)this.percentSlider, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 2, 0, 100), 0, 0));
        this.vwPanel.add((Component)this.previewButton1, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 2, 10, 10), 0, 0));
        this.vwPanel.add((Component)this.tallertriBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 10, 0), 0, 0));
        this.vwPanel.add((Component)this.ratiowvLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 10, 0), 0, 0));
        this.vwPanel.add((Component)this.ratiowvTxt, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 2, 10, 10), 0, 0));
    }

    public void setGeometries(String dataSource, JGeometry[] geoms) {
        double minX = Double.NaN;
        double minY = Double.NaN;
        double maxX = Double.NaN;
        double maxY = Double.NaN;
        double centerX = Double.NaN;
        double centerY = Double.NaN;
        double size = Double.NaN;
        if (dataSource == null || geoms == null || geoms.length == 0) {
            return;
        }
        try {
            boolean srid = false;
            JSDOGeometry[] featGeoms = new JSDOGeometry[geoms.length];
            for (int i = 0; i < geoms.length; ++i) {
                if (geoms[i] == null) continue;
                featGeoms[i] = JSDOGeometry.recast((JGeometry)geoms[i]);
                double[] mbr = geoms[i].getMBR();
                if (mbr == null) continue;
                int dim = geoms[i].getDimensions();
                if (i == 0) {
                    minX = mbr[0];
                    minY = mbr[1];
                    maxX = mbr[dim];
                    maxY = mbr[dim + 1];
                    continue;
                }
                minX = Math.min(minX, mbr[0]);
                minY = Math.min(minY, mbr[1]);
                maxX = Math.max(maxX, mbr[dim]);
                maxY = Math.max(maxY, mbr[dim + 1]);
            }
            if (!(Double.isNaN(minX) || Double.isNaN(minY) || Double.isNaN(maxX) || Double.isNaN(maxY))) {
                centerX = minX + (maxX - minX) / 2.0;
                centerY = minY + (maxY - minY) / 2.0;
                size = maxY - minY;
                if (size < maxX - minX) {
                    size = maxX - minX;
                }
                if (size <= 0.0) {
                    size = 0.25 * centerY;
                }
            }
            this.themeView.setBaseGeometries(featGeoms);
            this.themeView.setHighliteGeometries(null);
            this.themeView.setSelectionGeometries(null);
            this.themeView.renderData(centerX, centerY, size);
            boolean isGeodetic = false;
            if (this.srs != null) {
                isGeodetic = this.srs.isGeodetic();
            }
            if (isGeodetic) {
                this.setThresholdTooltip("in meters");
            } else {
                this.setThresholdTooltip("in data units");
            }
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex.getMessage());
            this.themeView.setBaseGeometries(null);
            this.themeView.setHighliteGeometries(null);
            this.themeView.setSelectionGeometries(null);
        }
    }

    private void previewButton_actionPerformed(ActionEvent e) {
        StyledFeatureI[] feats;
        Theme th = this.themeView.getBaseTheme();
        if (th == null) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getMessage("No_geometries_to_simplify"), MessagesBundle.getMessage("Warning"), 2);
            return;
        }
        double threshold = 0.0;
        this.simplifiedGeoms = null;
        if (this.dpRbutton.isSelected()) {
            NumberFormat nf = NumberFormat.getInstance();
            try {
                threshold = nf.parse(this.thresholdTxt.getText()).doubleValue();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, MessagesBundle.getMessage("Invalid_threshold_value"), MessagesBundle.getMessage("Warning"), 2);
                return;
            }
            if (threshold <= 0.0) {
                this.themeView.setHighliteGeometries(null);
                this.themeView.renderData();
                this.thresholdTxt.setText("0");
                this.ratioTxt.setText("100");
                return;
            }
        } else {
            threshold = this.percentSlider.getValue();
            if (threshold == 0.0) {
                this.themeView.setHighliteGeometries(null);
                this.themeView.renderData();
                this.ratiowvTxt.setText("100");
                return;
            }
        }
        if ((feats = th.getStyledFeatures()) == null || feats.length == 0) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getMessage("No_geometries_to_simplify"), MessagesBundle.getMessage("Warning"), 2);
            return;
        }
        boolean isGeodetic = false;
        if (this.srs != null) {
            isGeodetic = this.srs.isGeodetic();
        }
        double M = 1.0;
        double N = 0.0;
        double KS = 1.0;
        double KH = 1.0;
        double SM = 1.0;
        double SK = 1.0;
        double origPoints = 0.0;
        double simpliPoints = 0.0;
        JSDOGeometry[] highliteGeoms = new JSDOGeometry[feats.length];
        this.simplifiedGeoms = new JGeometry[feats.length];
        Hashtable<Integer, Integer> selEdgeIndexes = new Hashtable<Integer, Integer>();
        if (this.applyCombo.getSelectedIndex() != 0 && this.selEdges.size() > 0) {
            Enumeration<Edge> el = this.selEdges.elements();
            while (el.hasMoreElements()) {
                Edge edge = el.nextElement();
                int index = this.topoSimplifySet.getEdgeIndex(edge.getId());
                selEdgeIndexes.put(new Integer(index), new Integer(index));
            }
        }
        if (this.getParent() != null) {
            this.getParent().setCursor(new Cursor(3));
        }
        System.out.println("Starting simplification of [" + feats.length + "] geometries...");
        for (int i = 0; i < feats.length; ++i) {
            JGeometry simpgeom;
            double yend;
            double xend;
            double yini;
            double xini;
            block30: {
                double[] joords;
                highliteGeoms[i] = null;
                this.simplifiedGeoms[i] = null;
                JSDOGeometry jsdogeom = feats[i].getGeometry();
                if (jsdogeom == null || (joords = jsdogeom.getOrdinatesArray()) == null) continue;
                if (this.applyCombo.getSelectedIndex() == 1) {
                    if (selEdgeIndexes.get(i) == null) {
                        origPoints += (double)(feats[i].getGeometry().getOrdinatesArray().length / feats[i].getGeometry().getDimensions());
                        simpliPoints += (double)(feats[i].getGeometry().getOrdinatesArray().length / feats[i].getGeometry().getDimensions());
                        continue;
                    }
                } else if (this.applyCombo.getSelectedIndex() == 2 && selEdgeIndexes.get(i) != null) {
                    origPoints += (double)(feats[i].getGeometry().getOrdinatesArray().length / feats[i].getGeometry().getDimensions());
                    simpliPoints += (double)(feats[i].getGeometry().getOrdinatesArray().length / feats[i].getGeometry().getDimensions());
                    continue;
                }
                int dim = jsdogeom.getDimensions();
                xini = joords[0];
                yini = joords[1];
                xend = joords[joords.length - dim];
                yend = joords[joords.length - dim + 1];
                simpgeom = null;
                if (this.dpRbutton.isSelected()) {
                    try {
                        simpgeom = isGeodetic ? jsdogeom.simplify(threshold, this.srs.getSpheroid().getSemiMajorAxis(), 1.0 / this.srs.getSpheroid().getFlattening()) : jsdogeom.simplify(threshold);
                        break block30;
                    }
                    catch (Exception ex) {
                        System.out.println("Exception during simplification of geometry [" + (i + 1) + "]. " + ex.getMessage());
                        int pts = feats[i].getGeometry().getOrdinatesArray().length / feats[i].getGeometry().getDimensions();
                        origPoints += (double)pts;
                        simpliPoints += (double)pts;
                        continue;
                    }
                }
                try {
                    simpgeom = isGeodetic ? JGeometry.simplifyVW((JGeometry)jsdogeom, (double)threshold, (boolean)this.tallertriBox.isSelected(), (double)M, (double)N, (double)KS, (double)KH, (double)SM, (double)SK, (double)this.srs.getSpheroid().getSemiMajorAxis(), (double)(1.0 / this.srs.getSpheroid().getFlattening())) : JGeometry.simplifyVW((JGeometry)jsdogeom, (double)threshold, (boolean)this.tallertriBox.isSelected(), (double)M, (double)N, (double)KS, (double)KH, (double)SM, (double)SK);
                }
                catch (Exception ex) {
                    System.out.println("Exception during simplification of geometry [" + (i + 1) + "]. " + ex.getMessage());
                    int pts = feats[i].getGeometry().getOrdinatesArray().length / feats[i].getGeometry().getDimensions();
                    origPoints += (double)pts;
                    simpliPoints += (double)pts;
                    continue;
                }
            }
            if (simpgeom == null || simpgeom.getOrdinatesArray() == null) {
                System.out.println("Simplification of geometry [" + (i + 1) + "] generated a null geometry or a null array of points. Ignored.");
                int pts = feats[i].getGeometry().getOrdinatesArray().length / feats[i].getGeometry().getDimensions();
                origPoints += (double)pts;
                simpliPoints += (double)pts;
                continue;
            }
            if (simpgeom.getType() == 1) {
                System.out.println(MessagesBundle.getFormattedMessage("Simplification_generate_point", "" + (i + 1)));
                int pts = feats[i].getGeometry().getOrdinatesArray().length / feats[i].getGeometry().getDimensions();
                origPoints += (double)pts;
                simpliPoints += (double)pts;
                continue;
            }
            if (simpgeom.getType() == 2 && simpgeom.getOrdinatesArray().length / simpgeom.getDimensions() == 1) {
                System.out.println("Simplification of geometry [" + (i + 1) + "] generated a line with just one point. Ignored.");
                int pts = feats[i].getGeometry().getOrdinatesArray().length / feats[i].getGeometry().getDimensions();
                origPoints += (double)pts;
                simpliPoints += (double)pts;
                continue;
            }
            if (simpgeom == null) continue;
            double[] oords = simpgeom.getOrdinatesArray();
            oords[0] = xini;
            oords[1] = yini;
            oords[oords.length - dim] = xend;
            oords[oords.length - dim + 1] = yend;
            double[] cleanOords = oords;
            this.simplifiedGeoms[i] = simpgeom = new JGeometry(simpgeom.getType() + simpgeom.getDimensions() * 1000, simpgeom.getSRID(), simpgeom.getElemInfo(), cleanOords);
            highliteGeoms[i] = JSDOGeometry.recast((JGeometry)simpgeom);
            int featPoints = feats[i].getGeometry().getOrdinatesArray().length / feats[i].getGeometry().getDimensions();
            int featSimpliPoints = simpgeom.getOrdinatesArray().length / simpgeom.getDimensions();
            origPoints += (double)featPoints;
            simpliPoints += (double)featSimpliPoints;
            if ((i + 1) % 300 != 0) continue;
            System.out.println("Geometry [" + (i + 1) + "]: # orig_points= " + featPoints + " # simplified_points= " + featSimpliPoints);
        }
        System.out.println("End of simplification: # orig_points= " + origPoints + " # simplified_points= " + simpliPoints);
        this.themeView.setHighliteGeometries(highliteGeoms);
        double[] mbr = th.getDataMBR();
        double centerX = mbr[0] + (mbr[2] - mbr[0]) / 2.0;
        double centerY = mbr[1] + (mbr[3] - mbr[1]) / 2.0;
        double size = mbr[3] - mbr[1];
        if (size < mbr[2] - mbr[0]) {
            size = mbr[2] - mbr[0];
        }
        if (size <= 0.0) {
            size = 0.25 * centerY;
        }
        this.themeView.renderData(centerX, centerY, size);
        int ratio = (int)(simpliPoints / origPoints * 100.0 + 0.5);
        if (this.dpRbutton.isSelected()) {
            this.ratioTxt.setText("" + ratio);
        } else {
            this.ratiowvTxt.setText("" + ratio);
        }
        if (this.getParent() != null) {
            this.getParent().setCursor(Cursor.getDefaultCursor());
        }
    }

    public void renderData() {
        this.themeView.renderData();
    }

    public void setThresholdTooltip(String tooltip) {
        if (tooltip == null) {
            this.thresholdTxt.setToolTipText("");
        } else {
            this.thresholdTxt.setToolTipText(tooltip);
        }
    }

    public JGeometry[] getSimplifiedGeometries() {
        return this.simplifiedGeoms;
    }

    private void resetButton_actionPerformed(ActionEvent e) {
        this.thresholdTxt.setText("0");
        this.previewButton_actionPerformed(null);
    }

    private void dpRbutton_actionPerformed(ActionEvent e) {
        this.vwPanel.setVisible(false);
        this.remove(this.vwPanel);
        this.add((Component)this.dpPanel, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.dpPanel.setVisible(true);
        this.resetButton_actionPerformed(null);
    }

    private void vwRbutton_actionPerformed(ActionEvent e) {
        this.dpPanel.setVisible(false);
        this.remove(this.dpPanel);
        this.add((Component)this.vwPanel, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.vwPanel.setVisible(true);
        this.percentSlider.setValue(0);
        this.previewButton_actionPerformed(null);
    }

    private void clearSelectionButton_actionPerformed(ActionEvent e) {
        this.selEdges.clear();
        this.themeView.setSelectionGeometries(null);
        this.themeView.refresh();
    }

    private class BoxSelection
    implements SelectionBoxListener {
        @Override
        public void processBox(Rectangle2D box, boolean isShiftDown) {
            Edge e;
            if (box == null || SimplifyPreviewPanel.this.topoSimplifySet == null || SimplifyPreviewPanel.this.topoSimplifySet.getTopologyEdgeGeometries() == null || SimplifyPreviewPanel.this.topoSimplifySet.getTopologyEdgeGeometries().size() == 0) {
                return;
            }
            double[][] mbr = new double[2][2];
            mbr[0][0] = box.getMinX();
            mbr[0][1] = box.getMaxX();
            mbr[1][0] = box.getMinY();
            mbr[1][1] = box.getMaxY();
            ArrayList a = new ArrayList();
            SimplifyPreviewPanel.this.topoSimplifySet.getTopology().searchEdgeRTree(mbr, a);
            if (a != null && a.size() > 0) {
                String eid;
                int i;
                Point2D[] pts = new Point2D[]{new Point2D.Double(box.getMinX(), box.getMinY()), new Point2D.Double(box.getMinX(), box.getMaxY()), new Point2D.Double(box.getMaxX(), box.getMaxY()), new Point2D.Double(box.getMaxX(), box.getMinY()), new Point2D.Double(box.getMinX(), box.getMinY())};
                if (isShiftDown) {
                    for (i = 0; i < a.size(); ++i) {
                        e = (Edge)a.get(i);
                        eid = "" + e.getId();
                        if (!GeometryUtil.lineStringsIntersect((Point2D[])pts, (Point2D[])SimplifyPreviewPanel.this.getEdgeCoords(e), (boolean)true)) continue;
                        if (SimplifyPreviewPanel.this.selEdges.get(eid) != null) {
                            SimplifyPreviewPanel.this.selEdges.remove(eid);
                            continue;
                        }
                        SimplifyPreviewPanel.this.selEdges.put(eid, e);
                    }
                } else {
                    SimplifyPreviewPanel.this.selEdges.clear();
                    for (i = 0; i < a.size(); ++i) {
                        e = (Edge)a.get(i);
                        eid = "" + e.getId();
                        if (!GeometryUtil.lineStringsIntersect((Point2D[])pts, (Point2D[])SimplifyPreviewPanel.this.getEdgeCoords(e), (boolean)true)) continue;
                        SimplifyPreviewPanel.this.selEdges.put(eid, e);
                    }
                }
            } else if (!isShiftDown) {
                SimplifyPreviewPanel.this.selEdges.clear();
            }
            if (SimplifyPreviewPanel.this.selEdges.size() == 0) {
                SimplifyPreviewPanel.this.themeView.setSelectionGeometries(null);
            } else {
                ArrayList<JSDOGeometry> jsdoGeoms = new ArrayList<JSDOGeometry>();
                Enumeration el = SimplifyPreviewPanel.this.selEdges.elements();
                while (el.hasMoreElements()) {
                    e = (Edge)el.nextElement();
                    JGeometry geom = SimplifyPreviewPanel.this.topoSimplifySet.getTopologyEdgeGeometry(e.getId());
                    if (geom == null) continue;
                    jsdoGeoms.add(JSDOGeometry.recast((JGeometry)geom));
                }
                if (jsdoGeoms.size() > 0) {
                    SimplifyPreviewPanel.this.themeView.setSelectionGeometries(jsdoGeoms.toArray(new JSDOGeometry[jsdoGeoms.size()]));
                } else {
                    SimplifyPreviewPanel.this.themeView.setSelectionGeometries(null);
                }
            }
            SimplifyPreviewPanel.this.themeView.refresh();
        }
    }
}

