/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.mdeditor.EditorObjectProvider;

public class ProviderTreePanel
extends JPanel {
    protected Hashtable<TreeNode, EditorObjectProvider> nodeProviders = new Hashtable();
    protected JTree sessionTree = null;
    protected TreePath[] selections = null;
    protected static final Object PROVIDERROOTNODE = "oracle.mdeditor.ui.ProdiverTreePanel.PROVIDERROOTNODE";

    public ProviderTreePanel(int selectionMode) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        this.sessionTree = new JTree(root);
        this.sessionTree.setEditable(false);
        this.sessionTree.setToggleClickCount(1);
        this.sessionTree.setCellRenderer(new MyTreeCellRenderer());
        this.sessionTree.getSelectionModel().setSelectionMode(selectionMode);
        MouseAdapterProxy ma = new MouseAdapterProxy();
        this.sessionTree.addMouseListener(ma);
        this.sessionTree.addMouseMotionListener(ma);
        this.sessionTree.addMouseWheelListener(ma);
        this.sessionTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                TreeSelectionModel model = ((JTree)evt.getSource()).getSelectionModel();
                ProviderTreePanel.this.selections = model.getSelectionPaths();
                Object provNode = null;
                if (evt.getPath().getPathCount() > 1) {
                    provNode = evt.getPath().getPathComponent(1);
                }
                if (provNode instanceof DefaultMutableTreeNode) {
                    EditorObjectProvider prov = ProviderTreePanel.this.nodeProviders.get(provNode);
                    try {
                        if (prov != null && prov.getTreeSelectionListener() != null) {
                            prov.getTreeSelectionListener().valueChanged(evt);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.sessionTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent evt) throws ExpandVetoException {
                Object provNode = null;
                if (evt.getPath().getPathCount() > 1) {
                    provNode = evt.getPath().getPathComponent(1);
                }
                if (provNode instanceof DefaultMutableTreeNode) {
                    EditorObjectProvider prov = ProviderTreePanel.this.nodeProviders.get(provNode);
                    try {
                        if (prov != null && prov.getTreeWillExpandListener() != null) {
                            prov.getTreeWillExpandListener().treeWillExpand(evt);
                        }
                    }
                    catch (ExpandVetoException ex) {
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent evt) throws ExpandVetoException {
                Object provNode = null;
                if (evt.getPath().getPathCount() > 1) {
                    provNode = evt.getPath().getPathComponent(1);
                }
                if (provNode instanceof DefaultMutableTreeNode) {
                    EditorObjectProvider prov = ProviderTreePanel.this.nodeProviders.get(provNode);
                    try {
                        if (prov != null && prov.getTreeWillExpandListener() != null) {
                            prov.getTreeWillExpandListener().treeWillCollapse(evt);
                        }
                    }
                    catch (ExpandVetoException ex) {
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.sessionTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent evt) {
                Object provNode = null;
                if (evt.getPath().getPathCount() > 1) {
                    provNode = evt.getPath().getPathComponent(1);
                }
                if (provNode instanceof DefaultMutableTreeNode) {
                    EditorObjectProvider prov = ProviderTreePanel.this.nodeProviders.get(provNode);
                    try {
                        if (prov != null && prov.getTreeExpansionListener() != null) {
                            prov.getTreeExpansionListener().treeExpanded(evt);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent evt) {
                Object provNode = null;
                if (evt.getPath().getPathCount() > 1) {
                    provNode = evt.getPath().getPathComponent(1);
                }
                if (provNode instanceof DefaultMutableTreeNode) {
                    EditorObjectProvider prov = ProviderTreePanel.this.nodeProviders.get(provNode);
                    try {
                        if (prov != null && prov.getTreeExpansionListener() != null) {
                            prov.getTreeExpansionListener().treeCollapsed(evt);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.sessionTree.setRootVisible(false);
        this.sessionTree.setShowsRootHandles(true);
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(400, 300));
        this.add((Component)new JScrollPane(this.sessionTree), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setProviders(Collection<? extends EditorObjectProvider> providerList) {
        ArrayList<? extends EditorObjectProvider> sortedProviders = new ArrayList<EditorObjectProvider>(providerList);
        Collections.sort(sortedProviders, new Comparator<EditorObjectProvider>(){

            @Override
            public int compare(EditorObjectProvider a, EditorObjectProvider b) {
                String nameA = null;
                String nameB = null;
                try {
                    nameA = a.getProviderName();
                    nameB = b.getProviderName();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (nameA == null && nameB == null) {
                    return 0;
                }
                if (nameA == null) {
                    return Integer.MAX_VALUE;
                }
                if (nameB == null) {
                    return Integer.MIN_VALUE;
                }
                return a.getProviderName().compareTo(b.getProviderName());
            }
        });
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.sessionTree.getModel().getRoot();
        TreePath expandPath = null;
        if (root.getChildCount() == 0) {
            for (EditorObjectProvider editorObjectProvider : sortedProviders) {
                if (!editorObjectProvider.isVisible()) continue;
                try {
                    DefaultMutableTreeNode provNode = editorObjectProvider.getProviderRootNode();
                    if (provNode == null) continue;
                    provNode.setUserObject(editorObjectProvider);
                    ((DefaultTreeModel)this.sessionTree.getModel()).insertNodeInto(provNode, root, root.getChildCount());
                    this.nodeProviders.put(provNode, editorObjectProvider);
                    if (expandPath != null) continue;
                    expandPath = new TreePath(provNode.getPath());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (expandPath == null) {
            expandPath = new TreePath(root.getPath());
        }
        this.sessionTree.expandPath(expandPath);
    }

    public TreePath[] getSelections() {
        return this.selections;
    }

    public JTree getTree() {
        return this.sessionTree;
    }

    public DefaultTreeModel getTreeModel() {
        return (DefaultTreeModel)this.sessionTree.getModel();
    }

    public Enumeration<TreePath> getExpandedPaths() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.sessionTree.getModel().getRoot();
        return this.sessionTree.getExpandedDescendants(new TreePath(root.getPath()));
    }

    private class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            TreeCellRenderer r = null;
            if (value instanceof TreeNode) {
                EditorObjectProvider prov;
                TreeNode p = (TreeNode)value;
                while ((prov = ProviderTreePanel.this.nodeProviders.get(p)) == null && (p = p.getParent()) != null) {
                }
                if (prov != null && prov.getTreeCellRenderer() != null) {
                    r = prov.getTreeCellRenderer();
                }
            }
            if (r != null) {
                return r.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            }
            return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
    }

    private class MouseAdapterProxy
    extends MouseAdapter {
        private MouseAdapterProxy() {
        }

        private void mouseEvent(MouseEvent e) {
            DefaultMutableTreeNode provNode;
            EditorObjectProvider prov;
            TreePath path = ProviderTreePanel.this.sessionTree.getPathForLocation(e.getX(), e.getY());
            if (path != null && path.getPathCount() > 1 && path.getPathComponent(1) instanceof DefaultMutableTreeNode && (prov = ProviderTreePanel.this.nodeProviders.get(provNode = (DefaultMutableTreeNode)path.getPathComponent(1))) != null) {
                try {
                    switch (e.getID()) {
                        case 500: {
                            if (prov.getMouseListener() == null) break;
                            prov.getMouseListener().mouseClicked(e);
                            break;
                        }
                        case 504: {
                            if (prov.getMouseListener() == null) break;
                            prov.getMouseListener().mouseEntered(e);
                            break;
                        }
                        case 505: {
                            if (prov.getMouseListener() == null) break;
                            prov.getMouseListener().mouseExited(e);
                            break;
                        }
                        case 501: {
                            if (prov.getMouseListener() == null) break;
                            prov.getMouseListener().mousePressed(e);
                            break;
                        }
                        case 502: {
                            if (prov.getMouseListener() == null) break;
                            prov.getMouseListener().mouseReleased(e);
                            break;
                        }
                        case 506: {
                            if (prov.getMouseMotionListener() == null) break;
                            prov.getMouseMotionListener().mouseDragged(e);
                            break;
                        }
                        case 503: {
                            if (prov.getMouseMotionListener() == null) break;
                            prov.getMouseMotionListener().mouseMoved(e);
                            break;
                        }
                        case 507: {
                            if (prov.getMouseWheelListener() == null) break;
                            prov.getMouseWheelListener().mouseWheelMoved((MouseWheelEvent)e);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.mouseEvent(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.mouseEvent(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.mouseEvent(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.mouseEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mouseEvent(e);
        }
    }
}

