/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import com.sun.awt.AWTUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class OlafDialog
extends JDialog {
    private boolean sizeSet = false;
    private boolean cancelled = true;
    private JPanel contentPane = null;
    private JButton helpButton = new JButton();
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private String helpTopic = null;
    private final GridBagConstraints contentConstraints = new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 11, 1, new Insets(4, 4, 0, 4), 0, 0);

    public OlafDialog(Frame parent, String title, boolean modal, JPanel contentPane, float opacity) {
        super(parent, title, modal);
        this.contentPane = contentPane;
        if (opacity != 1.0f) {
            try {
                AWTUtilities.setWindowOpacity((Window)this, (float)opacity);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public OlafDialog(Frame parent, String title, JPanel contentPane) {
        this(parent, title, true, contentPane, 1.0f);
    }

    public OlafDialog(Frame parent, String title, JPanel contentPane, float opacity) {
        this(parent, title, true, contentPane, opacity);
    }

    @Override
    public void setSize(Dimension d) {
        this.sizeSet = true;
        super.setSize(d);
    }

    @Override
    public void setSize(int width, int height) {
        this.sizeSet = true;
        super.setSize(width, height);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            Frame frame;
            if (!this.sizeSet) {
                this.pack();
            }
            if ((frame = (Frame)this.getParent()) != null) {
                int frameCX = (int)(frame.getLocationOnScreen().getX() + (double)frame.getWidth() / 2.0);
                int frameCY = (int)(frame.getLocationOnScreen().getY() + (double)frame.getHeight() / 2.0);
                int x = (int)((double)frameCX - (double)this.getWidth() / 2.0);
                int y = (int)((double)frameCY - (double)this.getHeight() / 2.0);
                Point p = new Point(Math.max(x, 0), Math.max(y, 0));
                this.setLocation(p);
            }
        }
        super.setVisible(visible);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    private void jbInit() throws Exception {
        this.setResizable(true);
        this.setLayout(new GridBagLayout());
        this.helpButton.setMnemonic(72);
        this.helpButton.setText(MessagesBundle.getMessage("Help"));
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OlafDialog.this.JButtonHelp_actionPerformed(e);
            }
        });
        this.helpButton.setEnabled(false);
        this.okButton.setMnemonic(79);
        this.okButton.setText(MessagesBundle.getMessage("Ok"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OlafDialog.this.jButtonOk_actionPerformed(e);
            }
        });
        this.cancelButton.setMnemonic(67);
        this.cancelButton.setText(MessagesBundle.getMessage("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OlafDialog.this.jButtonCancel_actionPerformed(e);
            }
        });
        if (this.contentPane != null) {
            this.add((Component)this.contentPane, this.contentConstraints);
        }
        this.add((Component)this.helpButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 0), 0, 0));
        this.add((Component)this.okButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 12, 0, new Insets(4, 0, 4, 0), 0, 0));
        this.add((Component)this.cancelButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.pack();
    }

    private void jButtonOk_actionPerformed(ActionEvent e) {
        this.cancelled = false;
        this.setVisible(false);
    }

    private void jButtonCancel_actionPerformed(ActionEvent e) {
        this.cancelled = true;
        this.setVisible(false);
    }

    private void JButtonHelp_actionPerformed(ActionEvent e) {
        if (this.helpTopic == null) {
            return;
        }
    }

    public void setHelpTopic(String topic) {
        this.helpTopic = topic;
    }

    public void setAsCloseSelection(boolean option) {
        if (option) {
            this.cancelButton.setText(MessagesBundle.getMessage("Close"));
            this.okButton.setVisible(false);
        } else {
            this.cancelButton.setText(MessagesBundle.getMessage("Cancel"));
            this.okButton.setVisible(true);
        }
    }

    public JButton getHelpButton() {
        return this.helpButton;
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public void setContentPane(JPanel contentPane) {
        if (this.contentPane != null) {
            this.remove(this.contentPane);
        }
        this.contentPane = contentPane;
        if (contentPane != null) {
            this.add((Component)contentPane, this.contentConstraints);
        }
    }

    public static OlafDialog getOlafDialogParent(Container c) {
        while (c != null) {
            if (c instanceof OlafDialog) {
                return (OlafDialog)c;
            }
            c = c.getParent();
        }
        return null;
    }

    public void setOKbuttonInfo(String text, int mnemonicKey) {
        if (text == null || text.trim().length() == 0) {
            return;
        }
        this.okButton.setMnemonic(mnemonicKey);
        this.okButton.setText(text.trim());
    }
}

