/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.mdeditor.ui.GeometryMetadataTableModel;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class GeometryMetadataPanel
extends JPanel {
    GeometryMetadataTableModel tableModel = new GeometryMetadataTableModel();
    private JTable jTable1 = new JTable(this.tableModel);
    private JScrollPane jScrollPane1 = new JScrollPane(this.jTable1);
    private JLabel tableLabel = new JLabel();
    private JTextField tableTxt = new JTextField();
    private JLabel columnLabel = new JLabel();
    private JTextField columnTxt = new JTextField();
    private JLabel sridLabel = new JLabel();
    private JTextField sridTxt = new JTextField();
    private JLabel dimarrayLabel = new JLabel();
    private JButton adddimButton = new JButton();
    private JButton remdimButton = new JButton();

    public GeometryMetadataPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(392, 256));
        this.setPreferredSize(new Dimension(370, 250));
        this.setBorder(BorderFactory.createTitledBorder(MessagesBundle.getMessage("Metadata")));
        this.tableLabel.setText(MessagesBundle.getMessage("Label_geometry_table"));
        this.columnLabel.setText(MessagesBundle.getMessage("Label_geometry_column"));
        this.sridLabel.setText(MessagesBundle.getMessage("Label_srid"));
        this.dimarrayLabel.setText(MessagesBundle.getMessage("Dimension_array"));
        this.adddimButton.setText(MessagesBundle.getMessage("Add"));
        this.adddimButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeometryMetadataPanel.this.adddimButton_actionPerformed(e);
            }
        });
        this.remdimButton.setText(MessagesBundle.getMessage("Remove"));
        this.remdimButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeometryMetadataPanel.this.remdimButton_actionPerformed(e);
            }
        });
        this.add((Component)this.tableLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.tableTxt, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 10), 0, 0));
        this.add((Component)this.columnLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.columnTxt, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        this.add((Component)this.sridLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.sridTxt, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        this.add((Component)this.dimarrayLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 10, 0, 0), 0, 0));
        this.add((Component)this.adddimButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 10, 0, 0), 0, 0));
        this.add((Component)this.remdimButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 70, 0, 0), 0, 0));
        this.add((Component)this.jScrollPane1, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.jTable1.setSelectionMode(0);
        this.jTable1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GeometryMetadataPanel.this.updateButtonStatus();
            }
        });
        this.jTable1.getColumnModel().getColumn(3).setCellRenderer(new NumberFormatCellRenderer());
    }

    public String getGeometryTable() {
        if (this.tableTxt.getText() == null || this.tableTxt.getText().trim().length() == 0) {
            return null;
        }
        return this.tableTxt.getText().trim();
    }

    public void setGeometryTable(String table) {
        if (table == null) {
            return;
        }
        this.tableTxt.setText(table);
    }

    public String getGeometryColumn() {
        if (this.columnTxt.getText() == null || this.columnTxt.getText().trim().length() == 0) {
            return null;
        }
        return this.columnTxt.getText().trim();
    }

    public void setGeometryColumn(String column) {
        if (column == null) {
            return;
        }
        this.columnTxt.setText(column);
    }

    public void setSRID(long srid) {
        NumberFormat nf = NumberFormat.getInstance();
        this.sridTxt.setText(nf.format(srid));
    }

    public long getSRID() {
        NumberFormat nf = NumberFormat.getInstance();
        try {
            return nf.parse(this.sridTxt.getText()).longValue();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public void addDimension(String name, double min, double max, double tol) {
        this.tableModel.addRow(-1, name, min, max, tol);
        int count = this.tableModel.getRowCount();
        this.jTable1.setRowSelectionInterval(count - 1, count - 1);
    }

    private void adddimButton_actionPerformed(ActionEvent e) {
        this.tableModel.addRow(-1, "", 0.0, 1.0, 5.0E-6);
        int count = this.tableModel.getRowCount();
        this.jTable1.setRowSelectionInterval(count - 1, count - 1);
    }

    private void remdimButton_actionPerformed(ActionEvent e) {
        int selRow = this.jTable1.getSelectedRow();
        if (selRow < 0) {
            return;
        }
        this.tableModel.deleteRow(selRow);
        int nrows = this.tableModel.getRowCount();
        if (nrows > 0) {
            if (selRow == nrows) {
                this.jTable1.setRowSelectionInterval(nrows - 1, nrows - 1);
            } else {
                this.jTable1.setRowSelectionInterval(selRow, selRow);
            }
        }
        this.updateButtonStatus();
    }

    private void updateButtonStatus() {
        int selRow = this.jTable1.getSelectedRow();
        if (selRow < 0) {
            this.remdimButton.setEnabled(false);
        } else {
            this.remdimButton.setEnabled(true);
        }
    }

    public int getNumberofDimensions() {
        return this.tableModel.getRowCount();
    }

    public String[] getDimNameValues() {
        return this.tableModel.getDimNameValues();
    }

    public double[] getMinValues() {
        return this.tableModel.getMinValues();
    }

    public double[] getMaxValues() {
        return this.tableModel.getMaxValues();
    }

    public double[] getToleranceValues() {
        return this.tableModel.getToleranceValues();
    }

    private class NumberFormatCellRenderer
    extends DefaultTableCellRenderer {
        DecimalFormat decimalFormat = new DecimalFormat("0.E0");

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setText(this.decimalFormat.format(value));
            return this;
        }
    }
}

