/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import oracle.maps.core.EditableLayer;
import oracle.maps.core.Layer;
import oracle.maps.core.LayerManager;
import oracle.maps.core.LayerManagerEvent;
import oracle.maps.core.SelectableLayer;
import oracle.maps.core.SnappableLayer;
import oracle.mdeditor.session.EditSession;
import oracle.mdeditor.ui.EditSessionPanel;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class EditSessionTableModel
extends AbstractTableModel
implements ChangeListener {
    protected EditSessionPanel editSessionPanel = null;
    protected Column ICON_COLUMN = new Column(ImageIcon.class, MessagesBundle.getMessage("Layer_icon"));
    protected Column NAME_COLUMN = new Column(String.class, MessagesBundle.getMessage("Data_layer"));
    protected Column VISIBLE_COLUMN = new Column(Boolean.class, MessagesBundle.getMessage("Visible"));
    protected Column EDITABLE_COLUMN = new Column(Boolean.class, MessagesBundle.getMessage("Editable"));
    protected Column TARGET_COLUMN = new Column(Boolean.class, MessagesBundle.getMessage("Target"));
    protected Column SNAP_COLUMN = new Column(Boolean.class, MessagesBundle.getMessage("Snap"));
    protected Column SELECT_COLUMN = new Column(Boolean.class, MessagesBundle.getMessage("Select"));
    protected Column[] columns = new Column[]{this.ICON_COLUMN, this.NAME_COLUMN, this.VISIBLE_COLUMN, this.EDITABLE_COLUMN, this.TARGET_COLUMN, this.SNAP_COLUMN, this.SELECT_COLUMN};

    public EditSessionTableModel(EditSessionPanel editSessionPanel) {
        this.editSessionPanel = editSessionPanel;
        editSessionPanel.addChangeListener(this);
    }

    public Layer getLayer(int i) {
        EditSession es = this.editSessionPanel.getEditSession();
        if (es == null) {
            return null;
        }
        int c = 0;
        Iterator<LayerManager.Entry> itr = es.getLayers().entryIterator();
        while (itr.hasNext()) {
            LayerManager.Entry e = itr.next();
            if (!e.getTags().contains("dataLayer")) continue;
            if (c == i) {
                return e.getLayer();
            }
            ++c;
        }
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        Object src = evt.getSource();
        if (src instanceof EditSessionPanel) {
            EditSession newSession;
            EditSessionPanel.SessionChangeEvent e = (EditSessionPanel.SessionChangeEvent)evt;
            EditSession oldSession = e.getOldSession();
            if (oldSession != null) {
                oldSession.getLayers().removeChangeListener(this);
                this.fireTableDataChanged();
            }
            if ((newSession = e.getNewSession()) != null) {
                newSession.getLayers().addChangeListener(this);
                this.fireTableDataChanged();
            }
        } else if (src instanceof LayerManager) {
            LayerManagerEvent lme = (LayerManagerEvent)evt;
            if (!(lme.getType() != 3 && lme.getType() != 4 || lme.getTags().contains("dataLayer"))) {
                this.fireTableRowsUpdated(0, this.getRowCount());
            } else {
                this.fireTableDataChanged();
            }
        }
    }

    @Override
    public String getColumnName(int col) {
        if (col < this.columns.length && col >= 0) {
            return this.columns[col].name;
        }
        return "";
    }

    public Class getColumnClass(int col) {
        if (col < this.columns.length && col >= 0) {
            return this.columns[col].c;
        }
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        Layer layer = this.getLayer(row);
        if (layer == null) {
            return false;
        }
        Column column = this.columns[col];
        if (column == this.ICON_COLUMN) {
            return false;
        }
        if (column == this.NAME_COLUMN) {
            return false;
        }
        if (column == this.VISIBLE_COLUMN) {
            return true;
        }
        if (column == this.EDITABLE_COLUMN) {
            return layer instanceof EditableLayer;
        }
        if (column == this.TARGET_COLUMN) {
            return layer instanceof EditableLayer;
        }
        if (column == this.SNAP_COLUMN) {
            return layer instanceof SnappableLayer;
        }
        if (column == this.SELECT_COLUMN) {
            return layer instanceof SelectableLayer;
        }
        return false;
    }

    @Override
    public int getRowCount() {
        int c = 0;
        EditSession es = this.editSessionPanel.getEditSession();
        if (es != null) {
            Iterator<LayerManager.Entry> itr = es.getLayers().entryIterator();
            while (itr.hasNext()) {
                LayerManager.Entry e = itr.next();
                if (!e.getTags().contains("dataLayer")) continue;
                ++c;
            }
        }
        return c;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Layer layer = this.getLayer(row);
        if (layer == null) {
            return null;
        }
        LayerManager lm = this.editSessionPanel.getEditSession().getLayers();
        Column column = this.columns[col];
        if (column == this.ICON_COLUMN) {
            return layer.getIcon();
        }
        if (column == this.NAME_COLUMN) {
            return layer.getName();
        }
        if (column == this.VISIBLE_COLUMN) {
            return layer.isVisible();
        }
        if (column == this.EDITABLE_COLUMN) {
            return layer instanceof EditableLayer && ((EditableLayer)layer).isEditable();
        }
        if (column == this.TARGET_COLUMN) {
            return lm.getTags(layer).contains("targetLayer");
        }
        if (column == this.SNAP_COLUMN) {
            return lm.getTags(layer).contains("snapLayer");
        }
        if (column == this.SELECT_COLUMN) {
            return lm.getTags(layer).contains("selectionLayer");
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (value == null) {
            return;
        }
        Layer layer = this.getLayer(row);
        if (layer == null) {
            return;
        }
        LayerManager lm = this.editSessionPanel.getEditSession().getLayers();
        Column column = this.columns[col];
        if (column == this.VISIBLE_COLUMN) {
            layer.setVisible((Boolean)value);
        } else if (column == this.EDITABLE_COLUMN) {
            ((EditableLayer)layer).setEditable((Boolean)value);
        } else if (column == this.TARGET_COLUMN) {
            lm.untag("targetLayer");
            if (((Boolean)value).booleanValue()) {
                lm.tag(layer, "targetLayer");
            }
        } else if (column == this.SNAP_COLUMN) {
            if (((Boolean)value).booleanValue()) {
                lm.tag(layer, "snapLayer");
            } else {
                lm.untag(layer, "snapLayer");
            }
        } else if (column == this.SELECT_COLUMN) {
            lm.untag("selectionLayer");
            if (((Boolean)value).booleanValue()) {
                lm.tag(layer, "selectionLayer");
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    public class Column {
        public Class c;
        public String name;

        public Column(Class c, String name) {
            this.c = c;
            this.name = name;
        }
    }
}

