/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.maps.core.Layer;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.session.EditSession;
import oracle.mdeditor.session.EditSessionProvider;
import oracle.mdeditor.session.layer.LayerProvider;
import oracle.mdeditor.ui.EditSessionPreferencesPanel;
import oracle.mdeditor.ui.EditSessionTablePanel;
import oracle.mdeditor.ui.ErrorDialog;
import oracle.mdeditor.ui.MainAppPanel;
import oracle.mdeditor.ui.MultiRowFlowLayout;
import oracle.mdeditor.ui.OlafDialog;
import oracle.mdeditor.ui.ProviderTreePanel;
import oracle.mdeditor.ui.SDEUIComponent;
import oracle.mdeditor.ui.XYPanel;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.spatial.edit.session.MDSEditSession;

public class EditSessionPanel
extends JPanel
implements SDEUIComponent,
ChangeListener,
ListSelectionListener {
    private static final Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPEDITOR);
    protected MainAppPanel mainApp = null;
    protected EditSession editSession = null;
    protected TreePath editSessionPath = null;
    protected EditSessionProvider editSessionProvider = null;
    protected JToolBar toolbar = new JToolBar();
    protected JButton openSessionButton = new JButton(Icons.getIcon("open.png"));
    protected JButton addLayerButton = new JButton();
    protected JButton deleteDataButton = new JButton();
    protected JButton moveUpButton = new JButton();
    protected JButton moveDownButton = new JButton();
    protected JButton propertiesButton = new JButton(Icons.getIcon("pageproperties_ena.png"));
    protected JButton mergeSessionButton = new JButton(Icons.getIcon("commit_ena.png"));
    protected JButton saveSessionDefButton = new JButton(Icons.getIcon("filesave.png"));
    protected JButton deleteSessionButton = new JButton(Icons.getIcon("deletecontext.png"));
    protected AbstractButton[] myButtons = new AbstractButton[]{this.openSessionButton, this.addLayerButton, this.deleteDataButton, this.moveUpButton, this.moveDownButton, this.propertiesButton, this.mergeSessionButton, this.saveSessionDefButton, this.deleteSessionButton};
    protected EditSessionTablePanel tablePanel = null;
    protected ProviderTreePanel sessionSelectPanel = null;
    protected ProviderTreePanel layerSelectPanel = null;
    protected EventListenerList listenerList = new EventListenerList();
    private static final String NEWLAYERMARKER = "New layer";

    public EditSessionPanel(MainAppPanel mainApp) {
        this.mainApp = mainApp;
        this.tablePanel = new EditSessionTablePanel(this);
        this.sessionSelectPanel = new ProviderTreePanel(1);
        this.layerSelectPanel = new ProviderTreePanel(4);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setName(MessagesBundle.getMessage("Edit_session"));
        this.toolbar.setLayout(new MultiRowFlowLayout());
        this.toolbar.setRollover(true);
        this.openSessionButton.setToolTipText(MessagesBundle.getMessage("Tooltip_open_session"));
        this.openSessionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditSessionPanel.this.openSession();
            }
        });
        this.toolbar.add(this.openSessionButton);
        this.addLayerButton.setToolTipText(MessagesBundle.getMessage("Tooltip_add_spatial_data"));
        this.addLayerButton.setIcon(Icons.getIcon("add_sm_ena.png"));
        this.addLayerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditSessionPanel.this.addLayer();
            }
        });
        this.toolbar.add(this.addLayerButton);
        this.deleteDataButton.setToolTipText(MessagesBundle.getMessage("Tooltip_remove_data_layer"));
        this.deleteDataButton.setIcon(Icons.getIcon("delete.png"));
        this.deleteDataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditSessionPanel.this.removeLayer();
            }
        });
        this.deleteDataButton.setEnabled(false);
        this.toolbar.add(this.deleteDataButton);
        this.moveUpButton.setToolTipText(MessagesBundle.getMessage("Tooltip_move_data_layer_up"));
        this.moveUpButton.setIcon(Icons.getIcon("up16.png"));
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditSessionPanel.this.moveLayerUp();
            }
        });
        this.moveUpButton.setEnabled(false);
        this.toolbar.add(this.moveUpButton);
        this.moveDownButton.setToolTipText(MessagesBundle.getMessage("Tooltip_move_data_layer_down"));
        this.moveDownButton.setIcon(Icons.getIcon("down16.png"));
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditSessionPanel.this.moveLayerDown();
            }
        });
        this.moveDownButton.setEnabled(false);
        this.toolbar.add(this.moveDownButton);
        this.propertiesButton.setToolTipText(MessagesBundle.getMessage("Tooltip_edit_session_properties"));
        this.propertiesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditSessionPreferencesPanel prefPanel = new EditSessionPreferencesPanel(EditSessionPanel.this.mainApp, EditSessionPanel.this.editSession, EditSessionPanel.this.getSelectedLayer());
                OlafDialog prefDialog = new OlafDialog(EditSessionPanel.this.getFrameForDialog(), MessagesBundle.getMessage("Edit_preferences"), prefPanel, 1.0f);
                prefDialog.setAsCloseSelection(true);
                prefDialog.setVisible(true);
                if (EditSessionPanel.this.mainApp != null) {
                    EditSessionPanel.this.mainApp.getRenderStylePicker().updateUIStatus();
                    EditSessionPanel.this.mainApp.getLabelStylePicker().updateUIStatus();
                }
            }
        });
        this.toolbar.add(this.propertiesButton);
        this.mergeSessionButton.setToolTipText(MessagesBundle.getMessage("Tooltip_merge_session"));
        this.mergeSessionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EditSessionPanel.this.editSession instanceof MDSEditSession) {
                    ((MDSEditSession)EditSessionPanel.this.editSession).merge(EditSessionPanel.this.mainApp.getLoadedEditSessions().values(), EditSessionPanel.this.editSessionProvider);
                }
            }
        });
        this.toolbar.add(this.mergeSessionButton);
        this.saveSessionDefButton.setToolTipText(MessagesBundle.getMessage("Tooltip_save_session"));
        this.saveSessionDefButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingWorker<Void, Void> w = new SwingWorker<Void, Void>(){

                    @Override
                    public Void doInBackground() throws Exception {
                        if (EditSessionPanel.this.editSession != null) {
                            this.getPropertyChangeSupport().firePropertyChange("progressString", null, MessagesBundle.getMessage("Progressbar_savingeditsession"));
                            this.getPropertyChangeSupport().firePropertyChange("progressIndeterminate", null, (Object)true);
                            if (EditSessionPanel.this.editSession.saveDefinition()) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        JOptionPane.showMessageDialog(EditSessionPanel.this.mainApp.getFrameForDialog(), MessagesBundle.getFormattedMessage("Edit_session_saved", EditSessionPanel.this.getName()), MessagesBundle.getMessage("Information"), 1);
                                    }
                                });
                            }
                        }
                        return null;
                    }
                };
                if (EditSessionPanel.this.editSession != null) {
                    w.addPropertyChangeListener(EditSessionPanel.this.editSession.getMapCanvas());
                    w.execute();
                }
            }
        });
        this.toolbar.add(this.saveSessionDefButton);
        this.deleteSessionButton.setToolTipText(MessagesBundle.getMessage("Tooltip_delete_session"));
        this.deleteSessionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sessionName = null;
                if (EditSessionPanel.this.editSession != null) {
                    sessionName = EditSessionPanel.this.editSession.getName();
                    if (EditSessionPanel.this.editSession.delete(EditSessionPanel.this.mainApp.getLoadedEditSessions().values())) {
                        EditSessionPanel.this.mainApp.getLoadedEditSessions().remove(sessionName);
                        EditSessionPanel.this.editSession = null;
                        if (EditSessionPanel.this.editSessionPath != null) {
                            if (EditSessionPanel.this.sessionSelectPanel != null) {
                                EditSessionPanel.this.sessionSelectPanel.getTreeModel().removeNodeFromParent((MutableTreeNode)EditSessionPanel.this.editSessionPath.getLastPathComponent());
                            }
                            if (EditSessionPanel.this.editSessionProvider != null) {
                                EditSessionPanel.this.editSessionProvider.removeEditorObject(EditSessionPanel.this.editSessionPath);
                            }
                        }
                        EditSessionPanel.this.setEditSession(null);
                    }
                }
            }
        });
        this.toolbar.add(this.deleteSessionButton);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.toolbar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.tablePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.updateUIStatus();
    }

    public EditSession getEditSession() {
        return this.editSession;
    }

    public void setEditSession(EditSession editSession) {
        Layer dl;
        EditSession oldSession = this.editSession;
        if (oldSession != null && oldSession.isModified()) {
            int option = JOptionPane.showConfirmDialog(this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Question_save_changes"));
            if (option == 0) {
                oldSession.saveData();
            } else if (option == 2) {
                return;
            }
        }
        this.editSession = editSession;
        if (editSession != null && oldSession != editSession && oldSession != null) {
            oldSession.saveDefinition();
        }
        this.fireStateChanged(new SessionChangeEvent(this, oldSession, editSession));
        if (editSession == null) {
            this.openSession();
        } else if (editSession.getLayers() != null && (dl = editSession.getLayers().getLayerByTag("dataLayer")) == null) {
            this.addLayer();
        }
        if (editSession != null) {
            Level level = Level.INFO;
            String loglevel = editSession.getProperty("oracle.spatial.edit.session.MDSEditSession.loglevel");
            if (loglevel != null && loglevel.equalsIgnoreCase("finest")) {
                level = Level.FINEST;
            }
            for (Handler h : Logger.getLogger("").getHandlers()) {
                if (!(h instanceof ConsoleHandler)) continue;
                h.setLevel(level);
            }
            log.setLevel(level);
        }
        this.mainApp.updateGUIStatus();
    }

    public JToolBar getToolbar() {
        return this.toolbar;
    }

    public Frame getFrameForDialog() {
        for (Container c = this; c != null; c = c.getParent()) {
            if (!(c instanceof Frame)) continue;
            return (Frame)c;
        }
        return null;
    }

    public ListSelectionModel getSelectionModel() {
        return this.tablePanel.getSelectionModel();
    }

    public Layer getSelectedLayer() {
        if (this.editSession != null) {
            return this.tablePanel.getSelectedLayer();
        }
        return null;
    }

    private void openSession() {
        this.sessionSelectPanel.setProviders(this.mainApp.getEditSessionProviders().values());
        OlafDialog dlg = new OlafDialog(this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Tooltip_open_session"), this.sessionSelectPanel);
        dlg.getOkButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ((JButton)evt.getSource()).getParent().setCursor(Cursor.getPredefinedCursor(3));
                TreePath[] selections = EditSessionPanel.this.sessionSelectPanel.getSelections();
                if (selections == null || selections.length != 1 || selections[0] == null) {
                    return;
                }
                EditSessionProvider prov = (EditSessionProvider)((DefaultMutableTreeNode)selections[0].getPathComponent(1)).getUserObject();
                EditSession session = null;
                Exception exception = null;
                try {
                    session = (EditSession)prov.getEditorObject(selections[0]);
                }
                catch (Exception ex) {
                    exception = ex;
                }
                if (session != null && exception == null) {
                    EditSessionPanel.this.setEditSession(session);
                    EditSessionPanel.this.editSessionPath = selections[0];
                    EditSessionPanel.this.editSessionProvider = prov;
                    EditSessionPanel.this.mainApp.getLoadedEditSessions().put(session.getName(), session);
                } else {
                    ErrorDialog.showErrorDialog(exception, EditSessionPanel.this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Unable_toload_edit_session"), MessagesBundle.getMessage("Error"), 0);
                }
                ((JButton)evt.getSource()).getParent().setCursor(Cursor.getDefaultCursor());
            }
        });
        dlg.setVisible(true);
    }

    private void addLayer() {
        if (this.editSession == null) {
            return;
        }
        this.layerSelectPanel.setProviders(this.mainApp.getLayerProviders().values());
        OlafDialog dlg = new OlafDialog(this.mainApp.getFrameForDialog(), MessagesBundle.getMessage("Tooltip_add_spatial_data"), this.layerSelectPanel);
        dlg.getOkButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ((JButton)evt.getSource()).getParent().setCursor(Cursor.getPredefinedCursor(3));
                TreePath[] selections = EditSessionPanel.this.layerSelectPanel.getSelections();
                if (selections == null) {
                    return;
                }
                for (TreePath path : selections) {
                    Layer layer;
                    LayerProvider prov = (LayerProvider)((DefaultMutableTreeNode)path.getPathComponent(1)).getUserObject();
                    if (prov == null || (layer = (Layer)prov.getEditorObject(path)) == null) continue;
                    for (Map.Entry<String, LayerProvider> e : EditSessionPanel.this.mainApp.getLayerProviders().entrySet()) {
                        if (!e.getValue().equals(prov)) continue;
                        layer.setProviderID(e.getKey());
                        break;
                    }
                    EditSessionPanel.this.editSession.addLayer(layer);
                }
                ((JButton)evt.getSource()).getParent().setCursor(Cursor.getDefaultCursor());
            }
        });
        dlg.setVisible(true);
        this.mainApp.updateGUIStatus();
    }

    private void removeLayer() {
        Layer layer = this.getSelectedLayer();
        if (layer != null) {
            int newRow = this.tablePanel.getSelectedRow();
            if (newRow == this.tablePanel.getRowCount() - 1) {
                --newRow;
            }
            if (this.editSession.removeLayer(layer)) {
                this.tablePanel.getSelectionModel().setSelectionInterval(newRow, newRow);
                this.mainApp.updateGUIStatus();
            }
        }
    }

    private void moveLayerUp() {
        Layer layer = this.getSelectedLayer();
        if (layer != null) {
            int newRow = this.tablePanel.getSelectedRow() - 1;
            this.editSession.getLayers().moveUp(layer, false);
            this.tablePanel.getSelectionModel().setSelectionInterval(newRow, newRow);
            this.mainApp.updateGUIStatus();
        }
    }

    private void moveLayerDown() {
        Layer layer = this.getSelectedLayer();
        if (layer != null) {
            int newRow = this.tablePanel.getSelectedRow() + 1;
            this.editSession.getLayers().moveDown(layer, false);
            this.tablePanel.getSelectionModel().setSelectionInterval(newRow, newRow);
            this.mainApp.updateGUIStatus();
        }
    }

    @Override
    public Component getComponent() {
        return this;
    }

    public void setButtonsEnabled(boolean flag) {
        for (AbstractButton btn : this.myButtons) {
            btn.setEnabled(flag);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void updateUIStatus() {
        String newName = MessagesBundle.getMessage("Edit_session");
        if (this.editSession != null) {
            newName = this.editSession.getName();
        }
        this.setName(newName);
        this.setButtonsEnabled(false);
        if (this.mainApp.getEditSessionProviders().size() > 0) {
            this.openSessionButton.setEnabled(true);
        }
        if (this.editSession == null) {
            this.tablePanel.tableDataChanged();
            return;
        }
        this.propertiesButton.setEnabled(true);
        this.addLayerButton.setEnabled(true);
        this.saveSessionDefButton.setEnabled(true);
        this.deleteSessionButton.setEnabled(true);
        this.mergeSessionButton.setEnabled(false);
        if (this.editSession instanceof MDSEditSession) {
            MDSEditSession mdse = (MDSEditSession)this.editSession;
            if (mdse.isVersioned()) {
                this.mergeSessionButton.setEnabled(true);
            } else {
                this.mergeSessionButton.setEnabled(false);
            }
            if (mdse.isLocked()) {
                // empty if block
            }
        } else {
            this.mergeSessionButton.setVisible(false);
        }
        int selectedRow = this.tablePanel.getSelectedRow();
        if (selectedRow > -1) {
            this.deleteDataButton.setEnabled(true);
            if (selectedRow > 0) {
                this.moveUpButton.setEnabled(true);
            }
            if (selectedRow < this.tablePanel.getRowCount() - 1) {
                this.moveDownButton.setEnabled(true);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e != null && e.getValueIsAdjusting()) {
            return;
        }
        this.updateUIStatus();
    }

    public static Point2D getXYOperationValues(String dlgTitle, String xFieldName, String xFieldTooltip, double xDefaultValue, String yFieldName, String yFieldTooltip, double yDefaultValue, Frame parent) {
        Point2D.Double value = new Point2D.Double(Double.NaN, Double.NaN);
        XYPanel sizePanel = new XYPanel();
        sizePanel.setLabels(xFieldName, yFieldName);
        sizePanel.setXFieldTooltip(xFieldTooltip);
        sizePanel.setXValue(xDefaultValue);
        sizePanel.setYFieldTooltip(yFieldTooltip);
        sizePanel.setYValue(yDefaultValue);
        OlafDialog txtDlg = new OlafDialog(parent, dlgTitle, sizePanel);
        txtDlg.setSize(300, 180);
        txtDlg.setVisible(true);
        if (!txtDlg.isCancelled()) {
            if (sizePanel.isXNumberValid() && sizePanel.isYNumberValid()) {
                ((Point2D)value).setLocation(sizePanel.getXValue(), sizePanel.getYValue());
            }
        } else {
            txtDlg.dispose();
            return null;
        }
        txtDlg.dispose();
        return value;
    }

    private void setWaitCursor() {
        this.setCursor(new Cursor(3));
    }

    private void setDefaultCursor() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged(ChangeEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (event == null) {
                event = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    public class SessionChangeEvent
    extends ChangeEvent {
        protected EditSession oldSession;
        protected EditSession newSession;

        public SessionChangeEvent(Object source, EditSession oldSession, EditSession newSession) {
            super(source);
            this.oldSession = null;
            this.newSession = null;
            this.oldSession = oldSession;
            this.newSession = newSession;
        }

        public EditSession getOldSession() {
            return this.oldSession;
        }

        public EditSession getNewSession() {
            return this.newSession;
        }
    }
}

