/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.edit.session.layer.EditSessionLayer;

public class AnnotationTextLayerPropertyPanel
extends JPanel {
    private JLabel atextLabel = new JLabel();
    private JComboBox atextBox = new JComboBox();
    private String userName = null;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel nameLabel = new JLabel();
    private JLabel nameTxt = new JLabel();
    private JLabel basetableLabel = new JLabel();
    private JLabel basetableTxt = new JLabel();
    private JLabel livescaleLabel = new JLabel();
    private JTextField livescaleTxt = new JTextField();
    private JLabel keyLabel = new JLabel();
    private JComboBox keyComboBox = new JComboBox();
    private JLabel conditionLabel = new JLabel();
    private JTextField conditionTxt = new JTextField();
    private EditSessionLayer sessionLayer = null;
    private String[] spatialColumns = null;
    private String[] tableAttrs = null;
    private JCheckBox keysequenceBox = new JCheckBox();
    private JComboBox keysequenceComboBox = new JComboBox();
    String[] seqNames = null;

    public AnnotationTextLayerPropertyPanel(EditSessionLayer layer, String[] atextColumns, String[] simpleAttrs, String[] sequences) {
        this.sessionLayer = layer;
        this.spatialColumns = atextColumns;
        this.tableAttrs = simpleAttrs;
        this.seqNames = sequences;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() {
        this.setLayout(this.gridBagLayout1);
        this.setSize(new Dimension(311, 181));
        this.atextLabel.setText(MessagesBundle.getMessage("Label_annotation_column"));
        this.keyLabel.setText(MessagesBundle.getMessage("Label_key_column"));
        this.nameLabel.setText(MessagesBundle.getMessage("Label_name"));
        this.basetableLabel.setText(MessagesBundle.getMessage("Label_base_table"));
        this.livescaleLabel.setText(MessagesBundle.getMessage("Label_live_scale"));
        this.livescaleTxt.setToolTipText(MessagesBundle.getMessage("Tooltip_live_scale"));
        this.conditionLabel.setText(MessagesBundle.getMessage("Label_query_condition"));
        this.keysequenceBox.setText(MessagesBundle.getMessage("Label_key_sequence"));
        this.add((Component)this.nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.nameTxt, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.basetableLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.basetableTxt, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.keyLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.keyComboBox, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.keysequenceBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.keysequenceComboBox, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.atextLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.atextBox, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.conditionLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.conditionTxt, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.livescaleLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.livescaleTxt, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 10, 0, 10), 0, 0));
        this.fillUIparameters();
    }

    public String getAnnotationColumn() {
        if (this.atextBox.getItemCount() < 1) {
            return null;
        }
        return this.atextBox.getSelectedItem().toString();
    }

    public void setAnnotationColumn(String geomCol) {
        if (geomCol == null) {
            return;
        }
        this.atextBox.setSelectedItem(geomCol.toUpperCase());
    }

    public void setAnnotationColumns(String[] columns) {
        this.atextBox.removeAllItems();
        if (columns == null) {
            return;
        }
        for (int i = 0; i < columns.length; ++i) {
            this.atextBox.addItem(columns[i]);
        }
    }

    public void setKeyColumns(String[] colnames) {
        this.keyComboBox.removeAllItems();
        this.keyComboBox.addItem("ROWID");
        if (colnames == null) {
            return;
        }
        for (int i = 0; i < colnames.length; ++i) {
            if (colnames[i].equalsIgnoreCase("ROWID")) continue;
            this.keyComboBox.addItem(colnames[i].toUpperCase());
        }
    }

    public void setKeyColumn(String colname) {
        if (colname == null) {
            return;
        }
        this.keyComboBox.setSelectedItem(colname.toUpperCase());
    }

    public String getKeyColumn() {
        if (this.keyComboBox.getItemCount() == 0) {
            return null;
        }
        return this.keyComboBox.getSelectedItem().toString();
    }

    private void fillUIparameters() {
        if (this.sessionLayer == null) {
            return;
        }
        this.nameTxt.setText(this.sessionLayer.getName());
        String basetable = this.sessionLayer.getBaseTable();
        this.setLiveScale(this.sessionLayer.getLiveScale());
        this.basetableTxt.setText(basetable);
        String geomColumn = this.sessionLayer.getSpatialColumn();
        String[] geomAttrs = this.spatialColumns;
        this.setAnnotationColumns(geomAttrs);
        this.setAnnotationColumn(geomColumn);
        String[] seqs = this.seqNames;
        this.setKeySequences(seqs);
        String seqName = this.sessionLayer.getParameterValue("keySequence");
        this.setKeySequence(seqName);
        if (seqName != null) {
            this.setKeySequenceSelected(true);
        } else {
            this.setKeySequenceSelected(false);
            this.setKeySequence(basetable + "_" + this.sessionLayer.getKeyColumn() + "_SEQ");
        }
        String[] attrs = this.tableAttrs;
        this.setKeyColumns(attrs);
        this.setKeyColumn(this.sessionLayer.getKeyColumn());
        this.setQueryCondition(this.sessionLayer.getParameterValue("queryCondition"));
    }

    public double getLiveScale() {
        String text = this.livescaleTxt.getText();
        if (text == null || text.length() == 0) {
            return 0.0;
        }
        NumberFormat nf = NumberFormat.getInstance();
        try {
            double scale = nf.parse(text).doubleValue();
            if (scale <= 0.0) {
                return Double.NaN;
            }
            return scale;
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public void setLiveScale(double scale) {
        if (Double.isNaN(scale)) {
            this.livescaleTxt.setText("");
        } else {
            NumberFormat nf = NumberFormat.getInstance();
            this.livescaleTxt.setText(nf.format(scale));
        }
    }

    public void setQueryCondition(String filter) {
        if (filter == null) {
            this.conditionTxt.setText("");
        } else {
            this.conditionTxt.setText(filter);
        }
    }

    public String getQueryCondition() {
        if (this.conditionTxt.getText() == null) {
            return null;
        }
        String filter = this.conditionTxt.getText().trim();
        if (filter.length() == 0) {
            return null;
        }
        return filter;
    }

    public void setKeySequences(String[] seqs) {
        this.keysequenceComboBox.removeAllItems();
        if (seqs == null) {
            return;
        }
        for (int i = 0; i < seqs.length; ++i) {
            if (seqs[i].toUpperCase().startsWith("MDRS_") && seqs[i].toUpperCase().endsWith("$")) continue;
            this.keysequenceComboBox.addItem(seqs[i].toUpperCase());
        }
    }

    public void setKeySequence(String seqname) {
        if (seqname == null) {
            return;
        }
        this.keysequenceComboBox.setSelectedItem(seqname.toUpperCase());
    }

    public void setKeySequenceSelected(boolean selected) {
        this.keysequenceBox.setSelected(selected);
    }

    public boolean isKeySequenceSelected() {
        return this.keysequenceBox.isSelected();
    }

    public String getKeySequence() {
        if (this.keysequenceComboBox.getItemCount() == 0) {
            return null;
        }
        return this.keysequenceComboBox.getSelectedItem().toString();
    }

    public void isEditingMode(boolean mode) {
        if (mode) {
            this.conditionTxt.setEnabled(false);
        } else {
            this.conditionTxt.setEnabled(true);
        }
    }
}

