/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;
import oracle.maps.util.PropertySupport;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class PropertySupportObject
extends Properties
implements PropertySupport {
    protected PropertyChangeSupport propChangeSupport = null;

    public PropertySupportObject(Object source) {
        this(source, true);
    }

    private PropertySupportObject(Object source, boolean createDefaults) {
        PropertySupportObject d = null;
        if (createDefaults) {
            d = new PropertySupportObject(null, false);
        }
        this.defaults = d;
        this.setChangeSupportSource(source);
    }

    @Override
    public Properties getProperties() {
        return this;
    }

    public void setChangeSupportSource(Object source) {
        if (source != null) {
            PropertyChangeSupport npcs = new PropertyChangeSupport(source);
            if (this.propChangeSupport != null) {
                for (PropertyChangeListener l : this.propChangeSupport.getPropertyChangeListeners()) {
                    npcs.addPropertyChangeListener(l);
                }
            }
            this.propChangeSupport = npcs;
        } else {
            this.propChangeSupport = null;
        }
    }

    public Properties getDefaultProperties() {
        return this.defaults;
    }

    public void setDefaultProperties(Properties defaults) {
        this.defaults = defaults;
    }

    @Override
    public String setProperty(String key, String value) {
        String oldValue = this.getProperty(key);
        if (value == null && oldValue != null || value != null && oldValue == null || value != null && oldValue != null && !value.equals(oldValue)) {
            if (value == null || this.defaults != null && value.equals(this.defaults.getProperty(key))) {
                this.remove(key);
            } else {
                super.setProperty(key, value);
            }
            if (this.propChangeSupport != null) {
                this.propChangeSupport.firePropertyChange(key, oldValue, this.getProperty(key));
            }
        }
        return oldValue;
    }

    public synchronized String setDefaultProperty(String key, String value) {
        Object oldVal = this.defaults.setProperty(key, value);
        if (oldVal != null) {
            return oldVal.toString();
        }
        return null;
    }

    public void fromXMLElement(XMLElement element) throws IOException {
        PropertySupportObject.fromXMLElement(element, this);
    }

    public static void fromXMLElement(XMLElement element, Properties properties) throws IOException {
        StringWriter sw = new StringWriter(400);
        element.print(new PrintWriter(sw));
        String xml = "<!DOCTYPE properties SYSTEM \"http://java.sun.com/dtd/properties.dtd\">\n" + sw.toString();
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        properties.clear();
        properties.loadFromXML(in);
    }

    public Element toXMLElement() throws IOException, SAXException {
        return PropertySupportObject.toXMLElement(this);
    }

    public static Element toXMLElement(Properties properties) throws IOException, SAXException {
        StringReader reader = null;
        try {
            Element propsElem;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            properties.storeToXML(baos, null);
            String propsXMLString = baos.toString("UTF-8");
            propsXMLString = propsXMLString.replaceAll("<!DOCTYPE properties SYSTEM \"http://java.sun.com/dtd/properties.dtd\">", "");
            reader = new StringReader(propsXMLString);
            DOMParser parser = new DOMParser();
            parser.setValidationMode(0);
            parser.setPreserveWhitespace(false);
            parser.parse((Reader)reader);
            XMLDocument propDoc = parser.getDocument();
            Element element = propsElem = propDoc.getDocumentElement();
            return element;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (SAXException ex) {
            throw ex;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static String serialize(Object obj) throws IOException {
        if (obj == null) {
            return "NULL";
        }
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bytes);
            oos.writeObject(obj);
            String string = new BASE64Encoder().encode(bytes.toByteArray());
            return string;
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static Object deserialize(String str) throws IOException, ClassNotFoundException {
        if (str == null || str.equals("NULL")) {
            return null;
        }
        ObjectInputStream ois = null;
        try {
            Object obj;
            ByteArrayInputStream bytes = new ByteArrayInputStream(new BASE64Decoder().decodeBuffer(str));
            ois = new ObjectInputStream(bytes);
            Object object = obj = ois.readObject();
            return object;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (ClassNotFoundException ex) {
            throw ex;
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propChangeSupport != null) {
            this.propChangeSupport.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.propChangeSupport != null) {
            this.propChangeSupport.addPropertyChangeListener(propertyName, listener);
        }
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners() {
        PropertyChangeListener[] res = null;
        if (this.propChangeSupport != null) {
            res = this.propChangeSupport.getPropertyChangeListeners();
        }
        return res;
    }

    @Override
    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        PropertyChangeListener[] res = null;
        if (this.propChangeSupport != null) {
            res = this.propChangeSupport.getPropertyChangeListeners(propertyName);
        }
        return res;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propChangeSupport != null) {
            this.propChangeSupport.removePropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.propChangeSupport != null) {
            this.propChangeSupport.removePropertyChangeListener(propertyName, listener);
        }
    }
}

