/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.util;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.maps.geoobject.AbstractFeature;
import oracle.maps.geoobject.GeometryFeature;
import oracle.maps.util.GeoJsonParser;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class MDSClientUtils {
    public static GeoObject[] parseMDSResponse(String data, Layer layer, Rectangle2D bbox) throws Exception {
        JsonParser jp = null;
        JsonFactory f = new JsonFactory();
        jp = f.createJsonParser(data);
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            throw new Exception("Malformed JSON: Invalid start of data");
        }
        int srid = -1;
        boolean sridRead = false;
        Hashtable<String, String> attrtypes = null;
        ArrayList<String> attrs = null;
        ArrayList<AbstractFeature> objs = null;
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            int i;
            String fieldName = jp.getCurrentName();
            jp.nextToken();
            if ("srs".equalsIgnoreCase(fieldName)) {
                srid = jp.getIntValue();
                sridRead = true;
                continue;
            }
            if ("attr_names".equalsIgnoreCase(fieldName)) {
                attrs = new ArrayList<String>();
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    String attrName = jp.getText();
                    if (attrName == null || attrName.isEmpty()) {
                        throw new Exception("Invalid 'attr_names' item in position " + (attrs.size() + 1));
                    }
                    attrs.add(attrName);
                }
                continue;
            }
            if ("attr_types".equalsIgnoreCase(fieldName)) {
                if (attrs == null) {
                    throw new Exception("Wrong order: Define 'attr_names' before 'attr_types'");
                }
                attrtypes = new Hashtable<String, String>();
                i = 0;
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    String attrType = jp.getText();
                    if (attrType == null || attrType.isEmpty()) {
                        throw new Exception("Invalid 'attr_types' item in position " + (i + 1));
                    }
                    String attrName = null;
                    try {
                        attrName = (String)attrs.get(i);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new Exception("Size mismatch: 'attr_types' has more elements than 'attr_names'");
                    }
                    attrtypes.put(attrName, attrType);
                    ++i;
                }
                if (attrtypes.size() == attrs.size()) continue;
                throw new Exception("Size mismatch: 'attr_names' has more elements than 'attr_types'");
            }
            if ("features".equalsIgnoreCase(fieldName)) {
                if (!sridRead) {
                    throw new Exception("Wrong order: Define 'srs' before 'features'");
                }
                if (attrtypes == null) {
                    throw new Exception("Wrong order: Define 'attr_names' and 'attr_types' before 'features'");
                }
                objs = new ArrayList<AbstractFeature>();
                i = 0;
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    AbstractFeature feature = GeoJsonParser.GeoJson2Feature(jp, srid, attrtypes);
                    if (feature instanceof GeometryFeature) {
                        feature.setKey("" + i);
                    }
                    feature.setLayer(layer);
                    objs.add(feature);
                    ++i;
                }
                continue;
            }
            jp.skipChildren();
        }
        if (objs != null) {
            return objs.toArray(new GeoObject[objs.size()]);
        }
        return null;
    }
}

