/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.tools;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.EventObject;
import java.util.logging.Logger;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.maps.core.MapCanvas;
import oracle.maps.geoobject.GeometryFeature;
import oracle.maps.layer.ActiveFeaturesLayer;
import oracle.maps.tools.BasicTool;
import oracle.maps.util.TransformUtils;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.edit.util.JGeometrySegmentPoint;
import oracle.sdovis.edit.util.JGeometryUtil;
import oracle.spatial.edit.index.RTreeIndex;
import oracle.spatial.edit.index.geometry.IndexedGeometrySet;
import oracle.spatial.edit.layer.GeometrySetLayer;
import oracle.spatial.edit.layer.TopologyPrimitiveLayer;
import oracle.spatial.edit.model.topology.TopologyModel;
import oracle.spatial.edit.util.JGeometrySegmentUtil;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.topo.Edge;

public class VertexMoveTool
extends BasicTool {
    private static final Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPEDITOR);
    private Layer targetLayer = null;
    private ActiveFeaturesLayer featureLayer = null;
    private GeoObject activeFeature = null;
    private JGeometrySegmentPoint snapInterPoint = null;
    private GeometryFeature geomFeature = null;
    private JGeometry originalGeom = null;
    private Point2D dragPoint = null;
    private RTreeIndex sptIndex = null;

    public VertexMoveTool(MapCanvas canvas) {
        super(canvas);
        this.properties.setDefaultProperty("oracle.maps.core.Layer.name", "Move vertex");
    }

    @Override
    public boolean handleEvent(EventObject evt) {
        boolean propagate = true;
        this.targetLayer = this.canvas.getLayerManager().getLayerByTag("targetLayer");
        this.activeFeature = this.featureLayer.getActiveFeature();
        if (evt instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)evt;
            int id = me.getID();
            propagate = true;
            switch (id) {
                case 503: {
                    this.mouseMoved(me);
                    break;
                }
                case 501: {
                    this.mousePressed(me);
                    break;
                }
                case 506: {
                    propagate = this.mouseDragged(me);
                    break;
                }
                case 502: {
                    this.mouseReleased(me);
                }
            }
        }
        return propagate;
    }

    protected void mouseMoved(MouseEvent evt) {
        if (this.targetLayer == null || this.activeFeature == null) {
            return;
        }
        this.geomFeature = null;
        try {
            Point2D.Double center = new Point2D.Double();
            this.canvas.getViewportTransform().inverseTransform(new Point2D.Double(evt.getX(), evt.getY()), center);
            double wcTolerance = TransformUtils.getWCTolerance(center, 3, this.canvas.getViewportTransform());
            if (this.targetLayer instanceof GeometrySetLayer) {
                GeometryFeature selectedFeature = (GeometryFeature)this.activeFeature;
                GeometrySetLayer gl = (GeometrySetLayer)this.targetLayer;
                String keyColumn = gl.getIndexedDataSet().getDataSet().getKeyColumn();
                String key = selectedFeature.getAttribute(keyColumn).getValue().toString();
                this.snapInterPoint = ((IndexedGeometrySet)gl.getIndexedDataSet()).getSegmentPoint(key, new Point2D.Double(((Point2D)center).getX(), ((Point2D)center).getY()), wcTolerance, false, false, false, false);
            } else if (this.targetLayer instanceof TopologyPrimitiveLayer) {
                JGeometry geom = ((GeometryFeature)this.activeFeature).getSpatialAttribute();
                if (this.sptIndex == null) {
                    this.sptIndex = JGeometrySegmentUtil.buildSegmentTree(geom);
                }
                this.snapInterPoint = JGeometrySegmentUtil.getSegmentPoint(geom, new Point2D.Double(((Point2D)center).getX(), ((Point2D)center).getY()), wcTolerance, false, false, false, false, this.sptIndex, ((GeometryFeature)this.activeFeature).getKey().toString());
            }
            if (this.snapInterPoint == null || this.snapInterPoint.getPointLocation() == 2) {
                this.snapInterPoint = null;
                this.featureLayer.setSnapPoint(null);
                return;
            }
            this.featureLayer.setSnapPoint(this.snapInterPoint.getPoint());
        }
        catch (Exception ex) {
            this.snapInterPoint = null;
            this.featureLayer.setSnapPoint(null);
        }
    }

    protected void mousePressed(MouseEvent evt) {
        if (this.targetLayer == null || this.activeFeature == null) {
            return;
        }
        JGeometry geom = ((GeometryFeature)this.activeFeature).getSpatialAttribute();
        if (this.snapInterPoint == null || geom == null) {
            this.featureLayer.setSnapPoint(null);
            this.geomFeature = null;
            this.dragPoint = null;
            return;
        }
        this.geomFeature = new GeometryFeature();
        this.geomFeature.setSpatialAttribute(geom);
        this.geomFeature.setKey(this.activeFeature.getKey());
        this.originalGeom = geom;
        this.dragPoint = null;
    }

    protected boolean mouseDragged(MouseEvent evt) {
        if (this.targetLayer == null || this.activeFeature == null) {
            return true;
        }
        if (this.snapInterPoint == null || this.geomFeature == null) {
            this.dragPoint = null;
            return true;
        }
        this.dragPoint = new Point2D.Double();
        try {
            this.canvas.getViewportTransform().inverseTransform(new Point2D.Double(evt.getX(), evt.getY()), this.dragPoint);
            JGeometry change = JGeometryUtil.moveVertex((JGeometry)this.originalGeom, (JGeometrySegmentPoint)this.snapInterPoint, (Point2D)this.dragPoint);
            if (change != null) {
                this.geomFeature.setSpatialAttribute(change);
            }
            this.featureLayer.setSnapPoint(this.dragPoint);
        }
        catch (Exception ex) {
            this.dragPoint = null;
            return true;
        }
        return false;
    }

    protected void mouseReleased(MouseEvent evt) {
        if (this.targetLayer == null || this.activeFeature == null || this.geomFeature == null) {
            return;
        }
        if (this.dragPoint == null) {
            return;
        }
        double wcTolerance = TransformUtils.getWCTolerance(this.snapInterPoint.getPoint(), 3, this.canvas.getViewportTransform());
        if (this.targetLayer instanceof GeometrySetLayer) {
            GeometryFeature selectedFeature = (GeometryFeature)this.activeFeature;
            GeometrySetLayer gl = (GeometrySetLayer)this.targetLayer;
            String keyColumn = gl.getIndexedDataSet().getDataSet().getKeyColumn();
            String key = selectedFeature.getAttribute(keyColumn).getValue().toString();
            JGeometrySegmentPoint[] linkSeg = null;
            linkSeg = ((IndexedGeometrySet)gl.getIndexedDataSet()).getSegmentPointOfFeatures(this.snapInterPoint.getPoint(), wcTolerance, false, false, false, true);
            if (linkSeg != null && linkSeg.length > 0) {
                try {
                    gl.moveVertexes(key, linkSeg, this.dragPoint);
                }
                catch (Exception ex) {
                    log.severe("(VertexMoveTool:mouseReleased) " + ex.getMessage());
                    ex.printStackTrace();
                }
            }
        } else if (this.targetLayer instanceof TopologyPrimitiveLayer) {
            try {
                int numPts = this.originalGeom.getOrdinatesArray().length / 2;
                int snapSegIndex = this.snapInterPoint.getSegment().getSegmentIndex();
                boolean isEndVertex = false;
                if (snapSegIndex == 0 && this.snapInterPoint.getPointLocation() == 0 || snapSegIndex == numPts - 2 && this.snapInterPoint.getPointLocation() == 1) {
                    isEndVertex = true;
                }
                GeometryFeature selectedFeature = (GeometryFeature)this.activeFeature;
                int edgeId = Integer.parseInt(selectedFeature.getKey().toString());
                if (!isEndVertex) {
                    JGeometry change = JGeometryUtil.moveVertex((JGeometry)this.originalGeom, (JGeometrySegmentPoint)this.snapInterPoint, (Point2D)this.dragPoint);
                    ((TopologyPrimitiveLayer)this.targetLayer).changeEdgeGeometry(edgeId, change);
                    selectedFeature.setSpatialAttribute(change);
                } else {
                    TopologyModel tpmodel = ((TopologyPrimitiveLayer)this.targetLayer).getIndexedTopologyModel().getTopologyModel();
                    Edge edge = tpmodel.getEdge(edgeId);
                    int nodeId = -1;
                    nodeId = snapSegIndex == 0 && this.snapInterPoint.getPointLocation() == 0 ? edge.getOriginNode() : edge.getEndNode();
                    ((TopologyPrimitiveLayer)this.targetLayer).moveNode(nodeId, this.dragPoint);
                    selectedFeature.setSpatialAttribute(tpmodel.getEdgeGeometry(edgeId));
                }
            }
            catch (Exception ex) {
                log.severe("(VertexMoveTool:mouseReleased) " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        this.clear();
    }

    public GeometryFeature getCurrentGeomObject() {
        return this.geomFeature;
    }

    @Override
    public void clear() {
        this.originalGeom = null;
        this.geomFeature = null;
        this.dragPoint = null;
        this.snapInterPoint = null;
        this.sptIndex = null;
        if (this.featureLayer != null) {
            this.featureLayer.setSnapPoint(null);
        }
    }

    @Override
    public void setCanvas(MapCanvas canvas) {
        this.canvas = canvas;
    }

    private double getWCTolerance(Point2D wcCenter) {
        double pxTolerance = 3.0;
        try {
            Point2D.Double xy = new Point2D.Double();
            this.canvas.getViewportTransform().transform(wcCenter, xy);
            Point2D.Double UL = new Point2D.Double();
            this.canvas.getViewportTransform().inverseTransform(new Point2D.Double(((Point2D)xy).getX() - pxTolerance, ((Point2D)xy).getY() - pxTolerance), UL);
            double dx = wcCenter.getX() - ((Point2D)UL).getX();
            double dy = ((Point2D)UL).getY() - wcCenter.getY();
            double wcTolerance = Math.sqrt(dx * dx + dy * dy);
            return wcTolerance;
        }
        catch (Exception ex) {
            return 0.0;
        }
    }

    public Layer getActiveFeatureLayer() {
        return this.featureLayer;
    }

    public void setFeatureLayer(ActiveFeaturesLayer featureLayer) {
        this.featureLayer = featureLayer;
    }
}

