/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.tools;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import oracle.maps.core.GeoObject;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.MapRegion;
import oracle.maps.geoobject.GeometryFeature;
import oracle.maps.layer.NewGeometryLayer;
import oracle.maps.layer.ui.ShapeDrawingLayer;
import oracle.maps.tools.BasicTool;
import oracle.maps.util.TransformUtils;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mdeditor.ui.ErrorDialog;
import oracle.mdeditor.ui.MainAppPanel;
import oracle.mdeditor.ui.NewGeomSelectPanel;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.edit.util.JGeometrySegmentPoint;
import oracle.spatial.edit.index.geometry.IndexedGeometrySet;
import oracle.spatial.edit.layer.GeometrySetLayer;
import oracle.spatial.geometry.JGeometry;

public class SplitPolygonTool
extends BasicTool
implements ChangeListener {
    private static final Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPEDITOR);
    private static int CLICKED_MODE = 0;
    private static int PRESSED_MODE = 1;
    private static int LINEAR_SEGMENT = 0;
    private static int ARC_SEGMENT = 1;
    private int startX = -999;
    private int startY = -999;
    private GeneralPath currentPath = null;
    private Vector<Vector<Point2D>> currentPathsWC = new Vector();
    private Vector<JGeometrySegmentPoint> segSnapPoints = new Vector();
    private int digitizeMode = CLICKED_MODE;
    private int segmentType = LINEAR_SEGMENT;
    private boolean isInAction = false;
    private boolean hasSplitLines = false;
    private Point lastPoint = null;
    private boolean islastActionMoveTo = false;
    private boolean startNewPathSeg = true;
    private NewGeometryLayer shapeTargetLayer = null;
    private Point2D snapPointWC = null;
    private Point snapPointDC = null;
    private GeometrySetLayer targetLayer = null;
    private GeoObject activeFeature = null;
    private JGeometrySegmentPoint snapInterPoint = null;
    private SplitFirstChange firstChange = null;
    private MainAppPanel mainApp = null;

    public SplitPolygonTool(MapCanvas canvas) {
        super(canvas);
        this.properties.setDefaultProperty("oracle.maps.core.Layer.name", "Split polygon");
    }

    @Override
    public void clear() {
        if (this.firstChange != null) {
            this.canvas.getUndoManager().trimEdits((UndoableEdit)this.firstChange, this.firstChange.getLastChange());
            this.firstChange = null;
        }
        this.currentPath = null;
        this.currentPathsWC.clear();
        this.segSnapPoints.clear();
        this.hasSplitLines = false;
        this.lastPoint = null;
        this.isInAction = false;
        this.islastActionMoveTo = false;
        this.snapPointDC = null;
        this.snapInterPoint = null;
        if (this.shapeTargetLayer != null) {
            this.shapeTargetLayer.setShape(this.currentPath);
        }
        this.updateGhostSegment(null);
    }

    @Override
    public void handleTheEvent(EventObject evt) {
        if (this.shapeTargetLayer == null) {
            return;
        }
        this.targetLayer = (GeometrySetLayer)this.canvas.getLayerManager().getLayerByTag("targetLayer");
        if (this.targetLayer == null) {
            return;
        }
        List<GeoObject> objs = this.targetLayer.getSelection();
        this.activeFeature = null;
        if (objs != null && objs.size() > 0) {
            this.activeFeature = objs.get(0);
        }
        if (this.activeFeature == null) {
            return;
        }
        AffineTransform xfm = this.canvas.getMapRegion().getViewportTransform();
        if (evt instanceof MouseEvent) {
            MouseEvent e = (MouseEvent)evt;
            int id = e.getID();
            if (id == 500) {
                int button = e.getButton();
                if (button == 3) {
                    return;
                }
                if (this.currentPath == null && this.snapInterPoint == null) {
                    return;
                }
                boolean tehIsLineTo = false;
                Point2D tehPoint = null;
                JGeometrySegmentPoint tehSegmentPoint = null;
                int pX = e.getX();
                int pY = e.getY();
                if (this.snapPointDC != null) {
                    pX = (int)this.snapPointDC.getX();
                    pY = (int)this.snapPointDC.getY();
                }
                if (this.currentPath == null) {
                    this.hasSplitLines = false;
                    this.currentPathsWC.clear();
                    this.startX = pX;
                    this.startY = pY;
                    this.currentPath = new GeneralPath();
                    this.isInAction = true;
                    this.currentPath.moveTo(pX, pY);
                    this.islastActionMoveTo = true;
                    Point2D wcPT = null;
                    if (this.snapInterPoint != null) {
                        wcPT = this.snapInterPoint.getPoint();
                    } else {
                        wcPT = new Point2D.Double();
                        try {
                            xfm.inverseTransform(new Point2D.Double(pX, pY), wcPT);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    Vector<Point2D> points = new Vector<Point2D>();
                    points.add(wcPT);
                    tehPoint = wcPT;
                    this.currentPathsWC.add(points);
                    JGeometrySegmentPoint segPT = new JGeometrySegmentPoint();
                    segPT.setId(this.snapInterPoint.getId());
                    segPT.setPoint(this.snapInterPoint.getPoint());
                    segPT.setPointLocation(this.snapInterPoint.getPointLocation());
                    segPT.setSegment(this.snapInterPoint.getSegment());
                    this.segSnapPoints.add(segPT);
                    tehSegmentPoint = segPT;
                } else if ((double)pX != this.lastPoint.getX() || (double)pY != this.lastPoint.getY()) {
                    int lastSubElement;
                    boolean isLineTo = true;
                    if (this.segSnapPoints.size() > 1 && this.snapInterPoint != null && this.segSnapPoints.size() % 2 == 0 && (lastSubElement = this.segSnapPoints.get(this.segSnapPoints.size() - 1).getSegment().getSubElementIndex()) == this.snapInterPoint.getSegment().getSubElementIndex()) {
                        isLineTo = false;
                    }
                    Point2D wcPT = null;
                    if (this.snapInterPoint != null) {
                        wcPT = this.snapInterPoint.getPoint();
                    } else {
                        wcPT = new Point2D.Double();
                        try {
                            xfm.inverseTransform(new Point2D.Double(pX, pY), wcPT);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    tehIsLineTo = isLineTo;
                    if (isLineTo) {
                        this.currentPath.lineTo(pX, pY);
                        this.islastActionMoveTo = false;
                    } else {
                        this.currentPath.moveTo(pX, pY);
                        this.islastActionMoveTo = true;
                        Vector points = new Vector();
                        this.currentPathsWC.add(points);
                    }
                    this.currentPathsWC.lastElement().add(wcPT);
                    tehPoint = wcPT;
                    if (this.snapInterPoint != null) {
                        this.segSnapPoints.add(this.snapInterPoint);
                        tehSegmentPoint = this.snapInterPoint;
                        if (this.segSnapPoints.size() > 1 && this.snapInterPoint.getSegment().getSubElementIndex() == this.segSnapPoints.get(0).getSegment().getSubElementIndex()) {
                            this.hasSplitLines = true;
                        }
                    }
                }
                this.lastPoint = new Point(pX, pY);
                this.shapeTargetLayer.setShape(this.currentPath);
                SplitPolygonUndoableEdit edit = new SplitPolygonUndoableEdit(tehIsLineTo, tehPoint, tehSegmentPoint);
                if (this.firstChange == null) {
                    edit.setSignificant(false);
                    this.firstChange = new SplitFirstChange();
                    this.canvas.getUndoManager().undoableEditHappened(new UndoableEditEvent(this, this.firstChange));
                }
                this.firstChange.setLastChange(edit);
                this.canvas.getUndoManager().undoableEditHappened(new UndoableEditEvent(this, edit));
                if (this.hasSplitLines()) {
                    this.finish();
                }
            } else if (id == 501) {
                if (this.digitizeMode != PRESSED_MODE) {
                    return;
                }
            } else if (id != 502) {
                if (id == 506) {
                    if (this.digitizeMode != PRESSED_MODE) {
                        return;
                    }
                } else if (id == 503) {
                    if (this.targetLayer == null || this.activeFeature == null) {
                        return;
                    }
                    try {
                        Point2D.Double center = new Point2D.Double();
                        this.canvas.getViewportTransform().inverseTransform(new Point2D.Double(e.getX(), e.getY()), center);
                        double wcTolerance = TransformUtils.getWCTolerance(center, 3, this.canvas.getViewportTransform());
                        GeometryFeature selectedFeature = (GeometryFeature)this.activeFeature;
                        GeometrySetLayer gl = this.targetLayer;
                        String keyColumn = gl.getIndexedDataSet().getDataSet().getKeyColumn();
                        String key = selectedFeature.getAttribute(keyColumn).getValue().toString();
                        this.snapInterPoint = ((IndexedGeometrySet)gl.getIndexedDataSet()).getSegmentPoint(key, new Point2D.Double(((Point2D)center).getX(), ((Point2D)center).getY()), wcTolerance, false, false, false, false);
                        if (this.snapInterPoint != null) {
                            if (this.segSnapPoints.size() == 0) {
                                if (this.snapInterPoint.getSegment().getSubElementIndex() != 0) {
                                    this.snapInterPoint = null;
                                }
                            } else if (this.segSnapPoints.size() == 1 && this.hasJustOnePoint() && this.segSnapPoints.get(0).getSegment().getSegmentIndex() == this.snapInterPoint.getSegment().getSegmentIndex()) {
                                this.snapInterPoint = null;
                            } else if (this.segSnapPoints.size() > 1) {
                                int lastSubElement;
                                if (this.segSnapPoints.size() % 2 == 0) {
                                    lastSubElement = this.segSnapPoints.get(this.segSnapPoints.size() - 1).getSegment().getSubElementIndex();
                                    if (lastSubElement != this.snapInterPoint.getSegment().getSubElementIndex()) {
                                        this.snapInterPoint = null;
                                    }
                                } else {
                                    lastSubElement = this.segSnapPoints.get(this.segSnapPoints.size() - 1).getSegment().getSubElementIndex();
                                    if (lastSubElement == this.snapInterPoint.getSegment().getSubElementIndex()) {
                                        this.snapInterPoint = null;
                                    }
                                }
                            }
                        }
                        if (this.snapInterPoint != null) {
                            Point2D interPoint = this.snapInterPoint.getPoint();
                            Point2D.Double xy = new Point2D.Double();
                            this.canvas.getViewportTransform().transform(interPoint, xy);
                            this.shapeTargetLayer.setSnapPoint(new Point((int)((Point2D)xy).getX(), (int)((Point2D)xy).getY()));
                            this.snapPointDC = new Point((int)((Point2D)xy).getX(), (int)((Point2D)xy).getY());
                            this.shapeTargetLayer.setCursorPoint(null);
                        } else {
                            this.shapeTargetLayer.setSnapPoint(null);
                            this.snapPointDC = null;
                            if (this.segSnapPoints.size() > 0) {
                                this.shapeTargetLayer.setCursorPoint(new Point(e.getX(), e.getY()));
                            } else {
                                this.shapeTargetLayer.setCursorPoint(null);
                            }
                        }
                        this.updateGhostSegment(new Point(e.getX(), e.getY()));
                    }
                    catch (Exception ex) {
                        this.snapInterPoint = null;
                        this.shapeTargetLayer.setSnapPoint(null);
                    }
                } else if (id == 505) {
                    this.updateGhostSegment(null);
                }
            }
        }
    }

    @Override
    public boolean isInAction() {
        return this.isInAction;
    }

    public ShapeDrawingLayer getShapeDrawingLayer() {
        return this.shapeTargetLayer;
    }

    public void setShapeDrawingLayer(NewGeometryLayer layer) {
        this.shapeTargetLayer = layer;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src instanceof MapRegion) {
            this.refreshPath();
        }
    }

    public boolean hasSplitLines() {
        return this.hasSplitLines;
    }

    public void updateGhostSegment(Point lastPT) {
        if (this.shapeTargetLayer != null && this.shapeTargetLayer instanceof NewGeometryLayer) {
            if (this.canvas == null || this.canvas.getMapRegion() == null || lastPT == null || !this.isInAction) {
                this.shapeTargetLayer.setGhostSegment(null);
                return;
            }
            AffineTransform xfm = this.canvas.getMapRegion().getViewportTransform();
            GeneralPath ghostSegment = null;
            if (this.currentPathsWC.size() > 0) {
                Vector<Point2D> points = this.currentPathsWC.lastElement();
                Point2D wcpt = points.get(points.size() - 1);
                ghostSegment = new GeneralPath();
                Point2D.Double dcpt = new Point2D.Double();
                if (xfm != null) {
                    xfm.transform(wcpt, dcpt);
                } else {
                    ((Point2D)dcpt).setLocation(wcpt.getX(), wcpt.getY());
                }
                ghostSegment.moveTo(((Point2D)dcpt).getX(), ((Point2D)dcpt).getY());
                ghostSegment.lineTo(lastPT.getX(), lastPT.getY());
            }
            this.shapeTargetLayer.setGhostSegment(ghostSegment);
        } else {
            this.shapeTargetLayer.setGhostSegment(null);
        }
    }

    private void refreshPath() {
        if (this.canvas == null || this.canvas.getMapRegion() == null) {
            return;
        }
        AffineTransform xfm = this.canvas.getMapRegion().getViewportTransform();
        this.islastActionMoveTo = false;
        if (this.currentPath != null && this.currentPathsWC.size() > 0) {
            this.currentPath = new GeneralPath();
            for (int i = 0; i < this.currentPathsWC.size(); ++i) {
                Vector<Point2D> points = this.currentPathsWC.get(i);
                Point2D wcpt = points.get(0);
                Point2D.Double dcpt = new Point2D.Double();
                if (xfm != null) {
                    xfm.transform(wcpt, dcpt);
                } else {
                    ((Point2D)dcpt).setLocation(wcpt.getX(), wcpt.getY());
                }
                this.startX = (int)((Point2D)dcpt).getX();
                this.startY = (int)((Point2D)dcpt).getY();
                this.currentPath.moveTo(((Point2D)dcpt).getX(), ((Point2D)dcpt).getY());
                this.lastPoint = new Point(this.startX, this.startY);
                this.islastActionMoveTo = true;
                for (int j = 1; j < points.size(); ++j) {
                    wcpt = points.get(j);
                    dcpt = new Point2D.Double();
                    if (xfm != null) {
                        xfm.transform(wcpt, dcpt);
                    } else {
                        ((Point2D)dcpt).setLocation(wcpt.getX(), wcpt.getY());
                    }
                    this.currentPath.lineTo(((Point2D)dcpt).getX(), ((Point2D)dcpt).getY());
                    this.islastActionMoveTo = false;
                    this.lastPoint = new Point((int)((Point2D)dcpt).getX(), (int)((Point2D)dcpt).getY());
                }
            }
            if (this.shapeTargetLayer != null) {
                this.shapeTargetLayer.setShape(this.currentPath);
                this.updateGhostSegment(this.lastPoint);
            }
        } else {
            this.currentPath = null;
            this.updateGhostSegment(null);
            this.isInAction = false;
            this.currentPath = null;
            if (this.shapeTargetLayer != null) {
                this.shapeTargetLayer.setShape(null);
            }
        }
    }

    public JGeometry[] getSplitLines() {
        if (this.currentPathsWC.size() == 0) {
            return null;
        }
        JGeometry[] output = new JGeometry[this.currentPathsWC.size()];
        for (int i = 0; i < this.currentPathsWC.size(); ++i) {
            Vector<Point2D> points = this.currentPathsWC.get(i);
            int[] einfo = new int[]{1, 2, 1};
            int dim = 2;
            double[] oords = new double[points.size() * dim];
            for (int j = 0; j < points.size(); ++j) {
                oords[j * dim] = points.get(j).getX();
                oords[j * dim + 1] = points.get(j).getY();
            }
            output[i] = new JGeometry(2002, this.targetLayer.getSRID(), einfo, oords);
        }
        return output;
    }

    private boolean hasJustOnePoint() {
        if (this.currentPathsWC.size() == 1) {
            Vector<Point2D> points = this.currentPathsWC.get(0);
            return points != null && points.size() == 1;
        }
        return false;
    }

    public JGeometrySegmentPoint[] getSplitPoints() {
        if (this.segSnapPoints.size() == 0) {
            return null;
        }
        return this.segSnapPoints.toArray(new JGeometrySegmentPoint[this.segSnapPoints.size()]);
    }

    public boolean canUndo() {
        return this.currentPath != null && this.currentPathsWC.size() != 0 && this.isInAction;
    }

    private void finish() {
        if (this.hasSplitLines()) {
            GeometrySetLayer gl = (GeometrySetLayer)this.getCanvas().getLayerManager().getLayerByTag("targetLayer");
            List<GeoObject> selected = gl.getSelection();
            if (selected == null || selected.size() == 0) {
                return;
            }
            GeometryFeature feature = (GeometryFeature)selected.get(0);
            if (feature == null) {
                return;
            }
            JGeometry geom = feature.getSpatialAttribute();
            if (geom == null || geom.getType() != 3 && geom.getType() != 7 && geom.getType() != 4) {
                return;
            }
            JGeometry[] geomElems = geom.getElements();
            if (geomElems == null || geomElems.length == 0) {
                return;
            }
            JGeometrySegmentPoint[] splitPoints = this.getSplitPoints();
            if (splitPoints == null || splitPoints.length == 0) {
                return;
            }
            JGeometry[] splitLines = this.getSplitLines();
            if (splitLines == null || splitLines.length == 0) {
                return;
            }
            JGeometry elem = geomElems[splitPoints[0].getSegment().getElementIndex()];
            JGeometry splitGeom = this.splitPolygon(elem, splitPoints, splitLines);
            if (splitGeom == null) {
                JOptionPane.showMessageDialog(this.canvas.getFrameForDialog(), MessagesBundle.getMessage("Unable_tosplit_polygon"), MessagesBundle.getMessage("Error"), 0);
            } else {
                JGeometry[] splitParts = splitGeom.getElements();
                NewGeomSelectPanel slctPnl = new NewGeomSelectPanel(splitParts[0], splitParts[1]);
                Field[] fields = gl.getFieldsForFeature(null, true, slctPnl);
                if (fields == null || fields.length == 0) {
                    this.clear();
                    return;
                }
                String keyColumn = gl.getIndexedDataSet().getDataSet().getKeyColumn();
                String key = feature.getAttribute(keyColumn).getValue().toString();
                try {
                    if (slctPnl.getLastSelected() == 2) {
                        gl.splitPolygon(key, splitPoints[0].getSegment().getElementIndex(), splitParts[0], splitParts[1], fields);
                    } else {
                        gl.splitPolygon(key, splitPoints[0].getSegment().getElementIndex(), splitParts[1], splitParts[0], fields);
                    }
                }
                catch (Exception ex) {
                    ErrorDialog.showErrorDialog(ex, this.canvas.getFrameForDialog(), MessagesBundle.getMessage("Unable_tosplit_polygon"), MessagesBundle.getMessage("Error"), 0);
                }
            }
        }
        this.clear();
    }

    private JGeometry splitPolygon(JGeometry geom, JGeometrySegmentPoint[] segPoints, JGeometry[] splitLines) {
        int i;
        int i2;
        int l;
        int spdim;
        double[] spoords;
        int i3;
        if (geom == null || segPoints == null || segPoints.length == 0 || splitLines == null || splitLines.length == 0) {
            return null;
        }
        int gtype = geom.getType();
        if (gtype == 1 || gtype == 5 || gtype == 2 || gtype == 7 || gtype == 6 || gtype == 4) {
            return null;
        }
        int numSegPoints = segPoints.length;
        if (numSegPoints == 0 || numSegPoints % 2 != 0) {
            log.warning("# of intersection split points must be even.");
            return null;
        }
        if (segPoints[0].getSegment().getElementIndex() != segPoints[numSegPoints - 1].getSegment().getElementIndex()) {
            log.warning("First split point element is not the same as the last split point element.");
            return null;
        }
        if (segPoints.length > 2) {
            for (i3 = 1; i3 < numSegPoints - 1; i3 += 2) {
                if (segPoints[i3].getSegment().getSubElementIndex() == segPoints[i3 + 1].getSegment().getSubElementIndex()) continue;
                log.warning("Void element [" + segPoints[i3].getSegment().getSubElementIndex() + "] of split point [" + i3 + "] is not the same as void element [" + segPoints[i3 + 1].getSegment().getSubElementIndex() + "] of split point [" + (i3 + 1) + "].");
                return null;
            }
        }
        for (i3 = 0; i3 < splitLines.length; ++i3) {
            int spdim2 = splitLines[0].getDimensions();
            double[] spoords2 = splitLines[i3].getOrdinatesArray();
            if (spoords2 != null && spoords2.length / spdim2 >= 2) continue;
            log.warning("Split line [" + i3 + "] has less than two points.");
            return null;
        }
        int dim = geom.getDimensions();
        JGeometry elem = geom;
        if (elem == null || elem.getType() != 3) {
            return null;
        }
        double[] oords = elem.getOrdinatesArray();
        int[] einfo = elem.getElemInfo();
        if (einfo == null || oords == null) {
            return null;
        }
        boolean compoundPolygon = false;
        if (elem.getElemInfo()[1] == 1005) {
            compoundPolygon = true;
        }
        if (compoundPolygon) {
            log.warning("Compound polygon not supported in split method.");
            return null;
        }
        if (elem.getElemInfo()[2] == 3) {
            log.warning("Optimized rectangle is not supported in split method.");
            return null;
        }
        int firstloc = segPoints[0].getPointLocation();
        int lastloc = segPoints[numSegPoints - 1].getPointLocation();
        int firstsegIndex = segPoints[0].getSegment().getSegmentIndex();
        int lastsegIndex = segPoints[numSegPoints - 1].getSegment().getSegmentIndex();
        if (segPoints[0].getPoint().getX() == segPoints[numSegPoints - 1].getPoint().getX() && segPoints[0].getPoint().getY() == segPoints[numSegPoints - 1].getPoint().getY()) {
            log.warning("First and last split points cannot be the same.");
            return null;
        }
        if (segPoints.length > 2) {
            for (int i4 = 1; i4 < numSegPoints - 2; i4 += 2) {
                if (segPoints[i4].getPoint().getX() != segPoints[i4 + 1].getPoint().getX() || segPoints[i4].getPoint().getY() != segPoints[i4 + 1].getPoint().getY()) continue;
                log.warning("Split point [" + i4 + "] cannot be the same as " + "split point [" + (i4 + 1) + "].");
                return null;
            }
        }
        int npts = oords.length / dim;
        int nsegs = npts - 1;
        int nelems = einfo.length / 3;
        int lastoordIndex = oords.length - 1;
        if (nelems > 1) {
            lastoordIndex = einfo[3] - 2;
        }
        boolean sameSeg = false;
        double dist1 = Double.NaN;
        double dist2 = Double.NaN;
        if (firstsegIndex == lastsegIndex) {
            sameSeg = true;
            Point2D pts1 = segPoints[0].getPoint();
            Point2D pts2 = segPoints[numSegPoints - 1].getPoint();
            double x = oords[firstsegIndex * dim];
            double y = oords[firstsegIndex * dim + 1];
            double deltax1 = pts1.getX() - x;
            double deltay1 = pts1.getY() - y;
            dist1 = Math.sqrt(deltax1 * deltax1 + deltay1 * deltay1);
            double deltax2 = pts2.getX() - x;
            double deltay2 = pts2.getY() - y;
            dist2 = Math.sqrt(deltax2 * deltax2 + deltay2 * deltay2);
        }
        ArrayList<Double> firstPart = new ArrayList<Double>();
        ArrayList<Double> secondPart = new ArrayList<Double>();
        JGeometry[] fullSplitLines = this.buildFullSplitLines(geom, segPoints, splitLines);
        int start = -1;
        int end = -1;
        if (firstsegIndex < lastsegIndex || sameSeg && dist1 < dist2) {
            if (firstloc == 0) {
                start = firstsegIndex * dim;
            } else if (firstloc == 1) {
                start = (firstsegIndex + 1) * dim;
            } else {
                start = (firstsegIndex + 1) * dim;
                firstPart.add(new Double(segPoints[0].getPoint().getX()));
                firstPart.add(new Double(segPoints[0].getPoint().getY()));
            }
            if (lastloc == 0 || lastloc == 2) {
                end = lastsegIndex * dim + dim;
            } else if (lastloc == 1) {
                end = (lastsegIndex + 1) * dim + dim;
            }
            if (sameSeg && firstloc == 2 && lastloc == 2) {
                end = start;
            }
            for (int i5 = start; i5 < end; ++i5) {
                firstPart.add(new Double(oords[i5]));
            }
            if (lastloc == 2) {
                firstPart.add(new Double(segPoints[numSegPoints - 1].getPoint().getX()));
                firstPart.add(new Double(segPoints[numSegPoints - 1].getPoint().getY()));
            }
            spoords = fullSplitLines[0].getOrdinatesArray();
            spdim = fullSplitLines[0].getDimensions();
            for (l = spoords.length - dim; l > 0; l -= spdim) {
                firstPart.add(new Double(spoords[l - spdim]));
                firstPart.add(new Double(spoords[l - spdim + 1]));
            }
            if (lastloc == 0) {
                start = lastsegIndex * dim;
            } else if (lastloc == 1) {
                start = (lastsegIndex + 1) * dim;
            } else {
                start = (lastsegIndex + 1) * dim;
                secondPart.add(new Double(segPoints[numSegPoints - 1].getPoint().getX()));
                secondPart.add(new Double(segPoints[numSegPoints - 1].getPoint().getY()));
            }
            end = lastoordIndex + 1;
            for (i2 = start; i2 < end; ++i2) {
                secondPart.add(new Double(oords[i2]));
            }
            start = dim;
            if (firstloc == 0 || firstloc == 2) {
                end = firstsegIndex * dim + dim;
            } else if (firstloc == 1) {
                end = (firstsegIndex + 1) * dim + dim;
            }
            for (i2 = start; i2 < end; ++i2) {
                secondPart.add(new Double(oords[i2]));
            }
            if (firstloc == 2) {
                secondPart.add(new Double(segPoints[0].getPoint().getX()));
                secondPart.add(new Double(segPoints[0].getPoint().getY()));
            }
            spoords = fullSplitLines[1].getOrdinatesArray();
            spdim = fullSplitLines[1].getDimensions();
            for (l = dim; l < spoords.length; l += spdim) {
                secondPart.add(new Double(spoords[l]));
                secondPart.add(new Double(spoords[l + 1]));
            }
        } else if (firstsegIndex > lastsegIndex || sameSeg && dist1 > dist2) {
            if (lastloc == 0) {
                start = lastsegIndex * dim;
            } else if (lastloc == 1) {
                start = (lastsegIndex + 1) * dim;
            } else {
                start = (lastsegIndex + 1) * dim;
                firstPart.add(new Double(segPoints[numSegPoints - 1].getPoint().getX()));
                firstPart.add(new Double(segPoints[numSegPoints - 1].getPoint().getY()));
            }
            if (firstloc == 0 || firstloc == 2) {
                end = firstsegIndex * dim + dim;
            } else if (firstloc == 1) {
                end = (firstsegIndex + 1) * dim + dim;
            }
            for (int i6 = start; i6 < end; ++i6) {
                firstPart.add(new Double(oords[i6]));
            }
            if (firstloc == 2) {
                firstPart.add(new Double(segPoints[0].getPoint().getX()));
                firstPart.add(new Double(segPoints[0].getPoint().getY()));
            }
            spoords = fullSplitLines[0].getOrdinatesArray();
            spdim = fullSplitLines[0].getDimensions();
            for (l = dim; l < spoords.length; l += spdim) {
                firstPart.add(new Double(spoords[l]));
                firstPart.add(new Double(spoords[l + 1]));
            }
            if (firstloc == 0) {
                start = firstsegIndex * dim;
            } else if (firstloc == 1) {
                start = (firstsegIndex + 1) * dim;
            } else {
                start = (firstsegIndex + 1) * dim;
                secondPart.add(new Double(segPoints[0].getPoint().getX()));
                secondPart.add(new Double(segPoints[0].getPoint().getY()));
            }
            end = lastoordIndex + 1;
            for (i2 = start; i2 < end; ++i2) {
                secondPart.add(new Double(oords[i2]));
            }
            start = dim;
            if (lastloc == 0 || lastloc == 2) {
                end = lastsegIndex * dim + dim;
            } else if (lastloc == 1) {
                end = (lastsegIndex + 1) * dim + dim;
            }
            for (i2 = start; i2 < end; ++i2) {
                secondPart.add(new Double(oords[i2]));
            }
            if (lastloc == 2) {
                secondPart.add(new Double(segPoints[numSegPoints - 1].getPoint().getX()));
                secondPart.add(new Double(segPoints[numSegPoints - 1].getPoint().getY()));
            }
            spoords = fullSplitLines[1].getOrdinatesArray();
            spdim = fullSplitLines[1].getDimensions();
            for (l = spoords.length - dim; l > 0; l -= spdim) {
                secondPart.add(new Double(spoords[l - spdim]));
                secondPart.add(new Double(spoords[l - spdim + 1]));
            }
        } else {
            return null;
        }
        int outType = 7;
        int[] elemInfo = new int[]{1, 1003, 1, firstPart.size() + 1, 1003, 1};
        double[] ordinates = new double[firstPart.size() + secondPart.size()];
        for (i = 0; i < firstPart.size(); ++i) {
            ordinates[i] = (Double)firstPart.get(i);
        }
        for (i = 0; i < secondPart.size(); ++i) {
            ordinates[i + firstPart.size()] = (Double)secondPart.get(i);
        }
        return new JGeometry(outType + geom.getDimensions() * 1000, geom.getSRID(), elemInfo, ordinates);
    }

    private JGeometry[] buildFullSplitLines(JGeometry geom, JGeometrySegmentPoint[] segPoints, JGeometry[] splitLines) {
        if (geom == null || segPoints == null || splitLines == null) {
            return null;
        }
        if (segPoints.length < 2 || splitLines.length == 0) {
            return null;
        }
        JGeometry[] fullSplitLines = new JGeometry[2];
        if (segPoints.length == 2) {
            fullSplitLines[0] = splitLines[0];
            fullSplitLines[1] = splitLines[0];
        } else {
            int i;
            int currentSplitLineIndex;
            double[] spoords;
            ArrayList<Double> firstPart = new ArrayList<Double>();
            ArrayList<Double> secondPart = new ArrayList<Double>();
            int dim = geom.getDimensions();
            int[] einfo = geom.getElemInfo();
            int nelems = einfo.length / 3;
            double[] oords = geom.getOrdinatesArray();
            int geomFirstSegIndex = segPoints[0].getSegment().getSegmentIndex();
            int geomLastSegIndex = segPoints[segPoints.length - 1].getSegment().getSegmentIndex();
            boolean geomSameSeg = false;
            double geomDist1 = Double.NaN;
            double geomDist2 = Double.NaN;
            if (geomFirstSegIndex == geomLastSegIndex) {
                geomSameSeg = true;
                Point2D pts1 = segPoints[0].getPoint();
                Point2D pts2 = segPoints[segPoints.length - 1].getPoint();
                double x = oords[geomFirstSegIndex * dim];
                double y = oords[geomLastSegIndex * dim + 1];
                double deltax1 = pts1.getX() - x;
                double deltay1 = pts1.getY() - y;
                geomDist1 = Math.sqrt(deltax1 * deltax1 + deltay1 * deltay1);
                double deltax2 = pts2.getX() - x;
                double deltay2 = pts2.getY() - y;
                geomDist2 = Math.sqrt(deltax2 * deltax2 + deltay2 * deltay2);
            }
            if ((spoords = splitLines[currentSplitLineIndex = 0].getOrdinatesArray()) == null || spoords.length == 0) {
                return null;
            }
            for (i = 0; i < spoords.length; ++i) {
                firstPart.add(new Double(spoords[i]));
                secondPart.add(new Double(spoords[i]));
            }
            for (i = 1; i < segPoints.length - 1; i += 2) {
                ++currentSplitLineIndex;
                int firstloc = segPoints[i].getPointLocation();
                int lastloc = segPoints[i + 1].getPointLocation();
                int firstsegIndex = segPoints[i].getSegment().getSegmentIndex();
                int lastsegIndex = segPoints[i + 1].getSegment().getSegmentIndex();
                int subelemIndex = segPoints[i].getSegment().getSubElementIndex();
                int startoordpos = einfo[3 * subelemIndex] - 1;
                int endoordpos = oords.length - 1;
                if (subelemIndex + 1 < nelems) {
                    endoordpos = einfo[3 * (subelemIndex + 1)] - 1;
                }
                int numOords = endoordpos - startoordpos + 1;
                boolean sameSeg = false;
                double dist1 = Double.NaN;
                double dist2 = Double.NaN;
                if (firstsegIndex == lastsegIndex) {
                    sameSeg = true;
                    Point2D pts1 = segPoints[i].getPoint();
                    Point2D pts2 = segPoints[i + 1].getPoint();
                    double x = oords[firstsegIndex * dim + startoordpos];
                    double y = oords[firstsegIndex * dim + 1 + startoordpos];
                    double deltax1 = pts1.getX() - x;
                    double deltay1 = pts1.getY() - y;
                    dist1 = Math.sqrt(deltax1 * deltax1 + deltay1 * deltay1);
                    double deltax2 = pts2.getX() - x;
                    double deltay2 = pts2.getY() - y;
                    dist2 = Math.sqrt(deltax2 * deltax2 + deltay2 * deltay2);
                }
                int start = -1;
                int end = -1;
                if (geomFirstSegIndex < geomLastSegIndex || geomSameSeg && geomDist1 < geomDist2) {
                    if (firstsegIndex < lastsegIndex || sameSeg && dist1 > dist2) {
                        if (!sameSeg) {
                            int k;
                            start = firstloc == 1 || firstloc == 2 ? firstsegIndex * dim : (firstsegIndex - 1) * dim;
                            for (k = start; k > 0; k -= 2) {
                                firstPart.add(new Double(oords[startoordpos + k]));
                                firstPart.add(new Double(oords[startoordpos + k + 1]));
                            }
                            end = lastloc == 0 || lastloc == 2 ? lastsegIndex * dim : (lastsegIndex + 1) * dim;
                            for (k = numOords - 2; k > end; k -= 2) {
                                firstPart.add(new Double(oords[startoordpos + k]));
                                firstPart.add(new Double(oords[startoordpos + k + 1]));
                            }
                            start = firstloc == 0 || firstloc == 2 ? (firstsegIndex + 1) * dim : (firstsegIndex + 2) * dim;
                            end = lastloc == 1 || lastloc == 2 ? (lastsegIndex + 1) * dim : lastsegIndex * dim;
                            for (k = start; k < end; k += 2) {
                                secondPart.add(new Double(oords[startoordpos + k]));
                                secondPart.add(new Double(oords[startoordpos + k + 1]));
                            }
                        } else {
                            int k;
                            start = firstloc == 2 ? (firstsegIndex + 1) * dim : (firstsegIndex + 2) * dim;
                            for (k = start; k < numOords - dim; k += 2) {
                                secondPart.add(new Double(oords[startoordpos + k]));
                                secondPart.add(new Double(oords[startoordpos + k + 1]));
                            }
                            end = lastloc == 2 ? (lastsegIndex + 1) * dim : lastsegIndex * dim;
                            for (k = 0; k < end; k += 2) {
                                secondPart.add(new Double(oords[startoordpos + k]));
                                secondPart.add(new Double(oords[startoordpos + k + 1]));
                            }
                        }
                    } else if (firstsegIndex > lastsegIndex || sameSeg && dist1 < dist2) {
                        int k;
                        start = firstloc == 1 || firstloc == 2 ? firstsegIndex * dim : (firstsegIndex - 1) * dim;
                        end = lastloc == 0 || lastloc == 2 ? lastsegIndex * dim : (lastsegIndex + 1) * dim;
                        for (k = start; k > end; k -= dim) {
                            firstPart.add(new Double(oords[startoordpos + k]));
                            firstPart.add(new Double(oords[startoordpos + k + 1]));
                        }
                        start = firstloc == 0 || firstloc == 2 ? (firstsegIndex + 1) * dim : (firstsegIndex + 2) * dim;
                        for (k = start; k < numOords - 2; k += dim) {
                            secondPart.add(new Double(oords[startoordpos + k]));
                            secondPart.add(new Double(oords[startoordpos + k + 1]));
                        }
                        end = lastloc == 1 || lastloc == 2 ? (lastsegIndex + 1) * dim : lastsegIndex * dim;
                        for (k = 0; k < end; k += dim) {
                            secondPart.add(new Double(oords[startoordpos + k]));
                            secondPart.add(new Double(oords[startoordpos + k + 1]));
                        }
                    }
                } else if (geomFirstSegIndex > geomLastSegIndex || geomSameSeg && geomDist1 > geomDist2) {
                    if (firstsegIndex < lastsegIndex || sameSeg && dist1 > dist2) {
                        int k;
                        start = firstloc == 0 || firstloc == 2 ? (firstsegIndex + 1) * dim : (firstsegIndex + 2) * dim;
                        end = lastloc == 1 || lastloc == 2 ? (lastsegIndex + 1) * dim : lastsegIndex * dim;
                        for (k = start; k < end; k += 2) {
                            firstPart.add(new Double(oords[startoordpos + k]));
                            firstPart.add(new Double(oords[startoordpos + k + 1]));
                        }
                        start = firstloc == 1 || firstloc == 2 ? firstsegIndex * dim : (firstsegIndex - 1) * dim;
                        for (k = start; k > 0; k -= 2) {
                            secondPart.add(new Double(oords[startoordpos + k]));
                            secondPart.add(new Double(oords[startoordpos + k + 1]));
                        }
                        end = lastloc == 0 || lastloc == 2 ? lastsegIndex * dim : (lastsegIndex + 1) * dim;
                        for (k = numOords - dim; k > end; k -= 2) {
                            secondPart.add(new Double(oords[startoordpos + k]));
                            secondPart.add(new Double(oords[startoordpos + k + 1]));
                        }
                    } else if (firstsegIndex > lastsegIndex || sameSeg && dist1 < dist2) {
                        int k;
                        start = firstloc == 0 || firstloc == 2 ? (firstsegIndex + 1) * dim : (firstsegIndex + 2) * dim;
                        for (k = start; k < numOords - 1 - dim; k += 2) {
                            firstPart.add(new Double(oords[startoordpos + k]));
                            firstPart.add(new Double(oords[startoordpos + k + 1]));
                        }
                        end = lastloc == 1 || lastloc == 2 ? (lastsegIndex + 1) * dim : lastsegIndex * dim;
                        for (k = 0; k < end; k += 2) {
                            firstPart.add(new Double(oords[startoordpos + k]));
                            firstPart.add(new Double(oords[startoordpos + k + 1]));
                        }
                        start = firstloc == 1 || firstloc == 2 ? firstsegIndex * dim : (firstsegIndex - 1) * dim;
                        end = lastloc == 0 || lastloc == 2 ? lastsegIndex * dim : (lastsegIndex + 1) * dim;
                        for (k = start; k > end; k -= 2) {
                            secondPart.add(new Double(oords[startoordpos + k]));
                            secondPart.add(new Double(oords[startoordpos + k + 1]));
                        }
                    }
                }
                spoords = splitLines[currentSplitLineIndex].getOrdinatesArray();
                for (int k = 0; k < spoords.length; ++k) {
                    firstPart.add(new Double(spoords[k]));
                    secondPart.add(new Double(spoords[k]));
                }
            }
            int outType = 2;
            int[] elemInfo0 = new int[]{1, 2, 1};
            double[] ordinates0 = new double[firstPart.size()];
            for (int i2 = 0; i2 < firstPart.size(); ++i2) {
                ordinates0[i2] = (Double)firstPart.get(i2);
            }
            fullSplitLines[0] = new JGeometry(outType + geom.getDimensions() * 1000, geom.getSRID(), elemInfo0, ordinates0);
            int[] elemInfo1 = new int[]{1, 2, 1};
            double[] ordinates1 = new double[secondPart.size()];
            for (int i3 = 0; i3 < secondPart.size(); ++i3) {
                ordinates1[i3] = (Double)secondPart.get(i3);
            }
            fullSplitLines[1] = new JGeometry(outType + geom.getDimensions() * 1000, geom.getSRID(), elemInfo1, ordinates1);
        }
        return fullSplitLines;
    }

    public void setMainApp(MainAppPanel mainApp) {
        this.mainApp = mainApp;
    }

    private class SplitPolygonUndoableEdit
    extends AbstractUndoableEdit {
        private boolean isLineTo = false;
        private Point2D point = null;
        private JGeometrySegmentPoint segPt = null;
        private boolean significant = true;

        public SplitPolygonUndoableEdit(boolean isLineTo, Point2D point, JGeometrySegmentPoint segPt) {
            this.isLineTo = isLineTo;
            this.point = new Point2D.Double(point.getX(), point.getY());
            this.segPt = segPt;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            if (SplitPolygonTool.this.currentPath == null || SplitPolygonTool.this.currentPathsWC.size() == 0 || !SplitPolygonTool.this.isInAction) {
                return;
            }
            ((Vector)SplitPolygonTool.this.currentPathsWC.lastElement()).remove(((Vector)SplitPolygonTool.this.currentPathsWC.lastElement()).size() - 1);
            if (((Vector)SplitPolygonTool.this.currentPathsWC.lastElement()).size() == 0) {
                SplitPolygonTool.this.currentPathsWC.remove(SplitPolygonTool.this.currentPathsWC.size() - 1);
                SplitPolygonTool.this.segSnapPoints.remove(SplitPolygonTool.this.segSnapPoints.size() - 1);
            }
            SplitPolygonTool.this.refreshPath();
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            if (SplitPolygonTool.this.currentPath == null) {
                SplitPolygonTool.this.currentPath = new GeneralPath();
            }
            if (!this.isLineTo()) {
                Vector points = new Vector();
                SplitPolygonTool.this.currentPathsWC.add(points);
            }
            ((Vector)SplitPolygonTool.this.currentPathsWC.lastElement()).add(this.point);
            if (this.segPt != null) {
                SplitPolygonTool.this.segSnapPoints.add(this.segPt);
            }
            SplitPolygonTool.this.refreshPath();
        }

        public boolean isLineTo() {
            return this.isLineTo;
        }

        public Point2D getPoint() {
            return this.point;
        }

        public void setSignificant(boolean significant) {
            this.significant = significant;
        }

        @Override
        public boolean isSignificant() {
            return this.significant;
        }
    }

    private class SplitFirstChange
    extends AbstractUndoableEdit {
        private UndoableEdit lastChange = null;

        private SplitFirstChange() {
        }

        @Override
        public void undo() {
            super.undo();
            if (this.lastChange == null) {
                throw new CannotUndoException();
            }
            SplitPolygonTool.this.clear();
        }

        @Override
        public void redo() {
            throw new CannotRedoException();
        }

        public void setLastChange(UndoableEdit lastChange) {
            this.lastChange = lastChange;
        }

        public UndoableEdit getLastChange() {
            return this.lastChange;
        }
    }
}

