/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.producer;

import java.awt.geom.Rectangle2D;
import java.util.Properties;
import oracle.maps.producer.SDOAbstractVectorProducer;

public class VectorThemeProducer
extends SDOAbstractVectorProducer {
    protected String keyColumn;

    public VectorThemeProducer(String mapViewerUrl, String dataSrc, String theme) {
        this.setMapViewerUrl(mapViewerUrl);
        this.mapViewerDataSource = dataSrc;
        this.themeName = theme;
        Properties props = new Properties();
        props.put("serverURL", mapViewerUrl);
        props.put("dataSource", dataSrc);
        this.currentDataMBR = new Rectangle2D.Double(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public String generateRequestUrl(Rectangle2D queryWindow) {
        String requestUrl = this.mapViewerUrl + "/dataserver/" + this.mapViewerDataSource + "?" + "t=" + this.themeName;
        if (queryWindow != null && !Double.isInfinite(queryWindow.getWidth()) && !Double.isInfinite(queryWindow.getHeight())) {
            requestUrl = requestUrl + "&bbox=" + queryWindow.getMinX() + "," + queryWindow.getMinY() + "," + queryWindow.getMaxX() + "," + queryWindow.getMaxY();
        }
        return requestUrl;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public void setKeyColumn(String keyColumn) {
        this.keyColumn = keyColumn;
    }
}

