/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.producer;

import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import oracle.maps.core.DataProducer;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.maps.geoobject.WorkSpace;
import oracle.maps.layer.ui.ProgressIndicatorLayer;
import oracle.maps.producer.SDODataProducer;
import oracle.maps.util.MDSClientUtils;
import oracle.mapviewer.share.util.LogFactory;
import oracle.sdovis.util.HttpConnection;

public abstract class SDOAbstractVectorProducer
implements SDODataProducer {
    private static final Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPEDITOR);
    protected Layer layer;
    protected int targetSrid = 8307;
    protected Rectangle2D currentDataMBR;
    protected String mapViewerUrl;
    protected String mapViewerDataSource;
    protected String themeName;
    protected GeoObject[] cachedData;
    protected Thread getterThread = null;
    protected boolean ignoreException = false;
    protected WorkSpace workspace = null;

    @Override
    public void setTargetWorkspace(WorkSpace workspace) {
        this.workspace = workspace;
    }

    @Override
    public WorkSpace getTargetWorkspace() {
        return this.workspace;
    }

    @Override
    public GeoObject[] getData() {
        return this.cachedData;
    }

    @Override
    public void clear() {
        this.cachedData = null;
    }

    @Override
    public void setTargetSRID(int srid) {
        this.targetSrid = srid;
    }

    @Override
    public int getTargetSRID() {
        return this.targetSrid;
    }

    @Override
    public Rectangle2D getDataMBR() {
        return this.currentDataMBR;
    }

    @Override
    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    @Override
    public Layer getLayer() {
        return this.layer;
    }

    public String getMapViewerDataSource() {
        return this.mapViewerDataSource;
    }

    public void setMapViewerDataSource(String mapViewerDataSource) {
        this.mapViewerDataSource = mapViewerDataSource;
    }

    public String getMapViewerUrl() {
        return this.mapViewerUrl;
    }

    public void setMapViewerUrl(String mapViewerUrl) {
        this.checkUrl(mapViewerUrl);
    }

    private void checkUrl(String mvUrl) {
        if (mvUrl.endsWith("/mapviewer")) {
            this.mapViewerUrl = mvUrl;
        } else {
            int idx = mvUrl.indexOf("/mapviewer");
            this.mapViewerUrl = mvUrl.substring(0, idx + "/mapviewer".length());
        }
    }

    public String getThemeName() {
        return this.themeName;
    }

    public void setThemeName(String themeName) {
        this.themeName = themeName;
    }

    @Override
    public void loadData(Rectangle2D queryWin, int qwSrid) {
        this.getterThread = new DataGetterThread(queryWin, this);
        this.getterThread.start();
    }

    @Override
    public void loadData(Area queryArea, int qwSrid) {
        this.loadData(queryArea.getBounds2D(), qwSrid);
    }

    @Override
    public void abortLoad() {
        if (this.getterThread != null) {
            this.ignoreException = true;
            this.getterThread.interrupt();
            this.ignoreException = false;
        }
    }

    protected abstract String generateRequestUrl(Rectangle2D var1);

    protected class DataGetterThread
    extends Thread {
        private DataProducer parent;
        private String requestUrl;

        public DataGetterThread(Rectangle2D queryWindow, DataProducer parent) {
            this.parent = parent;
            this.requestUrl = SDOAbstractVectorProducer.this.generateRequestUrl(queryWindow);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                log.info("Data loading: started...");
                ProgressIndicatorLayer prog = SDOAbstractVectorProducer.this.layer.getCanvas().getProgressIndicator();
                prog.taskStarted();
                long t1 = System.currentTimeMillis();
                log.finest("Request: " + this.requestUrl);
                HttpConnection conn = new HttpConnection();
                conn.connect(this.requestUrl);
                String jsessionid = SDOAbstractVectorProducer.this.layer.getProperty("oracle.lbs.mapviewer.jsessionID");
                if (jsessionid != null && !jsessionid.trim().isEmpty()) {
                    conn.setRequestProperty("Cookie", "JSESSIONID=" + jsessionid);
                }
                long t_ = System.currentTimeMillis();
                String response = conn.getGZIPXMLResponse();
                long t2_ = System.currentTimeMillis();
                SDOAbstractVectorProducer.this.cachedData = MDSClientUtils.parseMDSResponse(response, SDOAbstractVectorProducer.this.layer, SDOAbstractVectorProducer.this.currentDataMBR);
                long t2 = System.currentTimeMillis();
                log.info("Data loading from server: " + (t2_ - t_) + " ms.");
                log.info("Data parsing: " + (t2 - t2_) + " ms.");
                log.info("Data loading total time " + (t2 - t1) + " ms.");
                if (!this.isInterrupted()) {
                    // empty if block
                }
            }
            catch (Exception ex) {
                if (!SDOAbstractVectorProducer.this.ignoreException) {
                    // empty if block
                }
            }
            finally {
                ProgressIndicatorLayer prog = SDOAbstractVectorProducer.this.layer.getCanvas().getProgressIndicator();
                prog.taskCompleted();
            }
        }
    }
}

