/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.layer.ui;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.MapRegionEvent;
import oracle.maps.graphics.SpinningClock;
import oracle.maps.layer.BasicLayer;
import oracle.mapviewer.share.util.LogFactory;

public class ProgressIndicatorLayer
extends BasicLayer {
    private static final Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPEDITOR);
    private int taskCount = 0;
    private Point2D topLeftCorner;
    SpinningClock clock = new SpinningClock();
    ArrayList<String> active = new ArrayList();

    public ProgressIndicatorLayer(MapCanvas canvas) {
        super(canvas);
        this.properties.setDefaultProperty("oracle.maps.core.Layer.name", "Progress Indicator Layer");
        this.topLeftCorner = new Point2D.Float(0.0f, 0.0f);
        this.clock.setTopLeftCorner(this.topLeftCorner);
    }

    public synchronized void taskStarted() {
        ++this.taskCount;
        StackTraceElement[] st = new Exception().getStackTrace();
        this.active.add(0, st[1].toString());
    }

    public synchronized void taskCompleted() {
        --this.taskCount;
        this.active.remove(0);
    }

    private void showActive() {
        for (String a : this.active) {
            log.info(a);
        }
    }

    @Override
    public void update(long elapsedTime) {
        this.clock.update(elapsedTime);
    }

    @Override
    public boolean handleEvent(EventObject evt) {
        if (this.taskCount > 0) {
            this.canvas.setCursor(Cursor.getPredefinedCursor(3));
            JPopupMenu menu = this.canvas.getPopupMenu();
            if (menu != null) {
                JMenuItem mi = new JMenuItem("See active processes");
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ProgressIndicatorLayer.this.showActive();
                    }
                });
                menu.add(mi);
            }
        }
        return true;
    }

    @Override
    public void mapRegionChanged(MapRegionEvent e) {
        int w = this.canvas.getWidth();
        int h = this.canvas.getHeight();
        this.topLeftCorner.setLocation((double)w / 2.0 - (double)this.clock.getClockWidth() / 2.0, (double)h / 2.0 - (double)this.clock.getClockHeight() / 2.0 - 30.0);
        this.clock.setTopLeftCorner(this.topLeftCorner);
    }

    @Override
    public long render(Graphics2D g) {
        if (this.taskCount <= 0) {
            return 0L;
        }
        AffineTransform oldXfm = g.getTransform();
        g.setTransform(new AffineTransform());
        long res = this.clock.render(g);
        g.setTransform(oldXfm);
        return res;
    }

    public synchronized void reset() {
        this.taskCount = 0;
    }
}

