/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.layer;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import oracle.maps.core.Drawable;
import oracle.maps.core.Layer;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.MapUndoManager;
import oracle.maps.graphics.AnimatedStroke;
import oracle.maps.layer.BasicLayer;
import oracle.maps.layer.ui.ShapeDrawingLayer;
import oracle.maps.tools.Tool;

public class NewGeometryLayer
extends BasicLayer
implements ShapeDrawingLayer {
    private Drawable drawable = null;
    private Vector<Point> vertexes = new Vector();
    private Point cursorPoint = null;
    private Point snapPoint = null;
    private Point lastPointClicked = null;
    private Point2D lastWCPointClicked = null;
    private Color lineColorBorder = new Color(199, 0, 0);
    private Stroke lineBorderStroke = new BasicStroke(2.0f);
    private Color vertexColorCenter = new Color(0, 0, 255, 255);
    private Color vertexColorBorder = new Color(0, 0, 255);
    private Color snapColorCenter = new Color(255, 0, 0, 255);
    private Color snapColorBorder = new Color(255, 0, 0);
    private Stroke vertexBorderStroke = new BasicStroke(2.0f);
    private AnimatedStroke ghostAnimatedStroke = null;
    private Drawable ghostSegment = null;
    private MapUndoManager undoManager = null;
    private Tool tool = null;
    private EventListenerList listenerList = new EventListenerList();

    public NewGeometryLayer(MapCanvas canvas) {
        super(canvas);
        this.properties.setDefaultProperty("oracle.maps.core.Layer.name", "New Geometry Layer");
        this.ghostAnimatedStroke = new AnimatedStroke(Color.yellow);
        this.ghostAnimatedStroke.setDash(new float[]{4.0f, 4.0f});
        this.ghostAnimatedStroke.setWidth(3.0f);
    }

    @Override
    public void setShape(Shape shape) {
        if (this.drawable == null) {
            this.drawable = new Drawable();
        }
        this.drawable.setShape(shape, 2);
        this.buildVertexes();
    }

    @Override
    public void clear() {
        this.vertexes.clear();
        this.drawable = null;
        this.cursorPoint = null;
        this.snapPoint = null;
    }

    public Shape getShape() {
        if (this.drawable == null) {
            return null;
        }
        return this.drawable.getShape();
    }

    public void setCursorPoint(Point pt) {
        this.cursorPoint = pt;
    }

    public void setSnapPoint(Point pt) {
        this.snapPoint = pt;
    }

    @Override
    public void shapeCompleted(MouseEvent e) {
    }

    @Override
    public Point2D getSnapPoint(Point2D point) {
        return point;
    }

    @Override
    public boolean isMyEvent(EventObject evt) {
        if (evt instanceof MouseWheelEvent) {
            return false;
        }
        this.cursorPoint = null;
        if (this.canvas == null) {
            return false;
        }
        Layer targetLayer = this.canvas.getLayerManager().getLayerByTag("targetLayer");
        return targetLayer != null;
    }

    @Override
    public void handleTheEvent(EventObject evt) {
        if (evt instanceof MouseEvent) {
            this.tool.handleEvent(evt);
        }
    }

    @Override
    public long render(Graphics2D g) {
        if (this.drawable != null && this.drawable.getShape() != null) {
            if (this.drawable.getShape() instanceof Rectangle2D) {
                Shape draw = null;
                draw = this.drawable.getShape();
                float BOX_BORDER_ALPHA = 0.4f;
                float BOX_BKGND_ALPHA = 0.25f;
                Composite origComposite = g.getComposite();
                g.setColor(Color.BLUE);
                g.setComposite(AlphaComposite.getInstance(3, BOX_BKGND_ALPHA));
                g.fill(draw);
                g.setComposite(AlphaComposite.getInstance(3, BOX_BORDER_ALPHA));
                g.draw(draw);
                g.setComposite(origComposite);
            } else {
                g.setColor(this.lineColorBorder);
                g.setStroke(this.lineBorderStroke);
                this.drawable.draw(g);
            }
        } else {
            this.vertexes.clear();
        }
        if (this.ghostSegment != null) {
            g.setColor(this.ghostAnimatedStroke.getColor());
            g.setStroke(this.ghostAnimatedStroke.getStroke());
            this.ghostSegment.draw(g);
        }
        if (this.vertexes.size() > 0) {
            for (int i = 0; i < this.vertexes.size(); ++i) {
                this.drawPoint(g, this.vertexes.get(i), false);
            }
        }
        if (this.cursorPoint != null) {
            this.drawPoint(g, this.cursorPoint, false);
        }
        if (this.snapPoint != null) {
            this.drawPoint(g, this.snapPoint, true);
        }
        return 0L;
    }

    private void drawPoint(Graphics2D g, Point point, boolean isSnapPoint) {
        if (point == null) {
            return;
        }
        Object aa = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (!isSnapPoint) {
            g.setColor(this.vertexColorBorder);
        } else {
            g.setColor(this.snapColorBorder);
        }
        g.setStroke(this.vertexBorderStroke);
        double cx = point.getX();
        double cy = point.getY();
        double w = 8.0;
        double h = 8.0;
        g.drawOval((int)(cx - w * 0.5 - 2.0), (int)(cy - h * 0.5 - 2.0), (int)(w + 4.0), (int)(h + 4.0));
        if (!isSnapPoint) {
            g.setColor(this.vertexColorCenter);
        } else {
            g.setColor(this.snapColorCenter);
        }
        g.setStroke(this.lineBorderStroke);
        g.drawLine((int)(cx - 2.5), (int)cy, (int)(cx + 2.5), (int)cy);
        g.drawLine((int)cx, (int)(cy - 2.5), (int)cx, (int)(cy + 2.5));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aa);
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent changeEvent = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(changeEvent);
        }
    }

    public Point getLastPointClicked() {
        return this.lastPointClicked;
    }

    public Point2D getLastWCPointClicked() {
        return this.lastWCPointClicked;
    }

    private void buildVertexes() {
        this.vertexes.clear();
        if (this.drawable == null || this.drawable.getShape() == null || this.drawable.getShape() instanceof Rectangle2D) {
            return;
        }
        PathIterator pi = this.drawable.getShape().getPathIterator(null);
        boolean foundFirst = false;
        double[] seg = new double[6];
        double x1 = 0.0;
        double y1 = 0.0;
        double xk = 0.0;
        double yk = 0.0;
        while (!pi.isDone()) {
            switch (pi.currentSegment(seg)) {
                case 0: 
                case 1: {
                    if (!foundFirst) {
                        foundFirst = true;
                    }
                    xk = seg[0];
                    yk = seg[1];
                    this.vertexes.add(new Point((int)xk, (int)yk));
                    break;
                }
                case 4: {
                    break;
                }
                case 3: {
                    if (!foundFirst) {
                        x1 = seg[0];
                        y1 = seg[1];
                        this.vertexes.add(new Point((int)x1, (int)y1));
                        foundFirst = true;
                    }
                    xk = seg[2];
                    yk = seg[3];
                    this.vertexes.add(new Point((int)xk, (int)yk));
                    xk = seg[4];
                    yk = seg[5];
                    this.vertexes.add(new Point((int)xk, (int)yk));
                    break;
                }
                case 2: {
                    if (!foundFirst) {
                        x1 = seg[0];
                        y1 = seg[1];
                        this.vertexes.add(new Point((int)x1, (int)y1));
                        foundFirst = true;
                    }
                    xk = seg[2];
                    yk = seg[3];
                    this.vertexes.add(new Point((int)xk, (int)yk));
                }
            }
            pi.next();
        }
    }

    public void setGhostSegment(Shape shape) {
        this.ghostSegment = shape == null ? null : new Drawable(shape, 2);
    }

    @Override
    public void update(long elapsedTime) {
        this.ghostAnimatedStroke.update(elapsedTime);
    }

    public void setTool(Tool tool) {
        this.tool = tool;
    }
}

